package com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.constants.CommonConstant;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.TreeParser;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrServiceImpl;
import com.yeejoin.amos.boot.module.tzs.api.dto.BaseUnitLicenceDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.BaseUnitLicence;
import com.yeejoin.amos.boot.module.tzs.api.entity.RegUnitInfo;
import com.yeejoin.amos.boot.module.tzs.api.service.IRegUnitInfoService;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.BaseUnitLicenceServiceImpl;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.RegUnitIcDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.RegUnitInfoDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.RegUnitIc;
import com.yeejoin.amos.boot.module.tzs.flc.api.enums.UnitReviewStateEnum;
import com.yeejoin.amos.boot.module.tzs.flc.api.mapper.RegUnitInfoMapper;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.privilege.model.RoleModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 单位注册信息表服务实现类
 *
 * @author system_generator
 * @date 2022-08-09
 */
@Service
public class RegUnitInfoServiceImpl extends BaseService<RegUnitInfoDto, RegUnitInfo, RegUnitInfoMapper> implements IRegUnitInfoService {

    @Autowired
    BaseUnitLicenceServiceImpl baseUnitLicenceService;

    @Autowired
    DataDictionaryServiceImpl iDataDictionaryService;

    @Autowired
    OrgUsrServiceImpl iOrgUsrService;

    @Autowired
    RegUnitIcServiceImpl regUnitIcService;

    /**
     * 使用单位的类型，数据来源：cb_data_dictionary code = 1051
     */
    private static String USE_UNIT_TYPE_CODE = "1051";

    /**
     * 单位类型，数据来源：cb_data_dictionary type = UNIT_TYPE
     */
    private static String DICT_TYPE_UNIT_TYPE = "UNIT_TYPE";


    @Override
    @Transactional(rollbackFor = Exception.class)
    public RegUnitInfoDto registerUnit(RegUnitInfoDto model) {
        // 1.插入注册单位基本信息表：tz_flc_reg_unit_info
        RegUnitInfo regUnitInfo = new RegUnitInfo();
        // 注册用统一信用码注册，默认证件类型为营业执照，数据来源：cb_data_dictionary code = 1060
        model.setUnitType("营业执照");
        model.setUnitTypeCode("1060");
        Bean.copyExistPropertis(model, regUnitInfo);
        // 2.插入单位注册许可信息表：tz_base_unit_licence
        List<BaseUnitLicenceDto> unitLicenceDtos = model.getUnitLicences();
        List<BaseUnitLicence> baseUnitLicences = unitLicenceDtos.stream().map(s -> {
            BaseUnitLicence target = new BaseUnitLicence();
            Bean.copyExistPropertis(s, target);
            return target;
        }).collect(Collectors.toList());
        baseUnitLicenceService.saveOrUpdateBatch(baseUnitLicences);
        // 3.插入工商单位信息表：tz_flc_reg_unit_ic
        RegUnitIc regUnitIc = new RegUnitIc();
        model.getRegUnitIc().setUnitCode(model.getUnitCode());
        model.getRegUnitIc().setUnitName(model.getName());
        Bean.copyExistPropertis(model.getRegUnitIc(), regUnitIc);
        regUnitIcService.save(regUnitIc);
        // 4.调用平台进行创建单位、用户信息,同步用户信息
        if (UnitReviewStateEnum.NO_NEED_REVIEW.getCode().equals(model.getState())) {
            // 4.1 自动创建：调用平台进行创建单位、用户信息
            createCompanyAndUser(regUnitInfo);
            // 4.2 todo 同步用户信息 需要吴江提交表相关代码
        }
        this.save(regUnitInfo);
        // 5.组织返回数据
        // 5.1企业基本信息
        Bean.copyExistPropertis(regUnitInfo, model);
        // 5.2行政许可数据
        model.setUnitLicences(Bean.toModels(baseUnitLicences, BaseUnitLicenceDto.class));
        //  5.3工商信息
        model.setRegUnitIc(Bean.toModel(regUnitIc, new RegUnitIcDto()));
        return model;
    }

    @Override
    public RegUnitInfoDto unitCheck(String unitCode, String unitType) {
        // 1.校验重复性
        RegUnitInfo regUnitInfo = this.getOne(new LambdaQueryWrapper<RegUnitInfo>().eq(RegUnitInfo::getUnitCode, unitCode));
        if (regUnitInfo != null) {
            throw new RuntimeException("该单位已注册，请联系企业管理员！");
        }
        // 2.组织返回数据
        RegUnitInfoDto regUnitInfoDto = new RegUnitInfoDto();
        if (USE_UNIT_TYPE_CODE.equals(unitType)) {
            // 2.1 使用单位调用行政许可系统接口进行查询工商信息
            // 2.2 工商信息组装
        } else {
            RegUnitIc regUnitIc = regUnitIcService.getOne(new LambdaQueryWrapper<RegUnitIc>().eq(RegUnitIc::getUnitCode, unitCode));
            regUnitInfoDto.setRegUnitIc(Bean.toModel(regUnitIc, new RegUnitIcDto()));
        }
        // 2.3 许可信息组装
        List<BaseUnitLicence> unitLicences = baseUnitLicenceService.list(new LambdaQueryWrapper<BaseUnitLicence>().eq(BaseUnitLicence::getUnitCode, unitCode));
        regUnitInfoDto.setUnitLicences(Bean.toModels(unitLicences, BaseUnitLicenceDto.class));
        return regUnitInfoDto;
    }

    @Override
    public List<DataDictionary> getUnitTypeList() {
        return iDataDictionaryService.getByType(DICT_TYPE_UNIT_TYPE);
    }

    @Override
    public Collection<CompanyModel> getManagementUnitTree() {
        // 组织架构中单位级别为：省级、地市级、区县级的单位
        Collection<CompanyModel> companyModels = Privilege.companyClient.companyTreeWithoutAuth().getResult();
        return companyModels.stream().filter(c-> "headquarter".equals(c.getLevel()) || "prefecture-level".equals(c.getLevel()) || "county".equals(c.getLevel())).peek(n->{
            this.dealChildCompany(n.getChildren());
        }).collect(Collectors.toList());
    }

    private void dealChildCompany(Collection children){
        children.stream().filter(n->{
            CompanyModel c = JSONObject.parseObject(JSON.toJSONString(n),CompanyModel.class);
            return "headquarter".equals(c.getLevel()) || "prefecture-level".equals(c.getLevel()) || "county".equals(c.getLevel());
        }).peek(n->{
            CompanyModel c = JSONObject.parseObject(JSON.toJSONString(n),CompanyModel.class);
            dealChildCompany(c.getChildren());
        }).collect(Collectors.toList());
    }

    private void createCompanyAndUser(RegUnitInfo regUnitInfo) {
        FeignClientResult<List<RoleModel>> roleListResult = Privilege.roleClient.queryRoleList(null, null);
        List<RoleModel> allRoleList = roleListResult.getResult();
        List<RoleModel> userRoleList;
        List<Long> roleIds = new ArrayList<>();
        Set<String> roleNameSet = new HashSet<>();
        // 3.1创建公司
        CompanyModel companyInfo = new CompanyModel();
        companyInfo.setAddress(regUnitInfo.getProvince() + regUnitInfo.getCity() + regUnitInfo.getDistrict() + regUnitInfo.getStree() + regUnitInfo.getCommunity() + regUnitInfo.getAddress());
        companyInfo.setAgencyCode("tzs");
        companyInfo.setParentId(Long.parseLong(regUnitInfo.getManagementUnitId()));
        companyInfo.setLevel("company");
        companyInfo.setCompanyName(regUnitInfo.getName());
        companyInfo.setContact(regUnitInfo.getLegalPersonTel());
        FeignClientResult<CompanyModel> companyResult = Privilege.companyClient.create(companyInfo);
        if (companyResult == null || companyResult.getResult() == null) {
            throw new BadRequest("单位注册失败");
        }
        String adminUserName = regUnitInfo.getAdminName();
        String loginName = regUnitInfo.getAdminLoginName();
        String pwd = regUnitInfo.getAdminLoginPwd();
        String adminTel = regUnitInfo.getAdminTel();
        // 3.2 创建平台用户
        companyInfo = companyResult.getResult();
        AgencyUserModel agencyUserModel = new AgencyUserModel();
        agencyUserModel.setUserName(loginName);
        agencyUserModel.setRealName(adminUserName);
        agencyUserModel.setLockStatus("UNLOCK");
        agencyUserModel.setPassword(pwd);
        agencyUserModel.setRePassword(pwd);
        agencyUserModel.setAgencyCode("tzs");
        agencyUserModel.setMobile(adminTel);
        String unitTypeCode = regUnitInfo.getUnitTypeCode();
        // 根据unitTypeCode 获取应用和角色 数据字典配置
        DataDictionary unitType = iDataDictionaryService.getOne(new LambdaQueryWrapper<DataDictionary>().eq(DataDictionary::getCode, unitTypeCode));
        String appCode = unitType.getTypeDesc();
        String[] appCodes = appCode.split(",");
        Set<String> appCodesSet = new HashSet<>();
        Collections.addAll(appCodesSet, appCodes);
        Map<Long, List<Long>> roleSeqMap = new HashMap<>();
        roleNameSet.add(unitType.getName());
        userRoleList = allRoleList.stream().filter(r -> r.getRoleName().equals(unitType.getName())).collect(Collectors.toList());
        userRoleList.forEach(r -> {
            roleIds.add(r.getSequenceNbr());
        });
        roleSeqMap.put(companyInfo.getSequenceNbr(), roleIds);
        agencyUserModel.setAppCodes(new ArrayList<>(appCodesSet));
        Map<Long, List<RoleModel>> orgRoles = new HashMap<>();
        orgRoles.put(companyInfo.getSequenceNbr(), userRoleList);
        agencyUserModel.setOrgRoles(orgRoles);
        agencyUserModel.setOrgRoleSeqs(roleSeqMap);
        FeignClientResult<AgencyUserModel> userResult;
        try {
            userResult = Privilege.agencyUserClient.create(agencyUserModel);
        } catch (InnerInvokException e) {
            // 删除已经创建的 企业信息
            Privilege.companyClient.deleteCompany(companyInfo.getSequenceNbr() + "");
            throw new BadRequest(e.getMessage());
        }

        if (userResult == null || userResult.getResult() == null) {
            throw new BadRequest("注册失败");
        }
        // 3.3 org_user 创建组织机构
        OrgUsr org = new OrgUsr();
        org.setBizOrgCode(TreeParser.genTreeCode());
        org.setBizOrgType(CommonConstant.BIZ_ORG_TYPE_COMPANY);
        org.setBizOrgName(regUnitInfo.getName());
        org.setRecDate(new Date());
        org.setRecUserId(userResult.getResult().getUserId());
        org.setRecUserName(userResult.getResult().getUserName());
        org.setAmosOrgId(companyInfo.getSequenceNbr() + "");
        org.setAmosOrgCode(companyInfo.getOrgCode());
        iOrgUsrService.save(org);
        regUnitInfo.setOrgUserId(org.getSequenceNbr());
    }
}