package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 车用气瓶业务
 *
 * @author system_generator
 * @date 2024-03-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_jg_vehicle_information")
public class JgVehicleInformation extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 设备监管码
     */
	@TableField("supervisory_code")
    private String supervisoryCode;

    /**
     * 使用单位名称
     */
	@TableField("use_unit_name")
    private String useUnitName;

    /**
     * 申请编号
     */
	@TableField("apply_no")
    private String applyNo;

    /**
     * 办理状态
     */
	@TableField("audit_status")
    private String auditStatus;

    /**
     * 接收机构
     */
	@TableField("receive_org_name")
    private String receiveOrgName;

    /**
     * 检验单位
     */
	@TableField("inspect_unit_name")
    private String inspectUnitName;

    /**
     * 检验结果照片
     */
	@TableField("inspect_result_photo")
    private String inspectResultPhoto;

    /**
     * 检验结果
     */
	@TableField("inspect_result")
    private String inspectResult;

    /**
     * 终审通过时间
     */
	@TableField("audit_pass_date")
    private Date auditPassDate;

    /**
     * 登记类别
     */
	@TableField("reg_type")
    private String regType;

    /**
     * 注册登记日期
     */
	@TableField("reg_date")
    private Date regDate;

    /**
     * 注册登记人员ID
     */
	@TableField("reg_person_id")
    private String regPersonId;

    /**
     * 注册登记人员
     */
	@TableField("reg_person_name")
    private String regPersonName;

    /**
     * 安装单位名称
     */
	@TableField("install_unit_name")
    private String installUnitName;

    /**
     * 安装单位代码
     */
    @TableField("install_unit_code")
    private String installUnitCode;

    /**
     * 状态
     */
    @TableField("status")
    private String status;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

    /**
     * 创建人ID
     */
	@TableField("create_user_id")
    private String createUserId;

    /**
     * 创建人名称
     */
    @TableField("create_user_name")
    private String createUserName;

    /**
     * 创建时间
     */
	@TableField("create_date")
    private Date createDate;

    /**
     * 录入单位ID
     */
	@TableField("input_unit_no")
    private String inputUnitNo;

    /**
     * 使用登记编号
     */
	@TableField("use_registration_code")
    private String useRegistrationCode;

    /**
     * 流程实例id
     */
	@TableField("instance_id")
    private String instanceId;

    /**
     * 使用单位统一信用代码
     */
	@TableField("use_unit_credit_code")
    private String useUnitCreditCode;

    /**
     * 检验机构代码
     */
	@TableField("inspect_unit_credit_code")
    private String inspectUnitCreditCode;

    /**
     * 流程状态
     */
	@TableField("instance_status")
    private String instanceStatus;

    /**
     * 接收机构代码
     */
	@TableField("receive_org_code")
    private String receiveOrgCode;

    /**
     * 接收机构公司代码
     */
	@TableField("receive_company_code")
    private String receiveCompanyCode;

    /**
     * 下一执行节点ids
     */
	@TableField("next_execute_ids")
    private String nextExecuteIds;

    /**
     * 发起人id用于撤回操作
     */
	@TableField("promoter")
    private String promoter;

    /**
     * 使用登记证书附件
     */
	@TableField("use_registration_certificate")
    private String useRegistrationCertificate;

    /**
     * 工作流下一节点任务id
     */
	@TableField("next_task_id")
    private String nextTaskId;

    /**
     * 下一节点可执行人逗号分割
     */
	@TableField("next_execute_user_ids")
    private String nextExecuteUserIds;

    /**
     * 是否西咸，1是 0否
     */
	@TableField("is_xixian")
    private String isXixian;

    /**
     * 使用单位地点
     */
	@TableField("use_unit_address")
    private String useUnitAddress;

    /**
     * 转办后执行人的Id逗号分割
     */
	@TableField("transfer_to_user_ids")
    private String transferToUserIds;

    /**
     * 其他附件
     */
	@TableField("other_accessories")
    private String otherAccessories;

    /**
     * 安装日期
     */
	@TableField("installation_data")
    private Date installationData;

    /**
     * 车辆属性
     */
	@TableField("vehicle_attribute")
    private String vehicleAttribute;

    /**
     * 车辆属地
     */
	@TableField("vehicle_apanage")
    private String vehicleApanage;

    /**
     * 气瓶数量
     */
	@TableField("gas_num")
    private Integer gasNum;

    /**
     * 号牌号码
     */
	@TableField("car_number")
    private String carNumber;

    /**
     * 车架号码
     */
	@TableField("identification_code")
    private String identificationCode;

    /**
     * 发动机号
     */
	@TableField("engine_number")
    private String engineNumber;

    /**
     * 车辆品牌型号
     */
	@TableField("car_brand_model")
    private String carBrandModel;

    /**
     * 车主姓名
     */
	@TableField("owner_name")
    private String ownerName;

    /**
     * 联系电话
     */
	@TableField("contact_number")
    private String contactNumber;

    /**
     * 充装介质
     */
	@TableField("filling_medium")
    private String fillingMedium;

    /**
     * 设备品种(特种气瓶)
     */
	@TableField("equipment_variety")
    private String equipmentVariety;

    /**
     * 容积
     */
	@TableField("volume")
    private String volume;

    /**
     * 加装方式
     */
	@TableField("installation_mode")
    private String installationMode;

    /**
     * 车辆年审日期
     */
	@TableField("vehicle_review_date")
    private Date vehicleReviewDate;

    /**
     * 身份证正面附件
     */
	@TableField("id_card_front")
    private String idCardFront;

    /**
     * 身份证背面附件
     */
	@TableField("id_card_back")
    private String idCardBack;

    /**
     * 行驶证正面附件
     */
	@TableField("drive_license_front")
    private String driveLicenseFront;

    /**
     * 行驶证背面附件
     */
	@TableField("drive_license_back")
    private String driveLicenseBack;

    /**
     * 机动车登记证书附件
     */
	@TableField("vehicle_registration_certificate")
    private String vehicleRegistrationCertificate;

    /**
     * 监督检验证书附件
     */
	@TableField("inspection_certificate")
    private String inspectionCertificate;

    /**
     * 备案通知单附件
     */
	@TableField("filing_notice")
    private String filingNotice;

    /**
     * 属地监管部门code
     */
    @TableField(value = "org_branch_code")
    private String orgBranchCode;

    /**
     * 属地监管部门name
     */
    @TableField(value = "org_branch_name")
    private String orgBranchName;

    /**
     * 下次检验日期
     */
    @TableField("next_inspection_date")
    private Date nextInspectionDate;

    @TableField(value = "safety_manager_id")
    private String safetyManagerId;

    @TableField(value = "safety_manager_name")
    private String safetyManagerName;

    @TableField(value = "estate_unit_credit_code")
    private String estateUnitCreditCode;

    @TableField(value = "estate_unit_name")
    private String estateUnitName;
}
