package com.yeejoin.amos.boot.module.jyjc.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionResultModel;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcInspectionResultServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * @author system_generator
 * @date 2023-12-14
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/jyjc-inspection-result")
public class JyjcInspectionResultController extends BaseController {

    @Autowired
    JyjcInspectionResultServiceImpl jyjcInspectionResultServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<JyjcInspectionResultModel> save(@RequestBody JyjcInspectionResultModel model) {
        model = jyjcInspectionResultServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<JyjcInspectionResultModel> updateBySequenceNbrJyjcInspectionResult(@RequestBody JyjcInspectionResultModel model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(jyjcInspectionResultServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jyjcInspectionResultServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public ResponseModel<Map<String, Object>> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(jyjcInspectionResultServiceImpl.queryDetailBySeq(sequenceNbr));
    }


    /**
     * 列表全部数据查询
     *getJyjcPersonByUnitCode
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<JyjcInspectionResultModel>> selectForList() {
        return ResponseHelper.buildResponse(jyjcInspectionResultServiceImpl.queryForJyjcInspectionResultList());
    }

    /**
     * 列表页面(报检单位）
     *
     * @param current 当前页
     * @param size    当前页大小
     * @param model   查询参数
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/applicationUnitPage")
    @ApiOperation(httpMethod = "Post", value = "列表页面(报检单位）", notes = "列表页面(报检单位）")
    public ResponseModel<Page<JyjcInspectionResultModel>> applicationUnitQueryForPage(
            @RequestParam int current, @RequestParam int size,
            @RequestBody JyjcInspectionResultModel model) {
        Page<JyjcInspectionResultModel> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(jyjcInspectionResultServiceImpl.queryForJyjcInspectionResultPage(page, model, false));
    }

    /**
     * 列表页面(检验检测单位）
     *
     * @param current 当前页
     * @param size    当前页大小
     * @param model   查询参数
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/inspectionUnitPage")
    @ApiOperation(httpMethod = "POST", value = "列表页面(检验检测单位）", notes = "列表页面(检验检测单位）")
    public ResponseModel<Page<JyjcInspectionResultModel>> inspectionUnitQueryForPage(
            @RequestParam int current, @RequestParam int size,
            @RequestBody JyjcInspectionResultModel model) {
        Page<JyjcInspectionResultModel> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(jyjcInspectionResultServiceImpl.queryForJyjcInspectionResultPage(page, model, true));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/page")
    @ApiOperation(httpMethod = "POST", value = "列表页面(检验检测单位、使用单位共用）", notes = "列表页面(检验检测单位、使用单位共用）")
    public ResponseModel<Page<JyjcInspectionResultModel>> pageList(
            @RequestParam int current, @RequestParam int size,
            @RequestBody JyjcInspectionResultModel model) {
        Page<JyjcInspectionResultModel> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(jyjcInspectionResultServiceImpl.queryForPageList(page, model));
    }



    /**
	 * 检验结果-上传结果和编辑结果
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/updateResult")
	@ApiOperation(httpMethod = "PUT", value = "检验结果-上传结果和编辑结果", notes = "检验结果-上传结果和编辑结果")
    public ResponseModel<JyjcInspectionResultModel> updateJyjcInspectionResult(@RequestBody Map<String, Map<String, Object>> model) {
		return ResponseHelper.buildResponse(jyjcInspectionResultServiceImpl.updateJyjcInspectionResult(model));
	}


    /**
     * 获取设备种类列表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取设备种类列表", notes = "获取设备种类列表")
    @GetMapping(value = "/equipTypeList")
    public ResponseModel<List<Map<String, Object>>> equipTypeList(@RequestParam(required = false) String type, @RequestParam(required = false) String notNode) {
        return ResponseHelper.buildResponse(jyjcInspectionResultServiceImpl.equipList(type, notNode));
    }

}
