package com.yeejoin.equipmanage.common.datasync.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @ProjectName: YeeFireDataProcessRoot
 * @Package: com.yeejoin.equipmanage.common.datasync.entity
 * @ClassName: FireEquipMeasurement
 * @Author: Jianqiang Gao
 * @Description: 设备量测信息
 * @Date: 2021/3/24 11:10
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@TableName("asf_fireequipmentfirealarm")
@ApiModel(value = "FireEquipmentAlarm对象", description = "设备火灾告警数据")
public class FireEquipmentFireAlarm implements Serializable {

    private static final long serialVersionUID = 8653378898206380217L;

    @ApiModelProperty(value = "消防资产参数信息ID")
    @TableId("id")
    private String id;

    @ApiModelProperty(value = "站点名称")
    @TableField("stationname")
    private String stationName;

    @ApiModelProperty(value = "站点编码")
    @TableField("stationcode")
    private String stationCode;

    @ApiModelProperty(value = "消防资产id")
    @TableField("fireequipmentid")
    private String fireEquipmentId;

    @ApiModelProperty(value = "消防资产MRID")
    @TableField("fireequipmentmrid")
    private String fireEquipmentMRid;

    @ApiModelProperty(value = "消防资产名称")
    @TableField("fireequipmentname")
    private String fireEquipmentName;

    @ApiModelProperty(value = "测点表id")
    @TableField("equipmentmeasurementid")
    private String equipmentMeasurementId;

    @ApiModelProperty(value = "测点表mrid")
    @TableField("equipmentmeasurementmrid")
    private String equipmentMeasurementMRid;

    @ApiModelProperty(value = "字段名（英文）")
    @TableField("fieldname")
    private String fieldName;

    @ApiModelProperty(value = "中文名")
    @TableField("fieldlabel")
    private String fieldLabel;

    @ApiModelProperty(value = "属性值")
    @TableField("value")
    private String value;

    @ApiModelProperty(value = "发生频次")
    @TableField("frequency")
    private Integer frequency;

    @ApiModelProperty(value = "报警状态")
    @TableField("status")
    private Boolean status;

    @ApiModelProperty(value = "量测数据类型")
    @TableField("type")
    private String type;

    @ApiModelProperty(value = "回复时间")
    @TableField("recoverydate")
    private Date recoveryDate;

    @ApiModelProperty(value = "确认类型")
    @TableField("confirmtype")
    private String confirmType;

    @ApiModelProperty(value = "报警原因")
    @TableField("alamreason")
    private String alarmReason;

    @ApiModelProperty(value = "处理情况")
    @TableField("resolveresult")
    private String resolveResult;

    @ApiModelProperty(value = "确警人员")
    @TableField("confirmuser")
    private String confirmUser;

    @ApiModelProperty(value = "确警时间")
    @TableField("confirmdate")
    private Date confirmDate;

    @ApiModelProperty(value = "创建时间")
    @TableField("createdate")
    private Date createDate;

    @ApiModelProperty(value = "修改时间")
    @TableField("updatedate")
    private Date updateDate;

    @ApiModelProperty(value = "主资源标识")
    @TableField("mrid")
    private String mrid;

    @ApiModelProperty(value = "名称")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "别名")
    @TableField("aliasname")
    private String aliasname;

    @ApiModelProperty(value = "描述")
    @TableField("description")
    private String description;

}