package com.yeejoin.equipmanage.controller;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.dto.AreaDto;
import com.yeejoin.equipmanage.common.entity.Area;
import com.yeejoin.equipmanage.common.vo.AreaResquest;
import com.yeejoin.equipmanage.common.vo.AreaTreeVo;
import com.yeejoin.equipmanage.service.IAreaService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 区域
 *
 * @author duanwei
 * @date 2021-04-27
 */
@RestController
@Api(tags = "区域Api")
@RequestMapping(value = "/area", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class AreaController extends AbstractBaseController {

	@Autowired
	IAreaService iAreaService;

	/**
	 * 获取区域树
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("区域树")
	@GetMapping(value = "/tree")
	public List<AreaTreeVo> getAreaTree() {
		return iAreaService.getAreaTreeVo();
	}

	/**
	 * 根据节点id获取树
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("区域树")
	@GetMapping(value = "/treeById")
	public List<AreaTreeVo> getAreaTreeById(@RequestParam Long id) {
		if (id == null) {
			id = -1L;
		}
		return iAreaService.getAreaTreeVoById(id);
	}

	/**
	 * 获取指定层级区域树，起步2级树
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("获取指定层级区域树")
	@GetMapping(value = "/getAreaTierTree")
	public List<AreaDto> getAreaTierTree(@RequestParam Integer tier) {
		return iAreaService.getAreaTierTree(tier);
	}

	/**
	 * 根据父节点查询
	 */
	@RequestMapping(value = "/lists", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<AreaResquest> listPage(Page page, Area area) {
		return iAreaService.areaList(page, area);
	}

	/**
	 * 保存数据
	 */
	@RequestMapping(value = "/saveArea", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "新增区域", notes = "新增新增区域")
	public Object saveArea(@RequestBody AreaResquest areaResquest) {
		return iAreaService.saveArea(areaResquest);
	}

	/**
	 * 保存数据
	 */
	@RequestMapping(value = "/updateArea", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "修改区域", notes = "修改新增区域")
	public Object updateArea(@RequestBody AreaResquest areaResquest) {
		return iAreaService.updateArea(areaResquest);
	}

	/**
	 * 删除数据
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "删除")
	@DeleteMapping(value = "/{instanceId}")
	public int delete(@PathVariable Long instanceId) {
		return iAreaService.deleteArea(instanceId);
	}

	/**
	 * 根据id查询
	 *
	 * @param instanceId
	 * @return
	 */
	@RequestMapping(value = "/getOne", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public Map<String, Object> selectById(@RequestParam Long instanceId) {
		return iAreaService.getById(instanceId);
	}

}
