package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.equipmanage.common.entity.FormGroup;
import com.yeejoin.equipmanage.common.entity.SystemDic;
import com.yeejoin.equipmanage.common.entity.vo.AppDownloadVO;
import com.yeejoin.equipmanage.common.enums.GroupCodeEnum;
import com.yeejoin.equipmanage.common.utils.FileUploadFactory;
import com.yeejoin.equipmanage.common.utils.FileUploadTypeEnum;
import com.yeejoin.equipmanage.common.utils.ImportFile;
import com.yeejoin.equipmanage.common.vo.BuildingTreeVo;
import com.yeejoin.equipmanage.mapper.EquipmentMapper;
import com.yeejoin.equipmanage.service.*;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.Bean;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@Service
public class DownloadFileService implements IDownloadFileService {

    @Autowired
    @Lazy
    private FileUploadFactory factory;
    @Autowired
    private IFormInstanceService iFormInstanceService;
    @Autowired
    private IFormGroupService iFormGroupService;
    @Autowired
    private ICarService carService;
    @Autowired
    private EquipmentMapper equipmentMapper;
    @Autowired
    private IExtinguishantOnCarService extinguishantOnCarService;
    @Autowired
    private IEquipmentIndexService equipmentIndexService;
    @Autowired
    private IEquipmentSpecificIndexSerivce equipmentSpecificIndexSerivce;
    @Autowired
    private IWarehouseStructureService warehouseStructureService;
    @Autowired
    private ISystemDicService systemDicService;
    @Autowired
    private IEquipmentOnCarService equipmentOnCarService;

    @Resource(name = "fileUploadFactory")
    public void setFactory(FileUploadFactory factory) {
        this.factory = factory;
    }

    @Override
    public HSSFWorkbook DownloadFile(String type) {
        ImportFile up = factory.create(FileUploadTypeEnum.getEnum(type));
        HSSFWorkbook workbook = (HSSFWorkbook) up.downloadImportFile();
        return workbook;
    }

    @Override
    public AppDownloadVO appDownloadDatas() {
        AppDownloadVO appDownload = new AppDownloadVO();

        //建筑信息
        FormGroup formGroup = iFormGroupService.getByUniqueKey(GroupCodeEnum.ALL_BUILDING.getGroupCode());
        List<Map<String, Object>> allList = iFormInstanceService.getSpecialChildrenList(null);
        List<BuildingTreeVo> allListVo = buildBuildingData(formGroup, allList);
        appDownload.setBuildTree(allListVo);

        //车辆信息
        appDownload.setDownloadCarDatas(carService.list());

        //装备信息

//		appDownload.setDownloadEquipmentDatas(equipmentMapper.getDownloadEquipmentData());
//
//		//性能指标模板
//		appDownload.setEquipmentIndex(equipmentIndexService.list(queryWrapper1));
//
//		//性能指标
//		appDownload.setEquipmentSpecificIndexs(equipmentSpecificIndexSerivce.list(queryWrapper));

        //仓库
        appDownload.setWarehouseStructure(warehouseStructureService.list());

        //车载装备
        appDownload.setEquipmentOnCar(equipmentOnCarService.list());

        //车载灭火药剂
        appDownload.setExtinguishantOnCar(extinguishantOnCarService.list());

        //报废原因
        appDownload.setReason(systemDicService.list(new QueryWrapper<SystemDic>().eq("type", "ScrapReason")));

        return appDownload;
    }

    /**
     * 建筑树数据处理
     *
     * @param formGroup
     * @param allList
     * @return
     */
    private List<BuildingTreeVo> buildBuildingData(FormGroup formGroup, List<Map<String, Object>> allList) {
        List<BuildingTreeVo> allListVo = Bean.listMap2ListBean(allList, BuildingTreeVo.class);
        BuildingTreeVo treeNode = new BuildingTreeVo();
        treeNode.setInstanceId(formGroup.getId());
        treeNode.setInstanceName(formGroup.getGroupName());
        treeNode.setParentId("-1");
        treeNode.setGroupType(formGroup.getGroupType());
        treeNode.setGroupCode(formGroup.getGroupCode());
        allListVo.add(treeNode);
        return allListVo;
    }

}

