package com.yeejoin.amos.boot.module.common.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 单位下摄像头表
 *
 * @author system_generator
 * @date 2024-10-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="BaseEnterpriseVideoDto", description="单位下摄像头表")
public class BaseEnterpriseVideoDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "获取token地址")
    private String tokenUrl;

    @ApiModelProperty(value = "获取播放地址")
    private String url;

    @ApiModelProperty(value = "对接信息标识")
    private String appKey;

    @ApiModelProperty(value = "对接信息密匙")
    private String appSecret;

    @ApiModelProperty(value = "设备序列号")
    private String deviceSerial;

    @ApiModelProperty(value = "流播放协议，1-ezopen、2-hls、3-rtmp、4-flv，默认为1")
    private String protocol;

    @ApiModelProperty(value = "通道号")
    private String channelNo;

    @ApiModelProperty(value = "过期时长，单位秒；针对hls/rtmp/flv设置有效期，相对时间；30秒-720天")
    private Long expireTime;

    @ApiModelProperty(value = "单位唯一标识")
    private String useUnitCode;

    @ApiModelProperty(value = "摄像头所在位置行政区域，拼接树使用（企业无此字段故冗余此字段）")
    private String regionCode;

    @ApiModelProperty(value = "标识什么设种类使用的摄像头")
    private String equListCode;

}
