package com.yeejoin.amos.boot.module.tcm.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 注册登记信息表
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="registerInfo", description="注册登记信息")
public class RegistrationInfoModel extends BaseDto {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "")
    private String instanceId;
    @ApiModelProperty(value = "")
    private String status;
    @ApiModelProperty(value = "登记机关")
    private String organizationName;
    @ApiModelProperty(value = "使用登记证编号")
    private String useOrgCode;
    @ApiModelProperty(value = "设备代码")
    private String equCode;
    @ApiModelProperty(value = "注册状态")
    private String registerState;
    @ApiModelProperty(value = "设备种类")
    private String equList;
    @ApiModelProperty(value = "设备类别")
    private String equCategory;
    @ApiModelProperty(value = "产品名称")
    private String productName;
    @ApiModelProperty(value = "品牌名称")
    private String brandName;
    @ApiModelProperty(value = "设备型号")
    private String equType;
    @ApiModelProperty(value = "设备总价值（万元）")
    private BigDecimal equPrice;
    @ApiModelProperty(value = "注册附件")
    private String useRegistrationCertificate;
    @ApiModelProperty(value = "使用标志附件")
    private String useSign;
    @ApiModelProperty(value = "产品照片附件")
    private String productPhoto;

    @ApiModelProperty(value = "登记机关组织机构代码")
    private String organizationCode;
    @ApiModelProperty(value = "设备品种")
    private String equDefine;
    @ApiModelProperty(value = "车辆牌号")
    private String carNumber;
    @ApiModelProperty(value = "车架编号")
    private String frameNumber;
    @ApiModelProperty(value = "发动机编号")
    private String engineNumber;
    @ApiModelProperty(value = "电动机编号")
    private String motorNumber;


}
