package com.yeejoin.amos.boot.module.common.api.dto;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.Date;

/**
 * @author Administrator
 * Excel导入错误日志
 */
@Data
@Accessors(chain = true)
@Document(indexName = "excel_import_error_log", shards = 2)
public class ExcelImportErrorLogDto {
    @Id
    private Long sequenceNbr;

    @Field(type = FieldType.Keyword)
    private String xaSerial;

    @Field(type = FieldType.Keyword)
    private String record;

    @Field(type = FieldType.Text)
    private String errorInfo;

    @Field(type = FieldType.Text)
    private String traceInfo;

    @Field(type = FieldType.Date, format = DateFormat.date_hour_minute)
    private Date createTime;
}
