package com.yeejoin.amos.boot.module.common.api.dto;

import java.io.Serializable;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
/**
* 表表单初始值
*
* @author tb
* @date 2021-06-17
*/
@Data
@ApiModel(value="DynamicFormInstanceDto", description="表单初始值")
public class DynamicFormInitDto implements Serializable{

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "表单key")
    private String key;

    @ApiModelProperty(value = "表单名称")
    private String label;

    @ApiModelProperty(value = "表单类型")
    private String type;

    @ApiModelProperty(value = "表单默认值")
    private Object defaultValue;
    
    @ApiModelProperty(value = "表单值")
    private SelectItems data = new SelectItems();

    @ApiModelProperty(value = "提交表单附加字段")
    private DynamicFormInstanceDto   formItemDescr;
    
    @ApiModelProperty(value = "配置")
    private String columnConfig;
    
    private int sort;

  @ApiModelProperty(value = "接口地址")
  private String url;
    
	public DynamicFormInitDto() {
		
		super();
	}
	public DynamicFormInitDto(String key, String label, String type, SelectItems data, String columnConfig) {
		super();		
		this.key = key;
		this.label = label;
		this.type = type;
		this.data = data;
		this.columnConfig = columnConfig;
	}

    

}
