package com.yeejoin.amos.supervision.dao.entity;

import org.hibernate.annotations.Where;

import javax.persistence.*;


/**
 * 检查项
 */
@Entity
@Table(name = "p_input_item")
@NamedQuery(name = "InputItem.findAll", query = "SELECT c FROM InputItem c")
@Where(clause = "is_delete=0")//表示未删除的数据
public class InputItem extends BasicEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 分类ID
     */
    @Column(name = "catalog_id")
    private Long catalogId;

    /**
     * 创建者
     */
    @Column(name = "create_by")
    private String createBy;

    /**
     * 配置JSON
     */
    @Lob
    @Column(name = "data_json")
    private String dataJson;

    /**
     * 默认值
     */
    @Column(name = "default_value")
    private String defaultValue;

    /**
     * 扩展项json
     */
    @Lob
    @Column(name = "input_json")
    private String inputJson;

    /**
     * 是否多选
     */
    @Column(name = "is_multiline")
    private String isMultiline;

    /**
     * 是否必填
     */
    @Column(name = "is_must")
    private String isMust;

    /**
     * 是否评分
     */
    @Column(name = "is_score")
    private String isScore;

    /**
     * 检查项类型
     */
    @Column(name = "item_type")
    private String itemType;

    /**
     * 检查项名称
     */
    private String name;

    /**
     * 排序编码
     */
    @Column(name = "order_no")
    private Integer orderNo;

    /**
     * 组织编码
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 拍照配置json
     */
    @Lob
    @Column(name = "picture_json")
    private String pictureJson;

    @Lob
    private String remark;

    /**
     * 是否删除：0表示未删除，1表示已删除
     */
    @Column(name = "is_delete")
    private boolean isDelete;

    /**
     * 等级
     */
    @Column(name = "level")
    private String level;

    /**
     * 检查项编号
     */
    @Column(name = "item_no")
    private String itemNo;

    /**
     * 原始字段
     */
    @Column(name = "original_id", columnDefinition = "varchar(50) COMMENT '原始字段'")
    private String originalId;

    /**
     * 标准依据
     */
    @Column(name = "basis_json", columnDefinition = "text COMMENT '标准依据'")
    private String basisJson;

    /**
     * 风险描述
     */
    @Column(name = "risk_desc")
    private String riskDesc;
    /**
     * 检测方法
     */
    @Column(name = "check_method")
    private String checkMethod;
    /**
     * 录入方式 0.表示手动录入，1.表示规则同步
     */
    @Column(name = "input_type")
    private Integer inputType;
    /**
     * 检查点分类
     */
    @Column(name = "input_classify")
    private String inputClassify;

    /**
     * 装备定义名称
     */
    @Column(name = "equipment_name")
    private String equipmentName;

    /**
     * 装备定义名称
     */
    @Column(name = "title")
    private String title;
    /**
     * 数字项默认值单位
     */
    @Column(name = "unit")
    private String unit;

    /**
     * 维保项内容
     */
    @Column(name = "maintenance_content")
    private String maintenanceContent;

    /**
     * 测试要求
     */
    @Column(name = "test_requirement")
    private String testRequirement;

    /**
     * 检查类型字典值
     */
    @Column(name = "check_type_Val")
    private String checkTypeId;

    /**
     * 检查类型
     */
    @Column(name = "check_type")
    private String checkType;

    /**
     * 父类检查项id
     */
    @Column(name = "item_parent")
    private String itemParent;

    /**
     * 检查项分类
     */
    @Column(name = "item_classify")
    private String itemClassify;

    /**
     * 适用检查类别
     */
    @Lob
    @Column(name = "item_type_classify")
    private String itemTypeClassify;

    /**
     * 检查项等级
     */
    @Column(name = "item_level")
    private String itemLevel;

    /**
     * 检查项启用
     */
    @Column(name = "item_start")
    private Integer itemStart;

    /**
     * 检查类别IDS
     */
    @Column(name = "item_type_classify_ids")
    private String itemTypeClassifyIds;

    public Integer getItemStart() {
        return itemStart;
    }

    public void setItemStart(Integer itemStart) {
        this.itemStart = itemStart;
    }

    public String getItemParent() {
        return itemParent;
    }

    public void setItemParent(String itemParent) {
        this.itemParent = itemParent;
    }

    public String getItemClassify() {
        return itemClassify;
    }

    public void setItemClassify(String itemClassify) {
        this.itemClassify = itemClassify;
    }

    public String getItemTypeClassify() {
        return itemTypeClassify;
    }

    public void setItemTypeClassify(String itemTypeClassify) {
        this.itemTypeClassify = itemTypeClassify;
    }

    public String getItemLevel() {
        return itemLevel;
    }

    public void setItemLevel(String itemLevel) {
        this.itemLevel = itemLevel;
    }

    public String getCheckType() {
        return checkType;
    }

    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }

    public void setMaintenanceContent(String maintenanceContent) {
        this.maintenanceContent = maintenanceContent;
    }

    public void setTestRequirement(String testRequirement) {
        this.testRequirement = testRequirement;
    }

    public String getMaintenanceContent() {
        return maintenanceContent;
    }

    public String getTestRequirement() {
        return testRequirement;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getInputType() {
        return inputType;
    }

    public void setInputType(Integer inputType) {
        this.inputType = inputType;
    }

    public String getInputClassify() {
        return inputClassify;
    }

    public void setInputClassify(String inputClassify) {
        this.inputClassify = inputClassify;
    }

    public String getCheckMethod() {
        return checkMethod;
    }

    public void setCheckMethod(String checkMethod) {
        this.checkMethod = checkMethod;
    }

    public String getRiskDesc() {
        return riskDesc;
    }

    public void setRiskDesc(String riskDesc) {
        this.riskDesc = riskDesc;
    }

    public String getItemNo() {
        return itemNo;
    }

    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    public InputItem() {
    }

    public Long getCatalogId() {
        return this.catalogId;
    }

    public void setCatalogId(Long catalogId) {
        this.catalogId = catalogId;
    }

    public String getDataJson() {
        return this.dataJson;
    }

    public void setDataJson(String dataJson) {
        this.dataJson = dataJson;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getInputJson() {
        return this.inputJson;
    }

    public void setInputJson(String inputJson) {
        this.inputJson = inputJson;
    }

    public String getIsMultiline() {
        return this.isMultiline;
    }

    public void setIsMultiline(String isMultiline) {
        this.isMultiline = isMultiline;
    }

    public String getIsMust() {
        return this.isMust;
    }

    public void setIsMust(String isMust) {
        this.isMust = isMust;
    }

    public String getIsScore() {
        return this.isScore;
    }

    public void setIsScore(String isScore) {
        this.isScore = isScore;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(Integer orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrgCode() {
        return this.orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getPictureJson() {
        return this.pictureJson;
    }

    public void setPictureJson(String pictureJson) {
        this.pictureJson = pictureJson;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public boolean getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(boolean isDelete) {
        this.isDelete = isDelete;
    }

    public boolean equals(Object obj) {
        InputItem inputItem = (InputItem) obj;
        return this.getId() == inputItem.getId();
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getOriginalId() {
        return originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public String getBasisJson() {
        return basisJson;
    }

    public void setBasisJson(String basisJson) {
        this.basisJson = basisJson;
    }

    public String getCheckTypeId() {
        return checkTypeId;
    }

    public void setCheckTypeId(String checkTypeId) {
        this.checkTypeId = checkTypeId;
    }

    public String getItemTypeClassifyIds() {
        return itemTypeClassifyIds;
    }

    public void setItemTypeClassifyIds(String itemTypeClassifyIds) {
        this.itemTypeClassifyIds = itemTypeClassifyIds;
    }
}