package com.yeejoin.amos.boot.module.common.biz.service.impl;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.Bean;

import com.yeejoin.amos.boot.module.common.api.dto.DutyFireFightingDto;
import com.yeejoin.amos.boot.module.common.api.dto.FireStationDto;
import com.yeejoin.amos.boot.module.common.api.service.IDutyFireFightingService;
@Service
public class DutyFireFightingServiceImpl extends DutyCommonServiceImpl implements IDutyFireFightingService {

	@Autowired
	FireStationServiceImpl fireStationServiceImpl;

	@Override
	@Transactional(rollbackFor = Exception.class)
	public DutyFireFightingDto save(DutyFireFightingDto dto) {
		// 根据微型消防站ID，获取微型消防站名称
		FireStationDto fireStationDtoResult = fireStationServiceImpl
				.queryBySeq(Long.parseLong(dto.getFireFightingId()));
		dto.setFireFighting(fireStationDtoResult.getName());
		Map<String, Object> map = Bean.BeantoMap(dto);
		Long instanceId = excuteDynamicFormInstance(dto.getUserId(), map, this.getGroupCode());
		saveDutyPersonShiftDetail(instanceId, dto.getDutyShift(), dto.getStartTime());
		insertPersonShift(instanceId, dto.getDutyShift());
		return dto;
	}

	@Override
	public DutyFireFightingDto update(Long instanceId, DutyFireFightingDto dto) {
        updateDynamicFormInstance(this.getGroupCode(),instanceId,Bean.BeantoMap(dto));
        insertPersonShift(instanceId, dto.getDutyShift());
		return dto;
	}

	public String getGroupCode() {
		return "dutyFireFighting";
	}

}
