package com.yeejoin.amos.boot.module.common.biz.controller;

import java.util.List;


import com.yeejoin.amos.boot.module.common.api.entity.FailureMaintain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;

import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;


import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.FailureMaintainDto;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FailureMaintainServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 
 *
 * @author system_generator
 * @date 2021-08-04
 */
@RestController
@Api(tags = "故障维修记录Api")
@RequestMapping(value = "/common/failure-maintain")
public class FailureMaintainController extends BaseController {

    @Autowired
    FailureMaintainServiceImpl failureMaintainServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<Object> save(@RequestBody FailureMaintainDto model)  {

		try {
			return ResponseHelper.buildResponse(failureMaintainServiceImpl.savemodel(model,getSelectedOrgInfo()));
		} catch (Exception e) {
			e.printStackTrace();
			return ResponseHelper.buildResponse(false);
		}
	}

	/**
	 * 维修列表记录查询
	 *根据关联主表faultId查询
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "维修列表记录查询",   notes = "维修列表记录查询")
	@GetMapping(value = "/list/{faultId}")
	public ResponseModel<List<FailureMaintain>> findByFaultIDFotList(@PathVariable long faultId) {
		return ResponseHelper.buildResponse(failureMaintainServiceImpl.findByfaultId(faultId));
	}




	/**
	 * 查询历史流程审核信息记录
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "设备故障报修单详情-报修日志",   notes = "设备故障报修单详情-报修日志")
	@GetMapping(value = "/getProcessHistory/{sequenceNbr}")
	public ResponseModel<List<Object>> getProcessHistory(@PathVariable Long sequenceNbr ) {
	    return ResponseHelper.buildResponse(failureMaintainServiceImpl.getProcessHistoryList(sequenceNbr));
	}
}
