package com.yeejoin.amos.knowledgebase.controller;

import com.yeejoin.amos.knowledgebase.face.service.StatisticsRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@RestController
//@TycloudResource(module = "knowledgebase", value = "docstatistics")
//@RequestMapping(value = "/v1/doccontent/docstatistics")
//@Api(tags = "knowledgebase-文档统计报表")
public class DocStatisticsResource {

    @Autowired
    private StatisticsRecordService statisticsRecordService;

    /*@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "耗时* 刷新统计数据")
    @RequestMapping(value = "/record/init", method = RequestMethod.PUT)
    public ResponseModel init() {
        return ResponseHelper.buildResponse(statisticsRecordService.init());
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "灾情统计")
    @RequestMapping(value = "/count/disaster", method = RequestMethod.GET)
    public ResponseModel selectDisasterCount() {
        return ResponseHelper.buildResponse(statisticsRecordService.selectDisasterCount());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "燃烧物质统计分类")
    @RequestMapping(value = "/count/burning", method = RequestMethod.GET)
    public ResponseModel selectBurningCategory() {
        return ResponseHelper.buildResponse(statisticsRecordService.selectCategoryByName(StatisticsRecordService.STATISTICS_BURNING_CATEGORY));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "到场时间统计分类")
    @RequestMapping(value = "/count/present", method = RequestMethod.GET)
    public ResponseModel selectPresentCategory() {
        return ResponseHelper.buildResponse(statisticsRecordService.selectCategoryByName(StatisticsRecordService.STATISTICS_PRESENT_CATEGORY));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "伤亡人数趋势统计")
    @RequestMapping(value = "/count/casualties", method = RequestMethod.GET)
    public ResponseModel selectCasualtiesSum(@RequestParam(value = "dateType") String dateType,
                                             @RequestParam(value = "dateRangeLeft", required = false) String dateRangeLeft,
                                             @RequestParam(value = "dateRangeRight", required = false) String dateRangeRight) {
        return ResponseHelper.buildResponse(statisticsRecordService.selectCountByTypeAndDateRange(dateType, dateRangeLeft, dateRangeRight, StatisticsRecordService.STATISTICS_CASUALTIES_SUM));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "参战车辆数量统计")
    @RequestMapping(value = "/count/power", method = RequestMethod.GET)
    public ResponseModel selectPowerSum(@RequestParam(value = "dateType") String dateType,
                                        @RequestParam(value = "dateRangeLeft", required = false) String dateRangeLeft,
                                        @RequestParam(value = "dateRangeRight", required = false) String dateRangeRight) {
        return ResponseHelper.buildResponse(statisticsRecordService.selectCountByTypeAndDateRange(dateType, dateRangeLeft, dateRangeRight, StatisticsRecordService.STATISTICS_POWER_SUM));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "过火面积统计")
    @RequestMapping(value = "/count/area", method = RequestMethod.GET)
    public ResponseModel selectAreaSum(@RequestParam(value = "dateType") String dateType,
                                       @RequestParam(value = "dateRangeLeft", required = false) String dateRangeLeft,
                                       @RequestParam(value = "dateRangeRight", required = false) String dateRangeRight) {
        return ResponseHelper.buildResponse(statisticsRecordService.selectCountByTypeAndDateRange(dateType, dateRangeLeft, dateRangeRight, StatisticsRecordService.STATISTICS_AREA_COUNT));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "灭火药剂统计")
    @RequestMapping(value = "/count/extinguishing", method = RequestMethod.GET)
    public ResponseModel selectExtinguishingSum(@RequestParam(value = "dateType") String dateType,
                                                @RequestParam(value = "dateRangeLeft", required = false) String dateRangeLeft,
                                                @RequestParam(value = "dateRangeRight", required = false) String dateRangeRight) {
        return ResponseHelper.buildResponse(statisticsRecordService.selectCountByTypeAndDateRange(dateType, dateRangeLeft, dateRangeRight, StatisticsRecordService.STATISTICS_EXTINGUISHING_SUM));
    }*/
}
