package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.hygf.api.config.UserLimits;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpInverterDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpInverter;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.JpInverterServiceImpl;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.yeejoin.amos.boot.module.hygf.biz.service.impl.JpCollectorServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpCollectorDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.TdHygfJpInverterWarnDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpPersonStation;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpPersonStationMapper;

import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 户用光伏监盘采集器表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@RestController
@Api(tags = "户用光伏监盘采集器表Api")
@RequestMapping(value = "/jp-collector")
public class JpCollectorController extends BaseController {

	@Autowired
	JpCollectorServiceImpl jpCollectorServiceImpl;

	@Autowired
	JpPersonStationMapper pPersonStationMapper;

	@Autowired
	JpInverterServiceImpl jpInverterServiceImpl;

    /**
     * 新增户用光伏监盘采集器表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增户用光伏监盘采集器表", notes = "新增户用光伏监盘采集器表")
	public ResponseModel<JpCollectorDto> save(@RequestBody JpCollectorDto model) {
		model = jpCollectorServiceImpl.createWithModel(model);
		return ResponseHelper.buildResponse(model);
	}

	/**
	 * 根据sequenceNbr更新
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新户用光伏监盘采集器表", notes = "根据sequenceNbr更新户用光伏监盘采集器表")
	public ResponseModel<JpCollectorDto> updateBySequenceNbrJpCollector(@RequestBody JpCollectorDto model,
			@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		model.setSequenceNbr(sequenceNbr);
		return ResponseHelper.buildResponse(jpCollectorServiceImpl.updateWithModel(model));
	}

	/**
	 * 根据sequenceNbr删除
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除户用光伏监盘采集器表", notes = "根据sequenceNbr删除户用光伏监盘采集器表")
	public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request,
			@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(jpCollectorServiceImpl.removeById(sequenceNbr));
	}

	/**
	 * 根据sequenceNbr查询
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个户用光伏监盘采集器表",  notes = "根据sequenceNbr查询单个户用光伏监盘采集器表")
	public ResponseModel<JpCollectorDto> selectOne(@PathVariable Long sequenceNbr) {
		JpCollectorDto jpCollectorDto = jpCollectorServiceImpl.queryBySeq(sequenceNbr);

		LambdaQueryWrapper<JpInverter> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(JpInverter::getCollectorSnCode, jpCollectorDto.getSnCode());
		List<JpInverter> list = jpInverterServiceImpl.list(queryWrapper);
        List<JpInverter> listData =new ArrayList<>();
        for (JpInverter jpInverter : list) {
            jpInverter.setDayPowerGeneration(jpInverter.getDayPowerGeneration()!=null?jpInverter.getDayPowerGeneration()/1000:0);
            jpInverter.setMonthPowerGeneration(jpInverter.getMonthPowerGeneration()!=null?jpInverter.getMonthPowerGeneration()/1000:0);
            jpInverter.setYearPowerGeneration(jpInverter.getYearPowerGeneration()!=null?jpInverter.getYearPowerGeneration()/1000:0);
            jpInverter.setTotalPowerGeneration(jpInverter.getTotalPowerGeneration()!=null?jpInverter.getTotalPowerGeneration()/1000:0);

            listData.add(jpInverter);
        }


		jpCollectorDto.setJpInverters(listData);

	    return ResponseHelper.buildResponse(jpCollectorDto);
	}

	/**
	 * 列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET", value = "户用光伏监盘采集器表分页查询", notes = "户用光伏监盘采集器表分页查询")
	public ResponseModel<Page<JpCollectorDto>> queryForPage(@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size, JpCollectorDto jpCollectorDto) {

        List<JpPersonStation> pPersonStation=null;
        if(jpCollectorDto.getName()!=null&&!"".equals(jpCollectorDto.getName())){
            LambdaQueryWrapper<JpPersonStation> qug1=new LambdaQueryWrapper<>();
            qug1.like(JpPersonStation::getStationName,jpCollectorDto.getName());
            pPersonStation=pPersonStationMapper.selectList(qug1);
        }else{
            //获取当前人管理场站
            LambdaQueryWrapper<JpPersonStation> qug = new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId, getUserInfo().getUserId());
            pPersonStation = pPersonStationMapper.selectList(qug);
        }



		if (!pPersonStation.isEmpty()) {
			Page<JpCollectorDto> page = new Page<JpCollectorDto>();
			page.setCurrent(current);
			page.setSize(size);
			List<String> ids = pPersonStation.stream().map(i -> i.getStationId()).collect(Collectors.toList());
			jpCollectorDto.setStationIds(ids);
			return ResponseHelper.buildResponse(jpCollectorServiceImpl.queryForJpCollectorPage(page, jpCollectorDto));
		} else {
			return ResponseHelper.buildResponse(new Page<JpCollectorDto>());
		}
	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "户用光伏监盘采集器表列表全部数据查询", notes = "户用光伏监盘采集器表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JpCollectorDto>> selectForList() {
		return ResponseHelper.buildResponse(jpCollectorServiceImpl.queryForJpCollectorList());
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/queryForDataPage")
	@ApiOperation(httpMethod = "GET", value = "户用光伏监盘采集器表分页查询", notes = "户用光伏监盘采集器表分页查询")
	public ResponseModel<Page<JpCollectorDto>> queryForDataPage(@RequestParam(value = "current") int current,
															@RequestParam(value = "size") int size, JpCollectorDto jpCollectorDto) {
			Page<JpCollectorDto> page = new Page<JpCollectorDto>();
			page.setCurrent(current);
			page.setSize(size);
			page.setTotal(jpCollectorServiceImpl.selectPageDataTota(jpCollectorDto));
			page.setRecords(jpCollectorServiceImpl.selectPageData(jpCollectorDto,(current-1)*size,size));
			return ResponseHelper.buildResponse(page);
	}


}
