package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.hygf.api.config.UserLimits;
import com.yeejoin.amos.boot.module.hygf.api.dto.DropDown;
import com.yeejoin.amos.boot.module.hygf.api.dto.ReviewDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.*;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpCollectorMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpInverterMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpPersonStationMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpStationMapper;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.DayGenerateServiceImpl;
import com.yeejoin.amos.boot.module.standard.api.entity.PublicAgencyUser;
import org.omg.CORBA.OBJ_ADAPTER;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.text.DecimalFormat;
import java.util.*;

import com.yeejoin.amos.boot.module.hygf.biz.service.impl.JpStationServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpStationDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 第三方场站
 *
 * @author system_generator
 * @date 2023-09-19
 */
@RestController
@Api(tags = "第三方场站Api")
@RequestMapping(value = "/jp-station")
public class JpStationController extends BaseController {

    @Autowired
    JpStationServiceImpl jpStationServiceImpl;
    @Autowired
    JpPersonStationMapper pPersonStationMapper;
    @Autowired
    JpStationMapper jpStationMapper;
    @Autowired
    JpCollectorMapper jpCollectorMapper;
    @Autowired
    JpInverterMapper jpInverterMapper;

    @Autowired
    DayGenerateServiceImpl dayGenerateServiceImpl;


    private static Double CARBON=0.997*0.001;
    private static Double SULFUR=0.03*0.001;
    private static Double DUST=0.272*0.001;
    private static Double COAL=0.4*0.001;
    private static String ZX="在线";
    private static String LX="离线";
    private static String BJ="报警";

    /**
     * 新增第三方场站
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增第三方场站", notes = "新增第三方场站")
	public ResponseModel<JpStationDto> save(@RequestBody JpStationDto model) {
	    model = jpStationServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新第三方场站", notes = "根据sequenceNbr更新第三方场站")
	public ResponseModel<JpStationDto> updateBySequenceNbrJpStation(@RequestBody JpStationDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(jpStationServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除第三方场站", notes = "根据sequenceNbr删除第三方场站")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jpStationServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getBysequenceNbr")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个第三方场站",  notes = "根据sequenceNbr查询单个第三方场站")
	public ResponseModel<JpStationDto> selectOne( String id) {
	    Long sequenceNbr=Long.valueOf(id);
        JpStationDto jpStationDto=  jpStationServiceImpl.queryBySeq(sequenceNbr);
        LambdaQueryWrapper<JpInverter> qug=new LambdaQueryWrapper<>();
        qug.eq(JpInverter::getThirdStationId,jpStationDto.getThirdStationId());
        List<JpInverter> jpInverter=jpInverterMapper.selectList(qug);
        LambdaQueryWrapper<JpCollector> qug1=new LambdaQueryWrapper<>();
        qug1.eq(JpCollector::getThirdStationId,jpStationDto.getThirdStationId());
        List<JpCollector> JpCollector=jpCollectorMapper.selectList(qug1);
        jpStationDto.setJpCollector(JpCollector);
        jpStationDto.setJpInverter(jpInverter);
	    return ResponseHelper.buildResponse(jpStationDto);
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryPage")
    @ApiOperation(httpMethod = "GET",value = "场站列表",  notes = "场站列表")
    public ResponseModel<Page<JpStationDto>> queryForDealerReviewPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size, JpStationDto reviewDto) {

        List<JpPersonStation> pPersonStation=null;
        if(reviewDto.getName()!=null&&!"".equals(reviewDto.getName())){
            LambdaQueryWrapper<JpPersonStation> qug1=new LambdaQueryWrapper<>();
            qug1.like(JpPersonStation::getStationName,reviewDto.getName());
            pPersonStation=pPersonStationMapper.selectList(qug1);
        }else{
            //获取当前人管理场站
            //获取当前人管理场站
            LambdaQueryWrapper<JpPersonStation> qug=new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId,getUserInfo().getUserId());
             pPersonStation=pPersonStationMapper.selectList(qug);
        }


//        if(reviewDto.getThirdStationId()==null){

            if(pPersonStation!=null&&!pPersonStation.isEmpty()){
                reviewDto.setStatioId(pPersonStation.isEmpty()?null:pPersonStation);
            }else{
                return ResponseHelper.buildResponse(null);
            }
//        }
        Page<JpStationDto> page=jpStationServiceImpl.queryForJpStationPage(current,size,reviewDto);
        return ResponseHelper.buildResponse(page);
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/countState")
    @ApiOperation(httpMethod = "GET",value = "场站列表",  notes = "场站列表")
    public ResponseModel< Map<String,Object> > countState(JpStationDto reviewDto) {

        Set<String> se=new HashSet<>();
        List<JpPersonStation> pPersonStation=null;
        if(reviewDto.getName()!=null&&!"".equals(reviewDto.getName())){
            LambdaQueryWrapper<JpPersonStation> qug1=new LambdaQueryWrapper<>();
            qug1.like(JpPersonStation::getStationName,reviewDto.getName());
             pPersonStation=pPersonStationMapper.selectList(qug1);
        }else{
            //获取当前人管理场站
            LambdaQueryWrapper<JpPersonStation> qug=new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId,getUserInfo().getUserId());
             pPersonStation=pPersonStationMapper.selectList(qug);
        }
        reviewDto.setStatioId(pPersonStation.isEmpty()?null:pPersonStation);
        List<Map<String,Object>> list= jpStationMapper.countState(reviewDto);
        Map<String,Object>  collector =new HashMap<>();
        collector.put("zx",0);
        collector.put("bj",0);
        collector.put("lx",0);
            if(list!=null&&!list.isEmpty()){
                for (Map<String, Object> map : list) {
                    if("在线".equals(map.get("state").toString())){
                        collector.put("zx",Integer.valueOf(map.get("num").toString()));
                    }else if("离线".equals(map.get("state").toString())){
                        collector.put("lx",Integer.valueOf(map.get("num").toString()));
                    }else if("报警".equals(map.get("state").toString())){
                        collector.put("bj",Integer.valueOf(map.get("num").toString()));
                    }
                }
            }
        return ResponseHelper.buildResponse(collector);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getpStation")
    @ApiOperation(httpMethod = "GET",value = "设备监控",  notes = "设备监控")
    public ResponseModel<Map<String,Object>> getpStation(JpStationDto reviewDto) {

        List<JpPersonStation> pPersonStation=null;
        if(reviewDto.getName()!=null&&!"".equals(reviewDto.getName())){
            LambdaQueryWrapper<JpPersonStation> qug1=new LambdaQueryWrapper<>();
            qug1.like(JpPersonStation::getStationName,reviewDto.getName());
            pPersonStation=pPersonStationMapper.selectList(qug1);
        }else{
            //获取当前人管理场站
            LambdaQueryWrapper<JpPersonStation> qug=new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId,getUserInfo().getUserId());
            pPersonStation=pPersonStationMapper.selectList(qug);
        }



        if(pPersonStation!=null&&!pPersonStation.isEmpty()){
            reviewDto.setStatioId(pPersonStation.isEmpty()?null:pPersonStation);
        }else{
            return ResponseHelper.buildResponse(null);
        }
        List<Map<String,Object>>  listCollector=  jpCollectorMapper.queryCollectorCountStatus(reviewDto);
        List<Map<String,Object>>  listInverter=  jpInverterMapper.queryInverterCountStatus(reviewDto);
        Map<String,Object>  collector =new HashMap<>();
        collector.put("zx",0);
        collector.put("gj",0);
        collector.put("lx",0);
        Map<String,Object>  inverter =new HashMap<>();
        inverter.put("zx",0);
        inverter.put("gj",0);
        inverter.put("lx",0);
        if(!listCollector.isEmpty()){
            for (Map<String, Object> map : listCollector) {
                if("在线".equals(map.get("state").toString())){
                    collector.put("zx",Integer.valueOf(map.get("num").toString()));
                }else if("离线".equals(map.get("state").toString())){
                    collector.put("lx",Integer.valueOf(map.get("num").toString()));
                }else if("报警".equals(map.get("state").toString())){
                    collector.put("gj",Integer.valueOf(map.get("num").toString()));
                }
            }
        }
        if(!listInverter.isEmpty()){
            for (Map<String, Object> map : listInverter) {
                if("在线".equals(map.get("state").toString())){
                    inverter.put("zx",Integer.valueOf(map.get("num").toString()));
                }else if("离线".equals(map.get("state").toString())){
                    inverter.put("lx",Integer.valueOf(map.get("num").toString()));
                }else if("报警".equals(map.get("state").toString())){
                    inverter.put("gj",Integer.valueOf(map.get("num").toString()));
                }
            }
        }
        Map<String,Object> map=new HashMap<>();
        map.put("collector",collector);
        map.put("inverter",inverter);
        return ResponseHelper.buildResponse(map);

    }



    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryListcz")
    @ApiOperation(httpMethod = "GET",value = "登陆人管理场站列表",  notes = "登陆人管理场站列表")
    public ResponseModel<List<JpPersonStation>> queryList( ) {
            //获取当前人管理场站
            LambdaQueryWrapper<JpPersonStation> qug=new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId,getUserInfo().getUserId());
            List<JpPersonStation> pPersonStation=pPersonStationMapper.selectList(qug);
        return ResponseHelper.buildResponse(pPersonStation);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryUserListyz")
    @ApiOperation(httpMethod = "GET",value = "登陆人管理场站业主列表",  notes = "登陆人管理场站业主列表")
    public ResponseModel<List<String>> queryUserList( ) {
        //获取当前人管理场站
        LambdaQueryWrapper<JpPersonStation> qug=new LambdaQueryWrapper<>();
        qug.eq(JpPersonStation::getPersonId,getUserInfo().getUserId());
        List<JpPersonStation> pPersonStation=pPersonStationMapper.selectList(qug);
        List data=new ArrayList();
       if(pPersonStation!=null&& !pPersonStation.isEmpty()){
           for (JpPersonStation jpPersonStation : pPersonStation) {
               data.add(jpPersonStation.getOwner());
           }
       }
        return ResponseHelper.buildResponse(data);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "电站监控电量收益",   notes = "电站监控电量收益")
    @GetMapping(value = "/getIncomePower")
    public ResponseModel<JpStationDto> getIncomePower(JpStationDto reviewDto) {
        //获取当前人管理场站
        if(reviewDto.getThirdStationId()==null){
            //获取当前人管理场站
            LambdaQueryWrapper<JpPersonStation> qug=new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId,getUserInfo().getUserId());
            List<JpPersonStation> pPersonStation=pPersonStationMapper.selectList(qug);
            if(pPersonStation!=null&&!pPersonStation.isEmpty()){
                reviewDto.setStatioId(pPersonStation.isEmpty()?null:pPersonStation);
            }else{
                return  ResponseHelper.buildResponse(null);
            }
      }
        return ResponseHelper.buildResponse(jpStationMapper.queryCount(reviewDto));
    }


    @TycloudOperation(needAuth = false,ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "工率曲线",   notes = "电站监控电量收益")
    @GetMapping(value = "/getPowerqx")
    public ResponseModel< Map<String, List<Object>>> getPowerqx(JpStationDto reviewDto,String date, String type) {
        //获取当前人管理场站
        List<String> data=new ArrayList();
        Set<String> se=new HashSet<>();
        if(reviewDto.getName()!=null){
            LambdaQueryWrapper<JpPersonStation> qug1=new LambdaQueryWrapper<>();
            qug1.like(JpPersonStation::getStationName,reviewDto.getName());
            List<JpPersonStation> pPersonStation1=pPersonStationMapper.selectList(qug1);
            if(pPersonStation1!=null&&!pPersonStation1.isEmpty()){
                for (JpPersonStation jpPersonStation : pPersonStation1) {
                    se.add(jpPersonStation.getStationId());
                }
            }
            data.addAll(se);
        }else{
            if(reviewDto.getThirdStationId()==null){
                //获取当前人管理场站
                LambdaQueryWrapper<JpPersonStation> qug=new LambdaQueryWrapper<>();
                qug.eq(JpPersonStation::getPersonId,getUserInfo().getUserId());
                List<JpPersonStation> pPersonStation=pPersonStationMapper.selectList(qug);
                if(pPersonStation!=null&&!pPersonStation.isEmpty()){

                    for (JpPersonStation jpPersonStation : pPersonStation) {
                        data.add(jpPersonStation.getStationId());
                    }
                }else{
                    return  ResponseHelper.buildResponse(null);
                }
            }else{
                data.add(reviewDto.getThirdStationId());
            }
        }

        return ResponseHelper.buildResponse(jpStationServiceImpl.getPowerqx( date,  type,data));
    }


    //查询当前登录人权限区域公司
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "查询当前登录人权限区域公司",   notes = "查询当前登录人权限区域公司")
    @GetMapping(value = "/getRegion")
    @UserLimits
    public ResponseModel< List<DropDown>> getRegion() {

        List<DropDown>  list=  jpStationMapper.getRegion();

         return ResponseHelper.buildResponse(list);
    }


    //查询当前登录人权限经销商
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "查询当前登录人权限经销商",   notes = "查询当前登录人权限经销商")
    @GetMapping(value = "/getDealer")
    @UserLimits
    public ResponseModel<List<DropDown>> getDealer(String regionalCompaniesCode ) {
        List<DropDown>  list=  jpStationMapper.getDealer(regionalCompaniesCode);
        return ResponseHelper.buildResponse(list);
    }

   //电站发电量统计

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "电站发电量统计",   notes = "电站发电量统计")
    @GetMapping(value = "/getCountJpStationdata")
    @UserLimits
    public ResponseModel< List<JpStationDto>> getCountJpStationdata(JpStationDto reviewDto) {
        JpStationDto jpStation= jpStationMapper.getCountJpStationdata(reviewDto);
        List<Map<String,Object>> powerRatio=new ArrayList<>();
        Map<String,Object> map=new HashMap<>();
        map.put("value",String.format("%.2f",jpStation.getRealTimePower()/jpStation.getRatedPower()));
        powerRatio.add(map);
        jpStation.setPowerRatio(powerRatio);
        List<JpStationDto> list=new ArrayList<>();
        list.add(jpStation);
        return ResponseHelper.buildResponse(list);
    }

   //电站分布
   @TycloudOperation(ApiLevel = UserType.AGENCY)
   @ApiOperation(httpMethod = "GET",value = "电站分布",   notes = "电站分布")
   @GetMapping(value = "/getJpStation")
   @UserLimits
   public Object getJpStation(JpStationDto reviewDto) {
       List<JpStation> list= jpStationMapper.getJpStation(reviewDto);
       return ResponseHelper.buildResponse(list);
   }

    //节能减排

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "节能减排",   notes = "节能减排")
    @GetMapping(value = "/getEnergyConservation")
    @UserLimits
    public ResponseModel< Map<String,Object>> getEnergyConservation(JpStationDto reviewDto) {
        JpStationDto jpStation= jpStationMapper.getCountJpStationdata(reviewDto);
        Map<String,Object> map=new HashMap<>();
        DecimalFormat format2 = new DecimalFormat("#.00");
        //炭
        map.put("carbon",format2.format(jpStation.getAccumulatedPower()*CARBON));
        //硫
        map.put("sulfur",format2.format(jpStation.getAccumulatedPower()*SULFUR));
        //粉尘
        map.put("dust",format2.format(jpStation.getAccumulatedPower()*DUST));
        //煤
        map.put("coal",format2.format(jpStation.getAccumulatedPower()*COAL));
        return ResponseHelper.buildResponse(map);
    }



    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "电站列表统计",   notes = "电站列表统计")
    @GetMapping(value = "/getjpStationConservation")
    @UserLimits
    public ResponseModel< List<Map<String,Object>>> getjpStationConservation(JpStationDto reviewDto) {
        JpStationDto jpStation= jpStationMapper.getCountJpStationdata(reviewDto);


        List<Map<String,Object>> date=new ArrayList<>();


        Map<String,Object> map=new HashMap<>();
        DecimalFormat format2 = new DecimalFormat("#.00");
        //炭
        map.put("value1",format2.format(jpStation.getRealTimePower()));
        //硫
        map.put("value2",format2.format(jpStation.getCapacity()));


        Map<String,Object> map2=new HashMap<>();
        //炭
        map2.put("value1",format2.format(jpStation.getDayGenerate()));
        //硫
        map2.put("value2",format2.format(jpStation.getDayIncome()));
        Map<String,Object> map3=new HashMap<>();
        //炭
        map3.put("value1",format2.format(jpStation.getMonthGenerate()));
        //硫
        map3.put("value2",format2.format(jpStation.getMonthIncome()));
        Map<String,Object> map4=new HashMap<>();
        //炭
        map4.put("value1",format2.format(jpStation.getYearGenerate()));
        //硫
        map4.put("value2",format2.format(jpStation.getYearIncome()));

        date.add(map);
        date.add(map4);
        date.add(map2);
        date.add(map3);

        return ResponseHelper.buildResponse(date);
    }







    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "电站统计",   notes = "电站统计")
    @GetMapping(value = "/getcountJpStation")
    public ResponseModel< Map<String,Object>> getcountJpStation(JpStationDto reviewDto) {

        Map<String,Object>  collector =new HashMap<>();
        collector.put("zx",0);
        collector.put("bj",0);
        collector.put("lx",0);
        List<Map<String,Object>> list= jpStationServiceImpl.getcountState(reviewDto);
        if(list!=null&&!list.isEmpty()){
            for (Map<String, Object> map : list) {
                if(ZX.equals(map.get("state").toString())){
                    collector.put("zx",Integer.valueOf(map.get("num").toString()));
                }else if(LX.equals(map.get("state").toString())){
                    collector.put("lx",Integer.valueOf(map.get("num").toString()));
                }else if(BJ.equals(map.get("state").toString())){
                    collector.put("bj",Integer.valueOf(map.get("num").toString()));
                }
            }
        }
        Map<String,Object> js= jpStationServiceImpl.getcountStatejs(reviewDto);
        Map<String,Object> tc= jpStationServiceImpl.getcountStatetc(reviewDto);
        Map<String,Object> jr= jpStationServiceImpl.getcountStatejr(reviewDto);
        Map<String,Object> zs= jpStationServiceImpl.getcount(reviewDto);

        collector.put("js",js.get("num"));
        collector.put("tc",tc.get("num"));
        collector.put("jr",jr.get("num"));
        collector.put("zs",zs.get("num"));
        return ResponseHelper.buildResponse(collector);
    }

    //日满发小时排行

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "节能减排",   notes = "节能减排")
    @GetMapping(value = "/getDayGenerateph")
    public ResponseModel< List<Map<String,Object>>> getDayGenerateph(JpStationDto reviewDto,String type,String dateTime ) {

        List<JpStation> list=  jpStationServiceImpl.getJpStation(reviewDto);
        List<Map<String,Object>> li=new ArrayList<>();
        List<DayGenerate> date= dayGenerateServiceImpl.getDayGenerateph(list,type,dateTime);

        if(date!=null&&!list.isEmpty()){
            for (DayGenerate dayGenerate : date) {
                Map<String,Object> map =new HashMap<>();
                for (JpStation jpStation : list) {
                    if(dayGenerate.getThirdStationId().equals(jpStation.getThirdStationId())){
                        map.put("sequenceNbr",jpStation.getSequenceNbr());
                        map.put("name",jpStation.getName());
                        map.put("address",jpStation.getName());
                        map.put("fullhour",dayGenerate.getFullhour());
                        break;
                    }
                }
                if(!map.isEmpty()){
                    li.add(map);
                }
            }
        }
        return ResponseHelper.buildResponse(li);
    }



    @TycloudOperation(needAuth = false,ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "发电量曲线",   notes = "发电量曲线")
    @GetMapping(value = "/getGenerateqx")
    public ResponseModel< Map<String, List<Object>>> getGenerateqx(JpStationDto reviewDto,String date, String type) {

        Map<String, List<Object>>  map= jpStationServiceImpl.getGenerateqx( date,  type,reviewDto);


        return ResponseHelper.buildResponse(map);
    }

    @TycloudOperation(needAuth = false,ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "工率曲线",   notes = "电站监控电量收益")
    @GetMapping(value = "/getPowerqxnew")
    public ResponseModel< Map<String, List<Object>>> getPowerqxnew(JpStationDto reviewDto,String date) {

        Map<String, List<Object>>  map= jpStationServiceImpl.getPowerqxnew( date,reviewDto);

        return ResponseHelper.buildResponse(map);
    }




    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryPagenew")
    @ApiOperation(httpMethod = "GET",value = "场站列表",  notes = "场站列表")
    public ResponseModel<Page<JpStationDto>> queryPagenew(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size, JpStationDto reviewDto) {
        Page<JpStationDto> page=jpStationServiceImpl.queryForJpStationPagenew(current,size,reviewDto);
        return ResponseHelper.buildResponse(page);
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryReport")
    @ApiOperation(httpMethod = "GET",value = "场站报表",  notes = "场站报表")
    public ResponseModel<Page<JpStationDto>> queryReport(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size, JpStationDto reviewDto,String type) {

        Page<JpStationDto> page=jpStationServiceImpl.queryReport(current,size,reviewDto,type);

        return ResponseHelper.buildResponse(page);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "登录人场站",   notes = "登录人场站")
    @GetMapping(value = "/getuserJpStation")
    public ResponseModel< List<JpStation>> getuserJpStation(JpStationDto reviewDto) {
        List<JpStation> list = jpStationServiceImpl.getJpStation(reviewDto);
        return ResponseHelper.buildResponse(list);
    }


        @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "工率曲线",   notes = "电站监控电量收益")
    @GetMapping(value = "/test")
    public Object getPowerqx(JpStationDto reviewDto) {


        return jpStationMapper.getJpStation(null);
    }

}
