package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.hygf.api.config.UserLimits;
import com.yeejoin.amos.boot.module.hygf.api.entity.TdHYGFInverterDayGenerate;
import com.yeejoin.amos.boot.module.hygf.api.tdenginemapper.TdHYGFInverterDayGenerateMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpInverterDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpInverter;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpInverterMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IJpInverterService;

/**
 * 户用光伏监盘逆变器表服务实现类
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Service
public class JpInverterServiceImpl extends BaseService<JpInverterDto, JpInverter, JpInverterMapper>
        implements IJpInverterService {
    @Autowired
    TdHYGFInverterDayGenerateMapper tdHYGFInverterDayGenerateMapper;


    /**
     * 分页查询
     */
    public Page<JpInverterDto> queryForJpInverterPage(Page<JpInverterDto> page, JpInverterDto jpInverterDto) {
        Page<JpInverter> entiryPage = new Page<>(page.getCurrent(), page.getSize());
        LambdaQueryWrapper<JpInverter> wrapper = new LambdaQueryWrapper<>();
        if (jpInverterDto.getState() != null) {
            wrapper.eq(JpInverter::getState, jpInverterDto.getState());
        }
        if (StringUtils.isNotEmpty(jpInverterDto.getSnCode())) {
            wrapper.like(JpInverter::getSnCode, jpInverterDto.getSnCode());
        }
        if (!jpInverterDto.getStationIds().isEmpty()) {
            wrapper.in(JpInverter::getThirdStationId, jpInverterDto.getStationIds());
        }
        wrapper.orderByDesc(JpInverter::getUpdateTime);
        entiryPage = (Page<JpInverter>) this.page(entiryPage, wrapper);
        if (!ValidationUtil.isEmpty(entiryPage.getRecords())) {
            page.setTotal(entiryPage.getTotal());
            page.setPages(entiryPage.getPages());
            page.setCurrent(entiryPage.getCurrent());
            page.setSize(entiryPage.getSize());

            if (!ValidationUtil.isEmpty(entiryPage.getRecords()))
                page.setRecords(Bean.toModels(entiryPage.getRecords(), this.getModelClass()));
        }
        return page;
    }

    /**
     * 列表查询 示例
     */
    public List<JpInverterDto> queryForJpInverterList() {
        return this.queryForList("", false);
    }

    @UserLimits
    public List<JpInverterDto> selectPageData(JpInverterDto jpInverterDto, int current, int size) {
        return this.getBaseMapper().selectPageData(jpInverterDto, current, size);
    }

    @UserLimits
    public long selectPageDataTota(JpInverterDto jpInverterDto) {
        return this.getBaseMapper().selectPageDataTotal(jpInverterDto);
    }

    public void selectDayTrend(List<String> treeParams, String time, String snCode, String thirdStationId) {


    }

    public Page<TdHYGFInverterDayGenerate> jpInverterDayReport(int current, int size, String time, List<String> sncodes,List<String> stationIds) {
        Page<TdHYGFInverterDayGenerate> tdHYGFInverterDayGeneratePage = new Page<>();
        Date date = DateUtil.parse(time, "yyyy-MM-dd");
        String startTime = DateUtil.format(date, "yyyy-MM-dd") + "00:00:00";
        String endTime = DateUtil.format(date, "yyyy-MM-dd") + "23:59:59";
        QueryWrapper queryWrapper = new QueryWrapper<TdHYGFInverterDayGenerate>()
                .ge("created_time", startTime)
                .le("created_time", endTime)
                .in("third_station_id",stationIds);;
        if (CollectionUtil.isNotEmpty(sncodes)) {
            queryWrapper.in("sn_code", sncodes);
        }
		queryWrapper.orderByDesc("created_time");
        List<TdHYGFInverterDayGenerate> tdHYGFInverterDayGenerates = tdHYGFInverterDayGenerateMapper.selectList(queryWrapper);
        tdHYGFInverterDayGeneratePage.setTotal(tdHYGFInverterDayGenerates.size());
        tdHYGFInverterDayGeneratePage.setSize(size);
        tdHYGFInverterDayGeneratePage.setCurrent(current);
        tdHYGFInverterDayGenerates=tdHYGFInverterDayGenerates.subList((current-1)*size,current*size>tdHYGFInverterDayGenerates.size()?tdHYGFInverterDayGenerates.size():current*size);
        tdHYGFInverterDayGenerates.forEach(tdHYGFInverterDayGenerate -> {
            Date date1=new Date(tdHYGFInverterDayGenerate.getCreatedTime());
            tdHYGFInverterDayGenerate.setCreatedTimeStr(DateUtil.format(date1, DatePattern.NORM_DATETIME_PATTERN));
        });
        tdHYGFInverterDayGeneratePage.setRecords(tdHYGFInverterDayGenerates);
        return tdHYGFInverterDayGeneratePage;
    }

    public List<TdHYGFInverterDayGenerate> jpInverterDayReportExport(String time, List<String> sncodes,List<String> stationIds) {
        Date date = DateUtil.parse(time, "yyyy-MM-dd");
        String startTime = DateUtil.format(date, "yyyy-MM-dd") + "00:00:00";
        String endTime = DateUtil.format(date, "yyyy-MM-dd") + "23:59:59";
        QueryWrapper queryWrapper = new QueryWrapper<TdHYGFInverterDayGenerate>()
                .ge("created_time", startTime)
                .le("created_time", endTime)
                .in("third_station_id",stationIds);
        if (CollectionUtil.isNotEmpty(sncodes)) {
            queryWrapper.in("sn_code", sncodes);
        }
        queryWrapper.orderByDesc("created_time");
        List<TdHYGFInverterDayGenerate> tdHYGFInverterDayGenerates = tdHYGFInverterDayGenerateMapper.selectList(queryWrapper);
        tdHYGFInverterDayGenerates.forEach(tdHYGFInverterDayGenerate -> {
            Date date1=new Date(tdHYGFInverterDayGenerate.getCreatedTime());
            tdHYGFInverterDayGenerate.setCreatedTimeStr(DateUtil.format(date1, DatePattern.NORM_DATETIME_PATTERN));
        });
        return tdHYGFInverterDayGenerates;
    }
}