package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.module.hygf.api.config.UserLimits;
import com.yeejoin.amos.boot.module.hygf.api.dto.PowerCurveDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.ReviewDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.*;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpStationMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IJpStationService;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpStationDto;
import com.yeejoin.amos.boot.module.hygf.api.tdenginemapper.DayGenerateMapper;
import com.yeejoin.amos.boot.module.hygf.api.tdenginemapper.MonthGenerateMapper;
import com.yeejoin.amos.boot.module.hygf.api.tdenginemapper.MonthPowerMapper;
import com.yeejoin.amos.boot.module.hygf.api.tdenginemapper.YearGenerateMapper;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import springfox.bean.validators.plugins.schema.MinMaxAnnotationPlugin;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 第三方场站服务实现类
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Service
public class JpStationServiceImpl extends BaseService<JpStationDto,JpStation,JpStationMapper> implements IJpStationService {

    @Autowired
    JpStationMapper jpStationMapper;
    @Autowired
    MonthPowerMapper monthPowerMapper;
    @Autowired
    MonthPowerServiceImpl monthPowerServiceImpl;


    @Autowired
    DayGenerateMapper    dayGenerateMapper;
    @Autowired
    MonthGenerateMapper  monthGenerateMapper;
    @Autowired
    YearGenerateMapper   yearGenerateMapper;

    /**
     * 分页查询
     */
    public Page<JpStationDto> queryForJpStationPage(int pageNum, int pageSize, JpStationDto reviewDto)   {
        PageHelper.startPage(pageNum, pageSize);
        List<JpStationDto> list = jpStationMapper.queryForDealerReviewPage(reviewDto);
        PageInfo<JpStationDto> page = new PageInfo(list);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<JpStationDto> pagenew = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<JpStationDto>();
        pagenew.setCurrent(pageNum);
        pagenew.setTotal(page.getTotal());
        pagenew.setSize(pageSize);
        pagenew.setRecords(page.getList());
        return pagenew;
    }
    @Async
    public void getMonthPower() {
        monthPowerServiceImpl.getMonthPower();
    }


    /**
     * 分页查询
     */
    @UserLimits
    public Page<JpStationDto> queryForJpStationPagenew(int pageNum, int pageSize, JpStationDto reviewDto)   {
        PageHelper.startPage(pageNum, pageSize);
        List<JpStationDto> list = jpStationMapper.queryForDealerReviewPagenew(reviewDto);
        PageInfo<JpStationDto> page = new PageInfo(list);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<JpStationDto> pagenew = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<JpStationDto>();
        pagenew.setCurrent(pageNum);
        pagenew.setTotal(page.getTotal());
        pagenew.setSize(pageSize);
        pagenew.setRecords(page.getList());
        return pagenew;
    }

    @Override
    public  Map<String, List<Object>> getPowerqx(String date, String type,List<String> statioId) {
        List<PowerCurveDto>  data=null;
        List<Object> listx =new  ArrayList<>();
        List<Object> listy =new ArrayList<>();
        Map<String, List<Object>> map =new HashMap<>();
        try {

            if(type.equals("day")){
                map= gethourList();
                data =monthPowerMapper.getDayPowercount(date, statioId);
            }else if(type.equals("month")){
                map= getDayListOfMonth(date);
                data=monthPowerMapper.getMonthPower(date, statioId);

            }else if(type.equals("year")){
                map= getyearListOfMonth(date);
                data= monthPowerMapper.getYearPower(date,statioId);
            }else{
                map= getyearList();
                data= monthPowerMapper.getAllPower(date, statioId);
            }

            listx =map.get("x");
            listy =map.get("y");
            if(data!=null&&!data.isEmpty()){
                for (PowerCurveDto datum : data) {
                    for (int i = 0; i < listx.size(); i++) {
                       if(datum.getDate().equals(listx.get(i).toString())){
                           listy.remove(i);
                           String format = datum.getNum()!=null?new DecimalFormat("#.000").format(datum.getNum()):null;
                           listy.add(i,format);
                           break;
                       }
                    }
                }
            }


        if(type.equals("month")||type.equals("year")){

            listx=     listx.stream().map(e-> String.valueOf(e).substring(String.valueOf(e).length()-2)).collect(Collectors.toList());

        }

            map.put("x",listx);
            map.put("y",listy);

        } catch (Exception e) {
            e.printStackTrace();
            throw  new BadRequest("系统异常！");
        }

        return map;
    }

    @Override
    @UserLimits
    public  Map<String,Object> getcount(JpStationDto reviewDto) {
        return jpStationMapper.getcount(reviewDto);
    }

    @Override
    @UserLimits
    public List<Map<String, Object>> getcountState(JpStationDto reviewDto) {
        return jpStationMapper.getcountState(reviewDto);
    }

    @Override
    @UserLimits
    public Map<String, Object> getcountStatetc(JpStationDto reviewDto) {
        return jpStationMapper.getcountStatetc(reviewDto);
    }

    @Override
    @UserLimits
    public Map<String, Object> getcountStatejs(JpStationDto reviewDto) {
        return jpStationMapper.getcountStatejs(reviewDto);
    }

    @Override
    @UserLimits
    public Map<String, Object> getcountStatejr(JpStationDto reviewDto) {
        return jpStationMapper.getcountStatejr(reviewDto);
    }

    @Override
    @UserLimits
    public List<JpStation> getJpStation(JpStationDto reviewDto) {
        return jpStationMapper.getJpStation(reviewDto);
    }

    @Override
    public Map<String, List<Object>> getGenerateqx(String date, String type, JpStationDto reviewDto) {

        List<String> statioId=new ArrayList();
        List<JpStation> dataJpStation= this.getJpStation(reviewDto);
        for (JpStation jpStation : dataJpStation) {
            statioId.add(jpStation.getThirdStationId());
        }

        List<PowerCurveDto>  data=null;
        List<Object> listx =new  ArrayList<>();
        List<Object> listy =new ArrayList<>();
        Map<String, List<Object>> map =new HashMap<>();
        try {

            if(type.equals("month")){
                map= getDayListOfMonth(date);
                data= dayGenerateMapper.getDayGeneratqx(date, statioId);

            }else if(type.equals("year")){
                map= getyearListOfMonth(date);
                data= dayGenerateMapper.getMonthGenerateqx(date,statioId);
            }else{
                map= getyearList();
                data= dayGenerateMapper.getYearGenerateqx(date, statioId);
            }

            listx =map.get("x");
            listy =map.get("y");
            if(data!=null&&!data.isEmpty()){
                for (PowerCurveDto datum : data) {
                    for (int i = 0; i < listx.size(); i++) {
                        if(datum.getDate().equals(listx.get(i).toString())){
                            listy.remove(i);
                            String format = datum.getNum()!=null?new DecimalFormat("#.000").format(datum.getNum()):null;
                            listy.add(i,format);
                            break;
                        }
                    }
                }
            }
            if(type.equals("month")||type.equals("year")){

                listx=     listx.stream().map(e-> String.valueOf(e).substring(String.valueOf(e).length()-2)).collect(Collectors.toList());
            }
            map.put("x",listx);
            map.put("y",listy);
        } catch (Exception e) {
            e.printStackTrace();
            throw  new BadRequest("系统异常！");
        }

        return map;
    }

    @Override
    public Map<String, List<Object>> getPowerqxnew(String date,JpStationDto reviewDto) {

        List<String> statioId=new ArrayList();
        List<JpStation> dataJpStation= this.getJpStation(reviewDto);
        for (JpStation jpStation : dataJpStation) {
            statioId.add(jpStation.getThirdStationId());
        }
        List<PowerCurveDto>  data=null;
        List<Object> listx =new  ArrayList<>();
        List<Object> listy =new ArrayList<>();
        Map<String, List<Object>> map =new HashMap<>();
        map= gethourList();
        data =monthPowerMapper.getDayPowercount(date, statioId);
        listx =map.get("x");
        listy =map.get("y");
        if(data!=null&&!data.isEmpty()){
            for (PowerCurveDto datum : data) {
                for (int i = 0; i < listx.size(); i++) {
                    if(datum.getDate().equals(listx.get(i).toString())){
                        listy.remove(i);
                        String format = datum.getNum()!=null?new DecimalFormat("#.000").format(datum.getNum()):null;
                        listy.add(i,format);
                        break;
                    }
                }
            }
        }
        map.put("x",listx);
        map.put("y",listy);
        return map;
    }


    public static  Map<String,  List<Object>> getDayListOfMonth(String date) {
        Map<String,  List<Object>> map =new HashMap<>();
        try {
            List<Object> listx =new  ArrayList<>();
            List<Object> listy =new ArrayList<>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            Date dat = sdf.parse(date);
            Calendar aCalendar = Calendar.getInstance();
            aCalendar.setTime(dat);
            int month = aCalendar.get(Calendar.MONTH) + 1;//月份
            int day = aCalendar.getActualMaximum(Calendar.DATE);
            for (int i = 1; i <= day; i++) {
                String aDate =null;
                if(i<10){
                    aDate = date+"-0"+i;
                }else{
                    aDate = date+"-"+i;
                }

                listx.add(aDate);
                listy.add(null);
            }
            map.put("x",listx);
            map.put("y",listy);
        }catch (Exception e){
            e.printStackTrace();
            throw  new BadRequest("系统异常！");
        }
        return map;
    }
    public static  Map<String,  List<Object>> getyearListOfMonth(String date) {
        Map<String,  List<Object>> map =new HashMap<>();
        List<Object> listx =new  ArrayList<>();
        List<Object> listy =new ArrayList<>();
        for (int i = 1; i <= 12; i++) {
            String aDate =null;
            if(i<10){
                 aDate = date+"-0"+i;
            }else{
                aDate = date+"-"+i;
            }

            listx.add(aDate);
            listy.add(null);
        }
        map.put("x",listx);
        map.put("y",listy);
        return map;
    }

    public static  Map<String,  List<Object>> getyearList() {
        Map<String,  List<Object>> map =new HashMap<>();
        List<Object> listx =new  ArrayList<>();
        List<Object> listy =new ArrayList<>();
        Calendar aCalendar = Calendar.getInstance(Locale.CHINA);
        int year = aCalendar.get(Calendar.YEAR);//年份
        for (int i = 1; i <= 10; i++) {
            int aDate = year-(10-i);
            listx.add(String.valueOf(aDate));
            listy.add(null);
        }
        map.put("x",listx);
        map.put("y",listy);
        return map;
    }

    public static  Map<String,  List<Object>> gethourList() {
        Map<String,  List<Object>> map =new HashMap<>();
        List<Object> listx =new  ArrayList<>();
        List<Object> listy =new ArrayList<>();
        try {
            ArrayList<String> dates = new ArrayList<String>();
            for (int i = 0; i < 24; i++) {
                String s1 =i+":00";
                listx.add(s1);
                listy.add(null);
            }

        }catch (Exception e){
            e.printStackTrace();
            throw  new BadRequest("系统异常！");
        }
        map.put("x",listx);
        map.put("y",listy);
        return map;
    }
    public Page<JpStationDto> queryReport(int pageNum, int pageSize, JpStationDto reviewDto,String type)   {
        //权限
        List<String> statioId=new ArrayList();

            List<JpStation> dataJpStation= this.getJpStation(reviewDto);
            for (JpStation jpStation : dataJpStation) {
                statioId.add(jpStation.getThirdStationId());
            }
            reviewDto.setThirdStationIds(statioId);

        PageHelper.startPage(pageNum, pageSize);
        List<JpStationDto> list = null;
        switch (type){
            case"day":
                LambdaQueryWrapper<DayGenerate> wapper = new LambdaQueryWrapper<DayGenerate>();
                wapper.in(reviewDto.getThirdStationIds()!=null,DayGenerate::getThirdStationId,reviewDto.getThirdStationIds());
                wapper.eq(DayGenerate::getDayTime,reviewDto.getTimeDate());
                List<DayGenerate> listday=   dayGenerateMapper.selectList(wapper);
                list = getJpStationDtoday(  dataJpStation,   listday);
                break;
            case"month":
                LambdaQueryWrapper<MonthGenerate> wapper1 = new LambdaQueryWrapper<MonthGenerate>();
                wapper1.in(reviewDto.getThirdStationIds()!=null,MonthGenerate::getThirdStationId,reviewDto.getThirdStationIds());
                wapper1.eq(MonthGenerate::getMonthTime,reviewDto.getTimeDate());
                List<MonthGenerate> listmonth=  monthGenerateMapper.selectList(wapper1);
                list = getJpStationDtomonth(  dataJpStation,   listmonth);
                break;
            case"year":
                LambdaQueryWrapper<YearGenerate> wapper2 = new LambdaQueryWrapper<YearGenerate>();
                wapper2.in(reviewDto.getThirdStationIds()!=null,YearGenerate::getThirdStationId,reviewDto.getThirdStationIds());
                wapper2.eq(YearGenerate::getYear,reviewDto.getTimeDate());
                List<YearGenerate> listyear=  yearGenerateMapper.selectList(wapper2);
                list = getJpStationDtoyear(  dataJpStation,   listyear);
                break;
            default:
                list = getJpStationDtoAll(dataJpStation);
        }
        PageInfo<JpStationDto> page = new PageInfo(list);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<JpStationDto> pagenew = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<JpStationDto>();
        pagenew.setCurrent(pageNum);
        pagenew.setTotal(page.getTotal());
        pagenew.setSize(pageSize);
        pagenew.setRecords(page.getList());
        return pagenew;
    }

    public List<JpStationDto> getJpStationDtoAll( List<JpStation>  da){
        List<JpStationDto> ld=new ArrayList<>();


            for (JpStation jpStation : da) {
                    JpStationDto hd=new JpStationDto();
                    hd.setSequenceNbr(jpStation.getSequenceNbr());
                    hd.setCode(jpStation.getCode());
                    hd.setName(jpStation.getName());
                    hd.setUserName(jpStation.getUserName());
                    hd.setStationContact(jpStation.getStationContact());
                    hd.setState(jpStation.getState());
                    hd.setAccumulatedPower(jpStation.getAccumulatedPower());
                    hd.setFullhour(Double.valueOf(String.format("%.2f", jpStation.getAccumulatedPower()/jpStation.getCapacity())));
                    hd.setAccumulatedPower(jpStation.getAccumulatedPower());
                    hd.setDayIncome(null);
                    ld.add(hd);
            }

        return ld;
    }

    public List<JpStationDto> getJpStationDtoday( List<JpStation>  da,  List<DayGenerate> listday){
        List<JpStationDto> ld=new ArrayList<>();
        for (DayGenerate dayGenerate : listday) {
            JpStationDto hd=new JpStationDto();
            for (JpStation jpStation : da) {
                if(jpStation.getThirdStationId().equals(dayGenerate.getThirdStationId())){
                    hd.setSequenceNbr(jpStation.getSequenceNbr());
                    hd.setCode(jpStation.getCode());
                    hd.setName(jpStation.getName());
                    hd.setUserName(jpStation.getUserName());
                    hd.setStationContact(jpStation.getStationContact());
                    hd.setState(jpStation.getState());
                    hd.setAccumulatedPower(jpStation.getAccumulatedPower());

                    hd.setFullhour(dayGenerate.getFullhour());
                    hd.setDayGenerate(dayGenerate.getGenerate());
                    hd.setTimeDate(dayGenerate.getDayTime());
                    hd.setDayIncome(null);
                    break;
                }
            }
            ld.add(hd);
        }
        return ld;
    }
    public List<JpStationDto> getJpStationDtomonth( List<JpStation>  da, List<MonthGenerate> listmonth){
        List<JpStationDto> ld=new ArrayList<>();
        for (MonthGenerate dayGenerate : listmonth) {
            JpStationDto hd=new JpStationDto();
            for (JpStation jpStation : da) {
                if(jpStation.getThirdStationId().equals(dayGenerate.getThirdStationId())){
                    hd.setSequenceNbr(jpStation.getSequenceNbr());
                    hd.setCode(jpStation.getCode());
                    hd.setName(jpStation.getName());
                    hd.setUserName(jpStation.getUserName());
                    hd.setStationContact(jpStation.getStationContact());
                    hd.setState(jpStation.getState());
                    hd.setAccumulatedPower(jpStation.getAccumulatedPower());

                    hd.setMonthIncome(dayGenerate.getGenerate());
                    hd.setTimeDate(dayGenerate.getMonthTime());
                    hd.setFullhour(dayGenerate.getFullhour());
                    hd.setMonthGenerate(null);
                    break;
                }
            }
            ld.add(hd);
        }
        return ld;
    }
    public List<JpStationDto> getJpStationDtoyear( List<JpStation>  da,List<YearGenerate> listyear){
        List<JpStationDto> ld=new ArrayList<>();
        for (YearGenerate dayGenerate : listyear) {
            JpStationDto hd=new JpStationDto();
            for (JpStation jpStation : da) {
                if(jpStation.getThirdStationId().equals(dayGenerate.getThirdStationId())){
                    hd.setSequenceNbr(jpStation.getSequenceNbr());
                    hd.setCode(jpStation.getCode());
                    hd.setName(jpStation.getName());
                    hd.setUserName(jpStation.getUserName());
                    hd.setStationContact(jpStation.getStationContact());
                    hd.setState(jpStation.getState());
                    hd.setAccumulatedPower(jpStation.getAccumulatedPower());

                    hd.setFullhour(dayGenerate.getFullhour());
                    hd.setYearGenerate(dayGenerate.getGenerate());
                    hd.setYearIncome(null);
                    hd.setTimeDate(dayGenerate.getYearTime());
                    break;
                }
            }
            ld.add(hd);
        }
        return ld;
    }







}