package com.yeejoin.amos.boot.module.jxiop.biz.tdMapper2;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IndicatorData;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.FanHealthIndexDay;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

public interface FanHealthIndexDayMapper extends BaseMapper<FanHealthIndexDay> {
    @Select("<script>"+
            "SELECT `health_index` AS healthIndex,anomaly, `health_index` AS `value`,  analysis_time AS  analysisTime, station,equipment_name AS equipmentName,point_name as pointName,  ( CASE HEALTH_LEVEL WHEN '危险' THEN 3 WHEN '警告' THEN 2 WHEN '注意' THEN 1 ELSE 0 END ) AS status FROM analysis_data.fan_health_index_day WHERE analysis_obj_type = #{analysisObjType}" +
            "<if test='endTimeTop!= null'>  and ts &lt;= #{endTimeTop} </if> " +
            "<if test='startTimeTop!= null'>  and  ts &gt;= #{startTimeTop} </if> " +
            "<if test='area!= null'> AND area = #{area} </if> " +
            "<if test='indexAddress!= null'> AND index_address = #{indexAddress} </if> " +
            "<if test='pointName!= null'>AND point_name = #{pointName} </if> " +
            "<if test='station!= null'>AND station = #{station} </if>" +
            "<if test='healthLevel!= null'>AND health_level = #{healthLevel} </if>" +
            "<if test='subSystem!= null'>AND sub_system = #{subSystem} </if> " +
            "<if test='equipmentName!= null'>AND equipment_name = #{equipmentName} </if>" +
            "order by health_index "+
            "<if test='current != null and size != null'>limit ${current},${size} </if>" +
            "</script>")
    List<FanHealthIndexDay> selectData(@Param("healthLevel")String healthLevel,@Param("area")String area,@Param("equipmentName")String equipmentName,@Param("subSystem")String subSystem,@Param("analysisType")String analysisType,@Param("analysisObjType")String analysisObjType,@Param("station")String station,@Param("pointName")String pointName, @Param("indexAddress")String indexAddress,@Param("startTimeTop") String startTimeTop, @Param("endTimeTop")String endTimeTop,
                                       @Param("current")Integer current,@Param("size") Integer size);


    @Select("<script>"+
            "SELECT count(1) FROM analysis_data.fan_health_index_day WHERE analysis_obj_type = #{analysisObjType}" +
            "<if test='endTimeTop!= null'>  and ts &lt;= #{endTimeTop} </if> " +
            "<if test='startTimeTop!= null'>  and  ts &gt;= #{startTimeTop} </if> " +
            "<if test='area!= null'> AND area = #{area} </if> " +
            "<if test='indexAddress!= null'> AND index_address = #{indexAddress} </if> " +
            "<if test='pointName!= null'>AND point_name = #{pointName} </if> " +
            "<if test='station!= null'>AND station = #{station} </if>" +
            "<if test='healthLevel!= null'>AND health_level = #{healthLevel} </if>" +
            "<if test='subSystem!= null'>AND sub_system = #{subSystem} </if> " +
            "<if test='equipmentName!= null'>AND equipment_name = #{equipmentName} </if>" +
            "</script>")
    int selectDataTotal(@Param("healthLevel")String healthLevel,@Param("area")String area,@Param("equipmentName")String equipmentName,@Param("subSystem")String subSystem,@Param("analysisType")String analysisType,@Param("analysisObjType")String analysisObjType,@Param("station")String station,@Param("pointName")String pointName, @Param("indexAddress")String indexAddress,@Param("startTimeTop") String startTimeTop, @Param("endTimeTop")String endTimeTop);


    @Select("<script>"+
            "SELECT  station, health_level as healthlevel,( CASE HEALTH_LEVEL WHEN '危险' THEN 4 WHEN '警告' THEN 3 WHEN '注意' THEN 2 ELSE 1 END ) AS sort, count( 1 ) AS `value` FROM analysis_data.fan_health_index_day WHERE analysis_obj_type = #{analysisObjType} AND ts >= TODAY()-8h" +
            "<if test='area!= null'> AND area = #{area} </if> " +
            "<if test='station!= null'>AND station = #{station} </if>" +
            " GROUP BY station,health_level  order by sort"+
            "</script>")
    List<Map<String,Object>> selectEquipStatusByStation(@Param("area")String area,@Param("analysisObjType")String analysisObjType,@Param("station")String station);

    List<Map<String, Object>> getHealthInfoByArea();
}
