package com.yeejoin.amos.boot.module.jxiop.biz.tdMapper2;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.FanHealthIndexDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanHealthIndex;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.FanHealthIndex;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.FanHealthIndexDay;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

public interface FanHealthIndexMapper extends BaseMapper<FanHealthIndex> {
    @Select("<script>"+
            "SELECT `health_index` AS healthIndex, rec_date AS recDate, `health_index` AS `value`,analysis_time AS  analysisTime, station,equipment_name AS equipmentName,  ( CASE HEALTH_LEVEL WHEN '危险' THEN 3 WHEN '警告' THEN 2 WHEN '注意' THEN 1 ELSE 0 END ) AS status FROM analysis_data.fan_health_index_data WHERE analysis_obj_type = #{analysisObjType}  and analysis_type = #{analysisType}" +
            "<if test='endTimeTop!= null'>  and ts &lt;= #{endTimeTop} </if> " +
            "<if test='startTimeTop!= null'>  and  ts &gt;= #{startTimeTop} </if> " +
            "<if test='area!= null'> AND area = #{area} </if> " +
            "<if test='indexAddress!= null'> AND index_address = #{indexAddress} </if> " +
            "<if test='pointName!= null'>AND point_name = #{pointName} </if> " +
            "<if test='station!= null'>AND station = #{station} </if>" +
            "<if test='healthLevel!= null'>AND health_level = #{healthLevel} </if>" +
            "<if test='subSystem!= null'>AND sub_system = #{subSystem} </if> " +
            "<if test='equipmentName!= null'>AND equipment_name = #{equipmentName} </if>" +
            "</script>")
    List<FanHealthIndex> selectData(@Param("healthLevel")String healthLevel, @Param("area")String area, @Param("equipmentName")String equipmentName, @Param("subSystem")String subSystem, @Param("analysisType")String analysisType, @Param("analysisObjType")String analysisObjType, @Param("station")String station, @Param("pointName")String pointName, @Param("indexAddress")String indexAddress, @Param("startTimeTop") String startTimeTop, @Param("endTimeTop")String endTimeTop);

    int saveBatchHealthIndexList(@Param("list") List<FanHealthIndex> list, @Param("tableName") String tableName, @Param("analysisType") String analysisType);

//    int saveBatchHealthIndexLatestInfo(@Param("list") List<FanHealthIndex> list, @Param("tableName") String tableName);
//
//    void deleteAllDataByTableName(@Param("tableName") String tableName, @Param("analysisType") String analysisType);

    /**
     * 测点
     *
     * @return
     */
    List<FanHealthIndex> getInfoListByGroupByCdFan(@Param("startTime") String startTime,
                                                   @Param("tableName") String tableName,
                                                   @Param("analysisObjectType") String analysisObjectType);

    /**
     * 子系统
     */
    List<FanHealthIndex> getInfoListByGroupByZxtFan(@Param("startTime") String startTime,
                                                    @Param("tableName") String tableName,
                                                    @Param("analysisObjectType") String analysisObjectType);

    /**
     * 设备
     */
    List<FanHealthIndex> getInfoListByGroupBySbFan(@Param("startTime") String startTime,
                                                   @Param("tableName") String tableName,
                                                   @Param("analysisObjectType") String analysisObjectType);

    /**
     * 场站
     */
    List<FanHealthIndex> getInfoListByGroupByCzFan(@Param("startTime") String startTime,
                                                   @Param("tableName") String tableName,
                                                   @Param("analysisObjectType") String analysisObjectType);

    /**
     * 区域
     */
    List<FanHealthIndex> getInfoListByGroupByQyFan(@Param("startTime") String startTime,
                                                   @Param("tableName") String tableName,
                                                   @Param("analysisObjectType") String analysisObjectType);

    /**
     * 全域【全国/所有】
     */
    List<FanHealthIndex> getInfoListByGroupByQgFan(@Param("startTime") String startTime,
                                                   @Param("tableName") String tableName,
                                                   @Param("analysisObjectType") String analysisObjectType);


    List<FanHealthIndex> getInfoByPage(@Param("dto") FanHealthIndexDto dto);

    Integer getInfoByPageTotal(@Param("dto") FanHealthIndexDto dto);

    List<Map<String, Object>> equipWarningRadarMapByTd(@Param("stationCode") String stationCode);

    List<Map<String, Object>> getInfoListByTableNameTs(@Param("fanGatewayId") String fanGatewayId,
                                                       @Param("indexAddress") String indexAddress,
                                                       @Param("tableName") String tableName,
                                                       @Param("recDate") String recDate,
                                                       @Param("date12") String date12);

    String getRecDateByIndexAddressTs(@Param("fanGatewayId") String fanGatewayId, @Param("indexAddress") String indexAddress, @Param("tableName") String tableName);

    List<Map<String, Object>> getPvWarningInfoBySubSystemTd(@Param("equipmentName") String equipmentName, @Param("gatewayId") String gatewayId);

    List<Map<String, Object>> getWarningInfoBySubSystemTd(@Param("subSystem") String subSystem, @Param("gatewayId") String gatewayId);

    String getInfoByDate(@Param("areaCode") String areaCode, @Param("stationCode") String stationCode, @Param("date") String date);
}
