package com.yeejoin.amos.boot.module.tzs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 安全追溯-设计信息表
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="designInfo", description="设计信息")
public class DesignInfoModel extends BaseDto {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "")
    private String supervisoryCode;

    @ApiModelProperty(value = "")
    private String instanceId;
    @ApiModelProperty(value = "")
    private String status;
    @ApiModelProperty(value = "设计单位统一社会信用代码")
    private String designUnitCreditCode;
    @ApiModelProperty(value = "设计单位")
    private String designUnitName;
    @ApiModelProperty(value = "设计许可编号")
    private String designLicenseNum;
    @ApiModelProperty(value = "设计使用年限")
    private String designUseDate;
    @ApiModelProperty(value = "设计日期")
    private Date designDate;
    @ApiModelProperty(value = "总图图号")
    private String drawingDo;
    @ApiModelProperty(value = "设计附件")
    private String designDoc;
    @ApiModelProperty(value = "设计文件鉴定单位")
    private String appraisalUnit;
    @ApiModelProperty(value = "设计单位鉴定日期")
    private String appraisalDate;
    @ApiModelProperty(value = "设计规范")
    private String designStandard;


}
