package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 奖励兑换实体
 * @author wbin
 * @date 2021-04-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_reward_exchange")
@ApiModel(value="RewardExchange对象", description="奖励兑换表")
public class RewardExchange extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "兑换批次")
    private String batchNo;

    @ApiModelProperty(value = "兑换人id")
    private Long personId;

    @ApiModelProperty(value = "任务id")
    private Long taskId;

    @ApiModelProperty(value = "兑换金额")
    private BigDecimal money;

    @ApiModelProperty(value = "发布兑换任务的用户id")
    private Long createUserId;

    @TableField(value = "exchange_date")
    private Date exchangeDate;


}
