package com.yeejoin.precontrol.common.enums;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 消息类型
 *
 * @author Admin
 */
public enum MessageTypeEnum {

	/**
	 * 技术文件
	 */
	TECH_DOCUMENT(0, "技术库", false),

	PERSON(1, "人员违章", false),

	COMPANY(2, "分包商告警", false),

	SALARY(3, "薪资反馈告警", false),

	AUDIT(4, "人员审核", true),

	THREE_LEVEL_EXAM(5, "三级安全考试", true),

	SPECIAL_EXAM(6, "专项考试", true),

	RISK_WORK(7, "风险作业", true),

	KNOWLEDGE_PUSH(8, "知识推送", true),

	KNOWLEDGE_SHARE(9, "知识分享", true),

	TECHNICAL_DISCLOSURE(10, "工程交底", true),

	SALARY_CONFIRM(11, "薪资确认", true),

	VIOLATION_INSPECTION(12, "违章检查", true),

	SERVICE_REMINDER(13, "服务提醒", true),
	
	RISK_WORK_TECH(14, "技术交底", true);

	private int type;

	private String name;

	private Boolean isApp;

	public Boolean getApp() {
		return isApp;
	}

	public void setApp(Boolean app) {
		isApp = app;
	}

	MessageTypeEnum(int type, String name, Boolean isApp) {
		this.type = type;
		this.name = name;
		this.isApp = isApp;
	}

	public static List<Map<String,Object>> appOptionList(){
		 return Arrays.stream(MessageTypeEnum.values()).filter(s->s.isApp).map(e->{
		 	Map<String,Object> item = new LinkedHashMap<>();
			 item.put("id",e.getType());
			 item.put("dictDataValue",e.getName());
			 return item;
		 }).collect(Collectors.toList());
	}

	public int getType() {
		return type;
	}

	public String getName() {
		return name;
	}

	public static String getNameByType(int type) {
		String name = null;
		for (MessageTypeEnum enumOne : MessageTypeEnum.values()) {
			if (enumOne.getType() == type) {
				name = enumOne.getName();
				break;
			}
		}
		return name;
	}
}
