package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.PersonAscription;
import com.yeejoin.precontrol.common.entity.ProjectCompany;
import com.yeejoin.precontrol.common.entity.VideoBlock;
import com.yeejoin.precontrol.common.mapper.VideoBlockMapper;
import com.yeejoin.precontrol.common.service.IPersonAscriptionService;
import com.yeejoin.precontrol.common.service.IPersonService;
import com.yeejoin.precontrol.common.service.IProjectCompanyService;
import com.yeejoin.precontrol.common.service.IVideoBlockService;
import com.yeejoin.precontrol.common.vo.VideoBlockVo;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.Date;
import java.util.List;

/**
 * @Author: songLei
 * @Description:
 * @Date: 2021/10/15 10:05
 * @Version: 1.0
 */
@Service
public class VideoBlockServiceImpl extends ServiceImpl<VideoBlockMapper, VideoBlock> implements IVideoBlockService {
	@Autowired
	private IProjectCompanyService projectCompanyService;

	@Autowired
	private IPersonService iPersonService;

	@Autowired
	private IPersonAscriptionService iPersonAscriptionService;

	/**
	 * @param model
	 * @Description 记录用户浏览
	 * @Return Boolean
	 * @Date 2021/10/15 15:05
	 */
	@Override
	public Boolean browseVideo(AgencyUserModel model) {
		if (model != null) {
			Long personId = model.getSequenceNbr();
			String realName = model.getRealName();
			Long companyId = CollectionUtils.isNotEmpty(model.getCompanys())
					? model.getCompanys().stream().findFirst().get().getSequenceNbr()
					: null;
			String mobile = model.getMobile();
			String deptName = (model.getCompanyDepartments() != null && model.getCompanyDepartments().size() > 0)
					? model.getCompanyDepartments().get(companyId).stream().findFirst().get().getDepartmentName()
					: null;
			List<ProjectCompany> projectCompanies = projectCompanyService
					.list(new QueryWrapper<ProjectCompany>().lambda().eq(ProjectCompany::getCompanyId, companyId));
			Long projectId = CollectionUtils.isNotEmpty(projectCompanies)
					? projectCompanies.stream().findFirst().get().getProjectId()
					: null;
			VideoBlock videoBlock = this
					.getOne(new QueryWrapper<VideoBlock>().lambda().eq(VideoBlock::getPersonId, personId));
			if (videoBlock != null) {
				videoBlock.setBrowsingVideo(videoBlock.getBrowsingVideo() + 1);
				return this.updateById(videoBlock);
			} else {
				VideoBlock vb = new VideoBlock();
				vb.setPersonId(personId);
				vb.setProjectId(projectId);
				vb.setAccount(mobile);
				vb.setDeptName(deptName);
				vb.setRealName(realName);
				vb.setBrowsingVideo(1);
				return this.save(vb);
			}
		}
		return Boolean.FALSE;
	}

	/**
	 * @param model
	 * @Description 离开浏览
	 * @Return Boolean
	 * @Date 2021/10/15 15:28
	 */
	@Override
	public Boolean leaveBrowse(AgencyUserModel model) {
		if (model != null) {
			Long personId = model.getSequenceNbr();
			VideoBlock videoBlock = this
					.getOne(new QueryWrapper<VideoBlock>().lambda().eq(VideoBlock::getPersonId, personId));
			if (videoBlock != null) {
				int num = videoBlock.getBrowsingVideo().intValue();
				videoBlock.setBrowsingVideo(num > 0 ? num - 1 : num);
				return this.updateById(videoBlock);
			}
		}
		return Boolean.FALSE;
	}

	public Boolean restBrowsingVideo(Long personId) {
		VideoBlock videoBlock = this
				.getOne(new QueryWrapper<VideoBlock>().lambda().eq(VideoBlock::getPersonId, personId));
		if (videoBlock != null) {
			videoBlock.setBrowsingVideo(0);
			return this.updateById(videoBlock);
		}
		return Boolean.FALSE;
	}

	@Override
	public Boolean browseVideo(Long personId) {
		VideoBlock videoBlock = this
				.getOne(new QueryWrapper<VideoBlock>().lambda().eq(VideoBlock::getPersonId, personId));
		if (videoBlock != null) {
			return true;
		}
		Person person = iPersonService.getById(personId);
		if (person == null) {
			return false;
		}
		PersonAscription personAscription = iPersonAscriptionService
				.getOne(new LambdaQueryWrapper<PersonAscription>().eq(PersonAscription::getPersonId, personId));
		VideoBlock vb = new VideoBlock();
		vb.setPersonId(personId);
		vb.setProjectId(personAscription.getProjectId());
		vb.setAccount(person.getAccountName());
		vb.setDeptName(personAscription.getDepartmentName());
		vb.setRealName(person.getName());
		vb.setBrowsingVideo(1);
		vb.setUpdateTime(new Date());
		this.save(vb);
		return true;
	}

	@Override
	public Boolean leaveBrowse(Long personId) {
		this.remove(new QueryWrapper<VideoBlock>().lambda().eq(VideoBlock::getPersonId, personId));
		return true;
	}

	/**
	 * @param page,videoBlock
	 * @Description 分页查询
	 * @Return Boolean
	 * @Date 2021/10/15 15:28
	 */
	@GetMapping("/getPage")
	public IPage<VideoBlockVo> getPage(Page page, VideoBlockVo vo) {
		return baseMapper.getPage(page, vo);
	}

}
