package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificIndex;
import com.yeejoin.equipmanage.common.entity.Video;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentIndexVO;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentSecificDetailVO;

import java.util.List;
import java.util.Map;

/**
 * @author ZeHua Li
 * @date 2020/10/30 11:17
 * @since v2.0
 */
public interface IEquipmentSpecificIndexSerivce extends IService<EquipmentSpecificIndex> {

    /**
     * 通过设备id查询
     *
     * @Author lizehua
     * @Date 2020/11/18 19:40
     */
    List<EquipmentSpecificIndex> getEquipmentSpeIndexByEquipmentSecificId(Long id);

    /**
     * 通过设备id查询视频
     *
     * @Author lizehua
     * @Date 2020/11/18 19:40
     */
    List<Video> getVideoByEquipmentSecificId(Long id);

    /**
     * 通过设备id查询设备详细信息
     *
     * @Author lizehua
     * @Date 2020/11/18 19:40
     */
    EquipmentSecificDetailVO getEquipmentDetailBySecificId(Long id);

    List<Map<String, Object>> selectEquProperty(Long id);

    /**
     * <pre>
     * @Description: 通过 iot_code查询
     * </pre>
     *
     * @MethodName:
     * @Param: []
     * @Return: List<EquipmentSpecificIndex>
     * @Throws
     * @Author keyong
     * @Date 2020/11/3 17:58
     */
    List<EquipmentSpecificIndex> getEquipmentSpeIndexBySpeIotCode(String iotCode);

    /**
     * 明细列表
     **/
    List<Map<String, Object>> selectEquList(int pageNum, int pageSize, String name, String standard, String manufacturerName);

    List<Map<String, Object>> selectEquListcount(String name, String standard, String manufacturerName);


    /**
     * 安裝业务唯一索引更新指标--批量
     *
     * @param equipmentSpecificId          实例id
     * @param List<EquipmentSpecificIndex> 指标业务id
     */
    void updateIndexValueBatchByUniqueKey(Long equipmentSpecificId, List<EquipmentSpecificIndex> equipmentSpecificIndices);

    List<EquipmentIndexVO> getEquipSpecificIndexList(EquipmentIndexVO equipmentIndexVo);

    List<EquipmentIndexVO> getEquipIndexBySpecificIdIn(List<String> specificDetails);

    List<EquipmentIndexVO> getEquipIndexByIdIn(List<Long> specificIndexIds);

    IPage<Map<String, Object>> getPage(Page<EquipmentSpecificIndex> page, String bizOrgCode, String systemId, String equipName, String startDate, String endDate);
}
