package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.equipmanage.common.entity.EquipmentCategory;
import com.yeejoin.equipmanage.common.entity.WlSpareEquipment;
import com.yeejoin.equipmanage.common.entity.vo.WlSpareEquipmentExportVo;
import com.yeejoin.equipmanage.common.vo.EquipmentDate;

import java.util.List;
import java.util.Map;

public interface WlSpareEquipmentService {
    /**
     * 新增/编辑
     */
    WlSpareEquipment saveOrUpdateSpareEquipment(WlSpareEquipment wlSpareEquipment, ReginParams reginParams);

    /**
     * 删除
     */
    int deleteByIds(List<Long> ids);

    WlSpareEquipment getById(Long id);

    Page<WlSpareEquipment> listByPage(WlSpareEquipment dto, Page page, int hierarchy, String codeHead);

    void saveImportBatch(List<WlSpareEquipmentExportVo> list, ReginParams reginParams);

    void subtractNum(Long id, Float num);

    List<EquipmentCategory> getEquipmentTypeAndCount(String bizOrgCode);

    List<Map<String, Object>> countSpareEquip(String bizOrgCode);

    List<WlSpareEquipment> exportList(WlSpareEquipment dto, int hierarchy, String codeHead);
}
