package com.yeejoin.amos.boot.module.jcs.biz.controller;


import com.yeejoin.amos.boot.module.common.api.service.IOrgUsrService;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@Api(tags = "报表填充字段接口")
@RestController
@RequestMapping("/reportSource")
public class ReportController {


    @Autowired
    private IOrgUsrService orgUsrService;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "获取换流站已配备消防人员的换流站数量", notes = "获取换流站已配备消防人员的换流站数量")
    @RequestMapping(value = "/station/count", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public ResponseModel getPersonDetailById(@RequestParam(value = "bizOrgCode") String bizOrgCode,
                                             @RequestParam(value = "startTime") String startTime,
                                             @RequestParam(value = "endTime") String endTime
    ) {
        return CommonResponseUtil.success(orgUsrService.reportResult(startTime,endTime, bizOrgCode));
    }
}
