package com.yeejoin.amos.patrol.business.controller;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.component.feign.model.Page;
import com.yeejoin.amos.patrol.business.service.intfc.IPlanTaskService;
import com.yeejoin.amos.patrol.business.util.CommonResponse;
import com.yeejoin.amos.patrol.business.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.business.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import javax.annotation.Resource;

@RestController
@RequestMapping("/api/controlScreen")
@Api(value = "管控屏API", tags = "管控屏API")
public class ControlScreenController extends AbstractBaseController {

    @Resource
    private IPlanTaskService iPlanTaskService;

    @GetMapping("/firePatrolStatics")
    @ApiOperation(value = "消防巡检信息统计")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    public CommonResponse firePatrolStatics(@RequestParam(required = false) String bizOrgCode) {
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = reginParams.getPersonIdentity().getCompanyBizOrgCode();
        }
        return CommonResponseUtil.success(iPlanTaskService.firePatrolStatics(bizOrgCode));
    }

    @GetMapping("/statics")
    @ApiOperation(value = "消防运维信息")
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    public CommonResponse getStatics(
            @RequestParam(required = false) String companyCode,
            @RequestParam(required = false) String bizOrgCode
    ) {
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = reginParams.getPersonIdentity().getCompanyBizOrgCode();
        }
        return CommonResponseUtil.success(iPlanTaskService.getStatics(companyCode, bizOrgCode));
    }

    @GetMapping("/center/statics")
    @ApiOperation(value = "消防巡检统计")
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    public CommonResponse getCenterStatics(@RequestParam(required = false) String bizOrgCode) {
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = reginParams.getPersonIdentity().getCompanyBizOrgCode();
        }
        return CommonResponseUtil.success(iPlanTaskService.getCenterStatics(bizOrgCode));
    }

    @GetMapping("/station/statics")
    @ApiOperation(value = "消防巡检统计")
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    public CommonResponse getStationStatics(@RequestParam(required = false) String bizOrgCode) {
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = reginParams.getPersonIdentity().getCompanyBizOrgCode();
        }
        return CommonResponseUtil.success(iPlanTaskService.getStationStatics(bizOrgCode));
    }

    @GetMapping("/patrol-activity/stats")
    @ApiOperation(value = "消防巡检统计")
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    public CommonResponse getPatrolActivityStats(
            @RequestParam(value = "date", required = false) String date,
            @RequestParam(value = "bizOrgCode", required = false) String bizOrgCode
    ) {
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = reginParams.getPersonIdentity().getCompanyBizOrgCode();
        }
        return CommonResponseUtil.success(iPlanTaskService.getPatrolActivityStats( bizOrgCode, date));
    }

    @GetMapping("/patrol-record/page")
    @ApiOperation(value = "消防巡检列表")
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    public CommonResponse getPatrolRecordPage(
            @RequestParam("pageNumber") Integer pageNumber,
            @RequestParam("pageSize") Integer pageSize,
            @RequestParam(value = "date", required = false) String date,
            @RequestParam(value = "bizOrgCode", required = false) String bizOrgCode,
            @RequestParam(value = "patrolStatus", required = false) String patrolStatus,
            @RequestParam(value = "missStatus", required = false) String missStatus,
            @RequestParam(value = "sorter", required = false) String sorter
    ) {
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = reginParams.getPersonIdentity().getCompanyBizOrgCode();
        }
        return CommonResponseUtil.success(iPlanTaskService.getPatrolRecordPage(pageNumber, pageSize, bizOrgCode, patrolStatus, missStatus, date, sorter));
    }
}
