package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
* 航空器信息
*
* @author system_generator
* @date 2021-06-29
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("jc_aircraft")
public class Aircraft extends BaseEntity {

    private static final long serialVersionUID = 1L;


    /**
	  * 飞机型号
     */
	@TableField("aircraft_model")
    private String aircraftModel;
    /**
	  * 中文全称
     */
	@TableField("full_name")
    private String fullName;
    /**
	  * 飞机长度
     */
	@TableField("aircraft_length")
    private Double aircraftLength;
    /**
	  * 机舱长度
     */
	@TableField("cabin_length")
    private Double cabinLength;
    /**
	  * 尾翼高度
     */
	@TableField("tail_height")
    private Double tailHeight;
    /**
	  * 翼展
     */
	@TableField("wingspan")
    private Double wingspan;
    /**
	  * 机身直径
     */
	@TableField("fuselage_diameter")
    private Double fuselageDiameter;
    /**
	  * 翼展面积
     */
	@TableField("wingspan_area")
    private Double wingspanArea;
    /**
	  * 发动机类型
     */
	@TableField("engine_type")
    private String engineType;
    /**
     * 发动机类型code
     */
    @TableField("engine_type_code")
    private String engineTypeCode;
    /**
	  * 发动机数量
     */
	@TableField("enginesm_num")
    private Integer enginesmNum;
    /**
	  * 发动机型号
     */
	@TableField("engine_model")
    private String engineModel;
    /**
	  * 燃油类型
     */
	@TableField("fuel_type")
    private String fuelType;
    /**
     * 燃油类型code
     */
    @TableField("fuel_type_code")
    private String fuelTypeCode;
    /**
	  * 最大载油量
     */
	@TableField("oil_load_max")
    private Double oilLoadMax;
    /**
	  * 标准燃油
     */
	@TableField("standard_fuel")
    private Double standardFuel;
    /**
	  * 空重
     */
	@TableField("empty_weight")
    private Double emptyWeight;
    /**
	  * 飞机主要构造材料
     */
	@TableField("structural_material")
    private String structuralMaterial;
    /**
	  * 氧气瓶数量
     */
	@TableField("oxygen_cylinder_num")
    private Integer oxygenCylinderNum;
    /**
	  * 氧气瓶位置描述
     */
	@TableField("oxygen_cylinder_location")
    private String oxygenCylinderLocation;
    /**
	  * 标准坐席数
     */
	@TableField("seat_num")
    private Integer seatNum;
    /**
	  * 商载(吨)
     */
	@TableField("commercial_load")
    private Double commercialLoad;
    /**
	  * 货仓容积（立方米）
     */
	@TableField("warehouse_volume")
    private Double warehouseVolume;
    /**
	  * 最大起飞总重（吨）
     */
	@TableField("takeoff_weight_num")
    private Double takeoffWeightNum;
    /**
	  * 最大巡航速度（马赫）
     */
	@TableField("cruise_speed_num")
    private Double cruiseSpeedNum;
    /**
	  * 航程
     */
	@TableField("voyage")
    private Double voyage;
    /**
	  * 主要设施
     */
	@TableField("facilitie")
    private String facilitie;
    /**
	  * 主要燃烧物质
     */
	@TableField("combustion_material")
    private String combustionMaterial;
    /**
	  * 疏散出口及安全通道
     */
	@TableField("exit_passage")
    private String exitPassage;
    /**
	  * 备注
     */
	@TableField("remark")
    private String remark;
	
    /**
     * 是否删除
     */
    @TableField("is_delete")
    private Boolean isDelete;
}
