package com.yeejoin.amos.boot.module.jcs.api.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jcs.api.dto.CarStatusInfoDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.EquipSpecificDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.EquipmentOnCarDto;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;


/**
 * 装备服务feign
 *
 * @author Dell
 */
@FeignClient(name = "AMOS-EQUIPMANAGE", path = "equip", configuration = {MultipartSupportConfig.class})
public interface EquipFeignClient {

    /**
     * 获取未列装人员装备列表数据
     *
     * @return
     */
    @RequestMapping(value = "/equipSpecific/getAirEquipSpecificPage", method = RequestMethod.POST)
    ResponseModel<Page<EquipmentOnCarDto>> getAirEquipSpecificPage(@RequestBody EquipSpecificDto var1) throws InnerInvokException;
    /**
     * 人员装备列装
     *
     * @return
     */
    @RequestMapping(value = "/stock-detail/airport/person/bind", method = RequestMethod.POST)
    ResponseModel<List<Object>> stockBindEquip(@RequestBody List<Long> ids) throws InnerInvokException;
    /**
     * 人员装备退装
     *
     * @return
     */
    @RequestMapping(value = "/scrap/airport/person", method = RequestMethod.POST)
    ResponseModel<Object> scrapEquip(@RequestBody String id) throws InnerInvokException;
    /**
     * 人员装备回库
     *
     * @return
     */
    @RequestMapping(value = "/stock-detail/airport/person", method = RequestMethod.POST)
    ResponseModel<Object> stockEquip(@RequestBody Map<String, Object> map) throws InnerInvokException;
    /**
     * 装备详情
     *
     * @return
     */
    @RequestMapping(value = "/equipSpecific/getAirEquipSpecificDetail", method = RequestMethod.GET)
    ResponseModel<Object> getAirEquipSpecificDetail(@RequestParam Long stockDetailId) throws InnerInvokException;

    /**
     * 获取车辆列表
     *
     * @return
     */
    @RequestMapping(value = "/car/list-all", method = RequestMethod.GET)
    ResponseModel<Object> getFireCarListAll();

    /**
     * 获取消防系统列表
     *
     * @return
     */
    @RequestMapping(value = "/fire-fighting-system/list", method = RequestMethod.GET)
    ResponseModel<Object> getFireSystemListAll();

    /**
     * 获取消防系统列表
     *
     * @return
     */
    @RequestMapping(value = "/building/tree", method = RequestMethod.GET)
    ResponseModel<Object> getBuildingTree();

    /**
     * 更新车辆状态
     * @param carStatusInfo 车辆状态信息
     * @return
     */
    @RequestMapping(value = "/car/status", method = RequestMethod.POST)
    ResponseModel<Object> updateCarStatus(@RequestBody List<CarStatusInfoDto> carStatusInfo);
}
