package com.yeejoin.amos.boot.module.jcs.api.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertSubmittedDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertSubmitted;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertSubmittedSMSDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.SchedulingReportingDto;

/**
* 警情报送记录 服务类
*
* @author tb
* @date 2021-06-17
*/
public interface IAlertSubmittedService extends IService<AlertSubmitted> {

    /**
     * 根据参数查询融合调度记录
     *
     * @param queryParam
     * @return SchedulingReportingDto
     */
    SchedulingReportingDto listSchedulingByParam(AlertSubmittedDto queryParam);

    /**
     * 根据参数查询警情报送记录
     *
     * @param queryParam
     * @return SchedulingReportingDto
     */
    SchedulingReportingDto listReportingByParam(AlertSubmittedDto queryParam);

    /**
     * 警情报送保存
     *
     * @param alertSubmittedDto
     * @param userName
     * @return
     */
    Boolean save(AlertSubmittedDto alertSubmittedDto, String userName) throws Exception;

    AlertSubmittedSMSDto getSchedulingContent(Long id);
}
