package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.baomidou.mybatisplus.core.toolkit.BeanUtils;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.biz.common.utils.MenuFrom;
import com.yeejoin.amos.boot.biz.common.utils.TreeParser;
import com.yeejoin.amos.boot.module.jcs.api.dto.FireSystemDto;
import com.yeejoin.amos.boot.module.jcs.api.feign.EquipFeignClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;
import java.util.Timer;

/**
 * @author DELL
 */
@Service
public class EquipmentServiceImpl {

    @Autowired
    EquipFeignClient equipFeignClient;

    public List<MenuFrom> getFireSystemList() {
        ResponseModel<Object> response = equipFeignClient.getFireSystemListAll();
        List<Map<String, Object>> fireSystemMapList = (List<Map<String, Object>>) response.getResult();
        List<MenuFrom> fireSystemDtoList = Lists.newArrayList();
        fireSystemMapList.forEach(system -> {
            MenuFrom menuFrom = new MenuFrom((String) system.get("id"), (String) system.get("name"), "0", "0");
            fireSystemDtoList.add(menuFrom);
        });
        return fireSystemDtoList;
    }

    public List<MenuFrom> getBuildingList() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        ResponseModel<Object> response = equipFeignClient.getBuildingTree();
        stopWatch.stop();
        System.out.printf("耗时%f秒/n", stopWatch.getTotalTimeSeconds());
        List<Map<String, Object>> buildingMapList = (List<Map<String, Object>>) response.getResult();
        List<MenuFrom> buildingTreeList = Lists.newArrayList();
        buildingMapList.forEach(building -> {
            MenuFrom menuFrom = new MenuFrom((String) building.get("id"), "全部建筑", (String) building.get("parentId"),
                    "0");
            List<Map<String, Object>> children = (List<Map<String, Object>>) building.get("children");
            menuFrom.setChildren(parseTree(menuFrom, children));
            menuFrom.setIsLeaf(false);
            buildingTreeList.add(menuFrom);
        });
        return buildingTreeList.get(0).getChildren();
    }

    private List<MenuFrom> parseTree(MenuFrom parent, List<Map<String, Object>> children) {
        List<MenuFrom> menuFromList = Lists.newArrayList();
        if (!ValidationUtil.isEmpty(children)) {
            children.forEach(child -> {
                MenuFrom menuFrom = new MenuFrom((String) child.get("id"), (String) child.get("name"),
                        (String) child.get("parentId"), "0");
                if (!ValidationUtil.isEmpty(child.get("children"))) {
                    parseTree(menuFrom, (List<Map<String, Object>>) child.get("children"));
                } else {
                    parent.setIsLeaf(false);
                }
                menuFromList.add(menuFrom);
                parent.setChildren(menuFromList);
            });
        }
        return menuFromList;
    }
}
