package com.yeejoin.amos.boot.module.jxiop.biz.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.CommonServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.emq.EmqxListener;

/**
 * @author Administrator
 */
@Component
@Slf4j
public class SyncESDataToTdengineMqttListener extends EmqxListener {

    @Autowired
    CommonServiceImpl commonServiceImpl;

    @Override
    public void processMessage(String topic, MqttMessage mqttMessage) {
        log.info(topic + "收到数据同步成功，开始计算健康指数！");
        byte[] payload = mqttMessage.getPayload();
        String str = new String(payload);
        String msg = JSON.parse(str).toString();
        JSONObject jsonObject = JSONObject.parseObject(msg);
        String flag = jsonObject.get("sync_flag").toString();
        if ("success".equals(flag)){
            //开始异步计算光伏的健康指数算法
            new Thread(()->{
                //调用光伏的健康指数算法
                commonServiceImpl.healthWarningMinuteByPv();
            }).start();
            //开始异步计算风机的健康指数算法
            new Thread(()->{
                //调用风机的健康指数算法
                commonServiceImpl.healthWarningMinuteByFan();
            }).start();

        }
        if ("pvsuccess".equals(flag)){
            //开始异步计算光伏的健康指数算法
            new Thread(()->{
                //调用光伏的健康指数算法
                commonServiceImpl.healthWarningMinuteByPv();
            }).start();
        }
        if ("fansuccess".equals(flag)){
            //开始异步计算光伏的健康指数算法
            new Thread(()->{
                //调用光伏的健康指数算法
                commonServiceImpl.healthWarningMinuteByFan();
            }).start();
        }
    }
}
