package com.yeejoin.amos.boot.module.common.api.enums;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

public enum JYJCBusinessTypeEnum {
    DQJY("DQJY","定期检验"),
    SCJY("SCJY","首次检验"),

    AZJDJY("AZJDJY","安装监督检验"),

    GZJDJY("GZJDJY","改造监督检验"),
    WXJDJY("WXJDJY","维修监督检验"),
    ZZJDJY("ZZJDJY","制造监督检验"),
    DTJC("DTJC","电梯检测");


    private JYJCBusinessTypeEnum(String code, String name){
        this.code=code;
        this.name=name;
    }

    private String code;

    private String name;

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static List<HashMap<String,Object>> getEnumList() {
        List<HashMap<String, Object>> list = new ArrayList<>();
        for (JYJCBusinessTypeEnum testEnum : EnumSet.allOf(JYJCBusinessTypeEnum.class)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("title",testEnum.name);
            map.put("value",testEnum.code);
            list.add(map);
        }
        return list;
    }
    public static JYJCBusinessTypeEnum getNameByCode(String code){
        for (JYJCBusinessTypeEnum value : JYJCBusinessTypeEnum.values()) {
            if (value.getCode().equals(code)){
                return value;
            }
        }
        return null;
    }
}
