package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgProjectContraptionServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.dto.IdxBizJgProjectContraptionDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgInspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 管道工程装置表
 *
 * @author system_generator
 * @date 2024-12-11
 */
@RestController
@Api(tags = "管道工程装置表Api")
@RequestMapping(value = "/idx-biz-jg-project-contraption")
public class IdxBizJgProjectContraptionController extends BaseController {
	// 设备基本信息表单id
	private static final String EQUIP_INFO_FORM_ID = "equipInfo";
    @Autowired
	IdxBizJgProjectContraptionServiceImpl idxBizJgProjectContraptionServiceImpl;

    /**
     * 新增管道工程装置表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增管道工程装置表", notes = "新增管道工程装置表")
	public ResponseModel<IdxBizJgProjectContraption> save(@RequestBody IdxBizJgProjectContraptionDto model) {
	    return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.saveFirstMergeProjectContraption(model));
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新管道工程装置表", notes = "根据sequenceNbr更新管道工程装置表")
	public ResponseModel<IdxBizJgProjectContraptionDto> updateBySequenceNbrIdxBizJgProjectContraption(@RequestBody IdxBizJgProjectContraptionDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除管道工程装置表及设备信息", notes = "根据sequenceNbr删除管道工程装置表及设备信息")
	public ResponseModel<Boolean> deleteBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.deleteProjectAndEquInfoBySeq(sequenceNbr));
    }

	/**
	 * 根据入参 分页查询（当前）单位下的工程管道
	 *
	 * @param params  - isIntoManagement 是否是否纳管 true/false
	 *                - useRegistrationCode 使用登记编号 string()
	 *                - regCodeIsNull 使用登记编号是否为空 true/false
	 * @param current 当前页
	 * @param size    每页大小
	 * @return result
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/pageByParams")
	@ApiOperation(httpMethod = "GET", value = "根据入参 分页查询（当前）单位下的工程管道", notes = "根据入参 分页查询（当前）单位下的工程管道")
	public ResponseModel<IPage<IdxBizJgProjectContraption>> proConPageByParams(
			@RequestParam Map<String, String> params,
			@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size) {
		Page<IdxBizJgProjectContraption> page = new Page<>();
		page.setCurrent(current);
		page.setSize(size);
		ReginParams reginParams = getSelectedOrgInfo();
		return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.proConPageByParams(params, page, reginParams));
	}


	/**
	 * 根据入参 列表查询（当前）单位下的工程管道
	 *
	 * @param params - isIntoManagement 是否是否纳管 true/false
	 *               - useRegistrationCode 使用登记编号 string()
	 *               - regCodeIsNull 使用登记编号是否为空 true/false
	 * @return result
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/listByParams")
	@ApiOperation(httpMethod = "GET", value = "根据入参 列表查询（当前）单位下的工程管道", notes = "根据入参 列表查询（当前）单位下的工程管道")
	public ResponseModel<List<IdxBizJgProjectContraption>> proConListByParams(@RequestParam Map<String, String> params) {
		ReginParams reginParams = getSelectedOrgInfo();
		return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.proConListByParams(params, reginParams));
	}

	/**
	 * 根据sequenceNbr查询详情
	 *
	 * @param sequenceNbr 主键
	 * @return ResponseModel
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/details")
	@ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个管道工程装置表", notes = "根据sequenceNbr查询单个管道工程装置表")
	public ResponseModel<Map<String, Map<String, Object>>> details(@RequestParam("sequenceNbr") String sequenceNbr) {
		return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.details(sequenceNbr));
	}

	/**
	 * 根据sequenceNbr查询详情-不包裹设备表单Id
	 *
	 * @param sequenceNbr 主键
	 * @return ResponseModel
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/detailsNotFormId")
	@ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个管道工程装置表", notes = "根据sequenceNbr查询单个管道工程装置表")
	// 传record的原因是前端组件内部写死了，此处是工程装置表seq
	public ResponseModel<Object> detailsNotFormId(@RequestParam("record") String sequenceNbr) {
		return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.details(sequenceNbr).get(EQUIP_INFO_FORM_ID));
	}

	/**
	 * 根据sequenceNbr分页查询管道信息
	 *
	 * @param sequenceNbr
	 * @param current 当前页
	 * @param size 大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/techParamsPipelinePage")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询管道信息",  notes = "管道工程装置表分页查询")
	public ResponseModel <Page<Map<String, Object>>> techParamsPipelinePage(@RequestParam("sequenceNbr") String sequenceNbr,
																		   @RequestParam(value = "current") int current,
																		   @RequestParam(value = "size") int size) {
		return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.techParamsPipelinePage(sequenceNbr,current,size));
	}

	/**
	 * 新增或者更新检验信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/saveOrUpdateDetectionInfo")
	@ApiOperation(httpMethod = "POST", value = "新增或者更新检验信息", notes = "新增或者更新检验信息")
	public ResponseModel<?> saveOrUpdateDetectionInfo(@RequestBody IdxBizJgInspectionDetectionInfo detectionInfo) {
		idxBizJgProjectContraptionServiceImpl.saveOrUpdateDetectionInfo(detectionInfo);
		return ResponseHelper.buildResponse("更新成功");
	}

	/**
	 * 新增或者更新检验信息批量
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/saveOrUpdateDetectionInfoBatch")
	@ApiOperation(httpMethod = "POST", value = "新增或者更新检验信息", notes = "新增或者更新检验信息")
	public ResponseModel<?> saveOrUpdateDetectionInfoBatch(@RequestBody JSONObject jsonObject) {
		idxBizJgProjectContraptionServiceImpl.saveOrUpdateDetectionInfoBatch(jsonObject);
		return ResponseHelper.buildResponse("更新成功");
	}

	/**
	 * 根据sequenceNbr删除datasource为jg_his_gd_pl的数据
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/deleteByHisGdPl")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除datasource为jg_his_gd_pl的数据", notes = "根据sequenceNbr删除datasource为jg_his_gd_pl的数据")
	public ResponseModel<Boolean> deleteByHisGdPl(@RequestParam(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.deleteByHisGdPl(sequenceNbr));
	}
	/**
	 * 获取检验信息详情
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getDetectionInfoDetail")
	@ApiOperation(httpMethod = "GET", value = "获取检验信息详情", notes = "获取检验信息详情")
	public ResponseModel<IdxBizJgInspectionDetectionInfo> getDetectionInfoDetail(@RequestParam("sequenceNbr") String sequenceNbr) {
		return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.getDetectionInfoDetail(sequenceNbr));
	}

	/**
	 * 获取最新检验信息详情
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getNewInspectionDetailByRecord")
	@ApiOperation(httpMethod = "GET", value = "获取最新检验信息详情", notes = "获取最新检验信息详情")
	public ResponseModel<Map<String, Object>> getNewInspectionDetailByRecord(@RequestParam("record") String record) {
		return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.getNewInspectionDetailByRecord(record));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/summaryBasicInfo/export")
	@ApiOperation(httpMethod = "GET", value = "导出基本信息汇总表(长输/公用管道)", notes = "导出基本信息汇总表(长输/公用管道)")
	public void exportSummaryBasicInfo(HttpServletResponse response,
									   @RequestParam("sequenceNbr") String sequenceNbr,
									   @RequestParam("category") String category) {
		idxBizJgProjectContraptionServiceImpl.exportSummaryBasicInfo(sequenceNbr, response, category);
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "管道工程装置表分页查询",  notes = "管道工程装置表分页查询")
	public ResponseModel<Page<IdxBizJgProjectContraptionDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<IdxBizJgProjectContraptionDto> page = new Page<IdxBizJgProjectContraptionDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.queryForIdxBizJgProjectContraptionPage(page));
	}


	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "管道工程装置表列表全部数据查询",   notes = "管道工程装置表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<IdxBizJgProjectContraptionDto>> selectForList() {
	    return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.queryForIdxBizJgProjectContraptionList());
	}
}
