package com.yeejoin.amos.boot.module.ymt.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

/**
 * 管道工程装置表
 *
 * @author system_generator
 * @date 2024-12-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@Builder
@TableName("idx_biz_jg_project_contraption")
public class IdxBizJgProjectContraption extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 工程装置名称
     */
	@TableField("project_contraption")
    private String projectContraption;

    /**
     * 工程装置编号
     */
	@TableField("project_contraption_no")
    private String projectContraptionNo;

    /**
     * 使用单位名称
     */
	@TableField("use_unit_credit_code")
    private String useUnitCreditCode;

    /**
     * 使用单位统一信用代码
     */
	@TableField("use_unit_name")
    private String useUnitName;

    /**
     * 施工单位统一信用代码
     */
	@TableField("usc_unit_credit_code")
    private String uscUnitCreditCode;

    /**
     * 施工单位名称
     */
	@TableField("usc_unit_name")
    private String uscUnitName;

    /**
     * 设备种类名称
     */
	@TableField("equ_list_name")
    private String equListName;

    /**
     * 设备种类
     */
	@TableField("equ_list")
    private String equList;

    /**
     * 设备类别名称
     */
	@TableField("equ_category_name")
    private String equCategoryName;

    /**
     * 设备代码
     */
	@TableField("equ_category")
    private String equCategory;

    /**
     * 设备品种名称
     */
	@TableField("equ_define_name")
    private String equDefineName;

    /**
     * 设备品种
     */
	@TableField("equ_define")
    private String equDefine;

    /**
     * 设备汇总表信息
     */
	@TableField("content")
    private String content;

    /**
     * 装置管道总长度(m)
     */
	@TableField("pipeline_length")
    private Double pipelineLength;

    /**
     * 产品照片附件
     */
	@TableField("product_photo")
    private String productPhoto;

    /**
     * 其他附件
     */
	@TableField("other_accessories")
    private String otherAccessories;

    /**
     * 属地监管单位代码
     */
	@TableField("org_code")
    private String orgCode;

    /**
     * 属地监管单位名称
     */
	@TableField("org_name")
    private String orgName;

    /**
     * 产品质量合格证明
     */
	@TableField("product_qualification_certificate")
    private String productQualificationCertificate;

    /**
     * 使用地点代码_省
     */
	@TableField("province")
    private String province;

    /**
     * 使用地点代码_市
     */
	@TableField("city")
    private String city;

    /**
     * 使用地点代码_区（县）
     */
	@TableField("county")
    private String county;

    /**
     * 使用地点代码_街道（镇）
     */
	@TableField("street")
    private String street;

    /**
     * 使用详细地址
     */
	@TableField("address")
    private String address;

    /**
     * 使用地点_省
     */
	@TableField("province_name")
    private String provinceName;

    /**
     * 使用地点_市
     */
	@TableField("city_name")
    private String cityName;

    /**
     * 使用地点_区
     */
	@TableField("county_name")
    private String countyName;

    /**
     * 使用地点_街道
     */
	@TableField("street_name")
    private String streetName;

    /**
     * 装置起始位置
     */
	@TableField("start_latitude_longitude")
    private String startLatitudeLongitude;

    /**
     * 装置结束位置
     */
	@TableField("end_latitude_longitude")
    private String endLatitudeLongitude;

    /**
     * 监管码
     */
	@TableField("supervisory_code")
    private String supervisoryCode;

    /**
     * 使用登记证编号
     */
    @TableField("use_registration_code")
    private String useRegistrationCode;

    /**
     *  是否是否纳管：true - 已纳管 false-未纳管
     */
    @TableField("is_into_management")
    private Boolean isIntoManagement;

    /**
     *  数据来源（新增：0、导入：1、复制：复制数据的id 、jg:从监管加入的设备）
     */
    @TableField("data_source")
    private String dataSource;

    /**
     *  数据来源名字
     */
    @TableField(exist = false)
    private String dataSourceName;

    /**
     *  是否可编辑
     */
    @TableField(exist = false)
    private Boolean canEdit;

    /**
     *  是否可删除
     */
    @TableField(exist = false)
    private Boolean canDelete;

    /**
     *  使用地址
     */
    @TableField(exist = false)
    private String fullAddress;

    /**
     * 工程装置设备代码
     */
    @TableField("equ_code")
    private String equCode;

    /**
     * 投入日期
     */
    @TableField("use_date")
    private String useDate;

    /**
     * 工程装置父级ID（合并用）
     */
    @TableField("project_contraption_parent_id")
    private String projectContraptionParentId;

    /**
     * 是否首次合并新增
     */
    @TableField("is_first_merge")
    private Boolean isFirstMerge;

    /**
     * 最新一次管道改造的长度变化值（正值为增加，负值为减少）
     */
    @TableField("pipe_length_changed")
    private String pipeLengthChanged;

    /**
     * 是否禁用打印汇总表按钮
     */
    @TableField(exist = false)
    private Boolean disableBasicButton;

}
