package com.yeejoin.amos.boot.module.jxiop.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 户用光伏合同表
 *
 * @author system_generator
 * @date 2023-03-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("household_pv_lease")
public class HouseholdPvLease extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 户用光伏id
     */
	@TableField("household_pv_id")
    private Long householdPvId;

    /**
     * 安装地址
     */
	@TableField("install_address")
    private String installAddress;

    /**
     * 安装日期
     */
	@TableField("install_date")
    private Date installDate;

    /**
     * 预计功率(w)
     */
	@TableField("estimated_power")
    private Integer estimatedPower;

    /**
     * 组件单片功率(w)
     */
	@TableField("monolithic_power")
    private Integer monolithicPower;

    /**
     * 共计安装数量(块)
     */
	@TableField("install_count")
    private Integer installCount;

    /**
     * 实际容量(w)
     */
	@TableField("actual_capacity")
    private Integer actualCapacity;

    /**
     * 电站类型
     */
	@TableField("station_type")
    private String stationType;

    /**
     * 组件规格
     */
	@TableField("module_type")
    private String moduleType;

    /**
     * 创建时间
     */
	@TableField("create_time")
    private Date createTime;

}
