package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.HouseholdPvLeaseServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.dto.HouseholdPvLeaseDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 户用光伏合同表
 *
 * @author system_generator
 * @date 2023-03-17
 */
@RestController
@Api(tags = "户用光伏合同表Api")
@RequestMapping(value = "/household-pv-lease")
public class HouseholdPvLeaseController extends BaseController {

    @Autowired
    HouseholdPvLeaseServiceImpl householdPvLeaseServiceImpl;

    /**
     * 新增户用光伏合同表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增户用光伏合同表", notes = "新增户用光伏合同表")
	public ResponseModel<HouseholdPvLeaseDto> save(@RequestBody HouseholdPvLeaseDto model) {
	    model = householdPvLeaseServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新户用光伏合同表", notes = "根据sequenceNbr更新户用光伏合同表")
	public ResponseModel<HouseholdPvLeaseDto> updateBySequenceNbrHouseholdPvLease(@RequestBody HouseholdPvLeaseDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(householdPvLeaseServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除户用光伏合同表", notes = "根据sequenceNbr删除户用光伏合同表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(householdPvLeaseServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个户用光伏合同表",  notes = "根据sequenceNbr查询单个户用光伏合同表")
	public ResponseModel<HouseholdPvLeaseDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(householdPvLeaseServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "户用光伏合同表分页查询",  notes = "户用光伏合同表分页查询")
	public ResponseModel<Page<HouseholdPvLeaseDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<HouseholdPvLeaseDto> page = new Page<>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(householdPvLeaseServiceImpl.queryForHouseholdPvLeasePage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "户用光伏合同表列表全部数据查询",   notes = "户用光伏合同表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<HouseholdPvLeaseDto>> selectForList() {
	    return ResponseHelper.buildResponse(householdPvLeaseServiceImpl.queryForHouseholdPvLeaseList());
	}
}
