package com.yeejoin.amos.api.openapi.face.service;


import java.util.Date;
import java.util.List;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderFillingCheckDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderFillingDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import com.yeejoin.amos.api.openapi.face.model.TmCylinderFillingCheckModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.TmCylinderFillingCheckMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.TmCylinderFillingCheck;


/**
 * 
 * <pre>
 * 液化气体气瓶充装信息-充装后复查 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: ElevatorService.java, v 0.1 2021年9月30日 下午3:28:55 gwb Exp $
 */
@Component
public class TmCylinderFillingCheckService extends BaseService<TmCylinderFillingCheckModel, TmCylinderFillingCheck, TmCylinderFillingCheckMapper> {
    @Autowired
    private RedisTemplate redisTemplate;
	@Autowired
	private SyncCylinderDataService syncCylinderDataService;

	@DSTransactional
	public String createCylinderFillingAfter(List<TmCylinderFillingCheckModel> model) {
		// TODO Auto-generated method stub
//		if (ValidationUtil.isEmpty(model))
//			throw new BadRequest("气瓶标签信息为空.");
		syncCylinderFillingAfter(model);
		for (TmCylinderFillingCheckModel cylinderFillingCheckModel : model) {
			cylinderFillingCheckModel.setRecDate(new Date());
			cylinderFillingCheckModel.setAppId(getAppId());
			this.createWithModel(cylinderFillingCheckModel);
		}
		return "OK";
	}

	private void syncCylinderFillingAfter(List<TmCylinderFillingCheckModel> model) {
		syncCylinderDataService.syncCylinderFillingAfter(model);
	}

	private String getAppId() {
		String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX,RequestContext.getToken());
    	BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
    	return bizTokenModel.getAppId();
	}	
}
