package com.yeejoin.amos.api.openapi.face.service;


import java.util.Date;
import java.util.List;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.yeejoin.amos.api.openapi.face.model.TmCylinderUnitModel;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderFillingExamineDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderUnitDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import com.yeejoin.amos.api.openapi.face.model.TmCylinderFillingExamineModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.TmCylinderFillingExamineMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.TmCylinderFillingExamine;


/**
 * 
 * <pre>
 * 液化气体气瓶充装信息审核 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: ElevatorService.java, v 0.1 2021年9月30日 下午3:28:55 gwb Exp $
 */
@Component
public class TmCylinderFillingExamineService extends BaseService<TmCylinderFillingExamineModel, TmCylinderFillingExamine, TmCylinderFillingExamineMapper> {
    @Autowired
    private RedisTemplate redisTemplate;
	@Autowired
	private SyncCylinderDataService syncCylinderDataService;


	@DSTransactional
	public String createCylinderFillingExamine(List<TmCylinderFillingExamineModel> model) {
		// TODO Auto-generated method stub
		if (ValidationUtil.isEmpty(model))
			throw new BadRequest("液化气体气瓶充装信息审核为空.");
		syncCylinderFillingExamine(model);
		for (TmCylinderFillingExamineModel cylinderFillingExamineModel : model) {
			cylinderFillingExamineModel.setRecDate(new Date());
			cylinderFillingExamineModel.setAppId(getAppId());
			this.createWithModel(cylinderFillingExamineModel);
		}
		return "OK";
	}

	private String getAppId() {
		String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX,RequestContext.getToken());
    	BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
    	return bizTokenModel.getAppId();
	}

	private void syncCylinderFillingExamine(List<TmCylinderFillingExamineModel> model ) {
		syncCylinderDataService.syncCylinderFillingExamine(model);
	}
}
