package com.yeejoin.amos.api.openapi.face.service;


import java.util.Date;
import java.util.List;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.yeejoin.amos.api.openapi.face.model.TmCylinderUnitModel;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderFillingDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderInfoDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderUnitDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import com.yeejoin.amos.api.openapi.face.model.TmCylinderFillingModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.TmCylinderFillingMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.TmCylinderFilling;


/**
 * 
 * <pre>
 * 气瓶充装信息--充装前检查 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: ElevatorService.java, v 0.1 2021年9月30日 下午3:28:55 gwb Exp $
 */
@Component
public class TmCylinderFillingService extends BaseService<TmCylinderFillingModel, TmCylinderFilling, TmCylinderFillingMapper> {
    @Autowired
    private RedisTemplate redisTemplate;
	@Autowired
	private SyncCylinderDataService syncCylinderDataService;

    @DSTransactional
	public String createCylinderFillingBefore(List<TmCylinderFillingModel> model) {
		// TODO Auto-generated method stub
//		if (ValidationUtil.isEmpty(model))
//			throw new BadRequest("气瓶标签信息为空.");

		syncCylinderFillingBefore(model);
		for (TmCylinderFillingModel cylinderFillingModel : model) {
			cylinderFillingModel.setRecDate(new Date());
			cylinderFillingModel.setAppId(getAppId());
			this.createWithModel(cylinderFillingModel);
		}
		return "OK";
	}

	private void syncCylinderFillingBefore(List<TmCylinderFillingModel> model) {
		syncCylinderDataService.syncCylinderFillingBefore(model);
	}


	private String getAppId() {
		String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX,RequestContext.getToken());
    	BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
    	return bizTokenModel.getAppId();
	}

}	
