package com.yeejoin.amos.api.openapi.face.service;


import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.google.common.collect.Lists;
import com.yeejoin.amos.api.openapi.face.model.TmCylinderUnitModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.ESCylinderInfoRepository;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.cylinder.api.entity.ESCylinderInfoDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderInfoDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderUnitDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.mapper.CylinderInfoMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import com.yeejoin.amos.api.openapi.face.model.TmCylinderInfoModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.TmCylinderInfoMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.TmCylinderInfo;


/**
 * 
 * <pre>
 *气瓶基本信息 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: ElevatorService.java, v 0.1 2021年9月30日 下午3:28:55 gwb Exp $
 */
@Component
@Slf4j
public class TmCylinderInfoService extends BaseService<TmCylinderInfoModel, TmCylinderInfo, TmCylinderInfoMapper> {
    @Autowired
    private RedisTemplate redisTemplate;

	@Autowired
	CylinderInfoMapper cylinderInfoMapper;
	@Autowired
	private SyncCylinderDataService syncCylinderDataService;
	@Autowired
	ESCylinderInfoRepository esCylinderInfoRepository;

	@DSTransactional
	public String createCylinderInfo(List<TmCylinderInfoModel> model) {
		// TODO Auto-generated method stub
		if (ValidationUtil.isEmpty(model))
			throw new BadRequest("气瓶基本信息数据为空.");
		syncCylinderInfo(model);


		for (TmCylinderInfoModel cylinderInfoModel : model) {
			cylinderInfoModel.setRecDate(new Date());
			cylinderInfoModel.setAppId(getAppId());

			syncCylinderDataService.createCylinderInfo2ES(cylinderInfoModel);
			this.createWithModel(cylinderInfoModel);
		}
		return "OK";
	}

	private void syncCylinderInfo(List<TmCylinderInfoModel> model ) {
		syncCylinderDataService.syncCylinderInfo(model);
	}
	private String getAppId() {
		String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX,RequestContext.getToken());
    	BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
    	return bizTokenModel.getAppId();
	}


}
