package com.yeejoin.amos.api.openapi.face.service;


import java.util.Date;
import java.util.List;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderInspectionDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderTagsDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import com.yeejoin.amos.api.openapi.face.model.TmCylinderTagsModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.TmCylinderTagsMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.TmCylinderTags;


/**
 * 
 * <pre>
 * 气瓶标签信息 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: ElevatorService.java, v 0.1 2021年9月30日 下午3:28:55 gwb Exp $
 */
@Component
public class TmCylinderTagsService extends BaseService<TmCylinderTagsModel, TmCylinderTags, TmCylinderTagsMapper> {
    @Autowired
    private RedisTemplate redisTemplate;
	@Autowired
	private SyncCylinderDataService syncCylinderDataService;

	@DSTransactional
	public String createCylinderTag(List<TmCylinderTagsModel> model) {
		// TODO Auto-generated method stub
		if (ValidationUtil.isEmpty(model))
			throw new BadRequest("气瓶标签信息为空.");
		syncCylinderTag(model);
		for (TmCylinderTagsModel cylinderTagsModel : model) {
			cylinderTagsModel.setRecDate(new Date());
			cylinderTagsModel.setAppId(getAppId());
			this.createWithModel(cylinderTagsModel);
		}
		return "OK";
	}

	private void syncCylinderTag(List<TmCylinderTagsModel> model) {
		syncCylinderDataService.syncCylinderTag(model);
	}

	private String getAppId() {
		String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX,RequestContext.getToken());
    	BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
    	return bizTokenModel.getAppId();
	}	
}
