package com.yeejoin.amos.boot.module.jg.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.jg.api.common.BizCustomDateSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * @author system_generator
 * @date 2023-12-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JgMaintenanceContractDto", description = "")
public class JgMaintenanceContractDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "维保备案编号")
    private String applyNo;


    @ApiModelProperty(value = "办理状态")
    private String applyStatus;

    @ApiModelProperty(value = "流程实例id")
    private String instanceId;

    @ApiModelProperty(value = "维保备案日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date applyDate;

    @ApiModelProperty(value = "设备类型")
    private String equType;

    @ApiModelProperty(value = "使用单位统一信用代码")
    private String useUnitCode;

    @ApiModelProperty(value = "使用单位")
    private String useUnitName;

    @ApiModelProperty(value = "接收机构统一信用代码")
    private String receiveOrgCode;

    @ApiModelProperty(value = "接收机构")
    private String receiveOrgName;

    @ApiModelProperty(value = "维保单位统一信用代码")
    private String maintenanceUnitCode;

    @ApiModelProperty(value = "维保单位名称")
    private String maintenanceUnitName;

    @ApiModelProperty(value = "维保合同开始日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date informStart;

    @ApiModelProperty(value = "维保合同结束日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date informEnd;

    @ApiModelProperty(value = "维保合同开始日期-维保合同结束日期")
    private String informStartAndEnd;

    @ApiModelProperty(value = "安全管理员id")
    private String maintenanceManagerId;

    @ApiModelProperty(value = "安全管理员姓名")
    private String maintenanceManagerName;

    @ApiModelProperty(value = "安全管理员姓名联系方式")
    private String maintenanceManagerPhone;


    @ApiModelProperty(value = "维保负责人一id")
    private String maintenanceManagerOneId;

    @ApiModelProperty(value = "维保负责人一姓名")
    private String maintenanceManagerOneName;

    @ApiModelProperty(value = "维保负责人一联系方式")
    private String maintenanceManagerOnePhone;

    @ApiModelProperty(value = "维保负责人一身份证号码")
    private String maintenanceManagerOneIdNum;

    @ApiModelProperty(value = "维保负责人二id")
    private String maintenanceManagerTwoId;

    @ApiModelProperty(value = "维保负责人二姓名")
    private String maintenanceManagerTwoName;

    @ApiModelProperty(value = "维保负责人二联系方式")
    private String maintenanceManagerTwoPhone;

    @ApiModelProperty(value = "维保负责人二身份证号码")
    private String maintenanceManagerTwoIdNum;


    @ApiModelProperty(value = "紧急救援电话")
    private String emergencyCall;

    @ApiModelProperty(value = "24小时维保电话")
    private String maintenance24Tel;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "录入单位ID")
    private String inputUnitNo;

    @ApiModelProperty(value = "维保合同照片")
    private String maintenanceContract;

    @ApiModelProperty(value = "维保周期")
    private Integer maintenanceCycle;

    @ApiModelProperty(value = "大修周期")
    private Integer overhaulCycle;

    @ApiModelProperty(value = "设备数量")
    private Integer equNum;


    @ApiModelProperty(value = "创建人ID")
    private String createUserId;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date createDate;

    @TableField("instance_status")
    private String instanceStatus;

    @TableField("next_execute_ids")
    private String nextExecuteIds;

    @TableField("promoter")
    private String promoter;

    @TableField("status")
    private String status;

    private List<String> roleIds;

    @ApiModelProperty(value = "设备种类")
    private String equList;

    @ApiModelProperty(value = "设备类别")
    private String equCategory;

    @ApiModelProperty(value = "设备品种")
    private String equDefine;

    @ApiModelProperty(value = "申请日期")
    private String noticeDate;

    @ApiModelProperty(value = "设备代码")
    private String equCode;

    @ApiModelProperty(value = "工作流下一节点任务id")
    private String nextTaskId;

    @ApiModelProperty(value = "下一节点可执行人")
    private String nextExecuteUserIds;

    @ApiModelProperty(value = "使用单位统一信用代码-数据隔离使用")
    private String useUnitCodeFilter;

    @ApiModelProperty(value = "维保单位统一信用代码-数据隔离使用")
    private String maintenanceUnitCodeFilter;

    @ApiModelProperty(value = "接收机构统一信用代码-数据隔离使用")
    private String receiveOrgCodeFilter;

    @ApiModelProperty(value = "转办后执行人的Id逗号分割")
    private String transferToUserIds;

    @ApiModelProperty(value = "其他附件")
    private String otherAccessories;

    @ApiModelProperty(value = "当前登陆人单位类型")
    private String unitType;
}
