package com.yeejoin.amos.boot.module.jg.api.enums;

import com.yeejoin.amos.boot.module.jg.api.event.handler.SafetyProblemEventHandler;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

/**
 * 业务类型枚举
 *
 * @author Administrator
 */
@Getter
public enum SafetyProblemTypeEnum {

    /**
     * 问题主体类型
     */
    JYCQ("2", "检验超期", "设备检验超期", "safetyProblemTracing/jy/cq", "outOfInspectionRecords"),
    JYBJ("21", "检验报检", "设备报检", "safetyProblemTracing/jy/bj", null),
    WBCQ("1", "维保超期", "设备维保超期", "safetyProblemTracing/wb/cq", "outOfMaintenanceRecords"),
    WBBA("11", "维保备案", "设备维保备案", "safetyProblemTracing/wb/ba", null),
    ZZCQ("3", "资质超期", "企业资质超期", "safetyProblemTracing/zz/cq", null);

    private final String code;

    private final String name;

    private final String desc;

    private final String topic;

    /**
     * 消息对象属性
     * */
    private final String msgKey;

    SafetyProblemTypeEnum(String code, String name, String desc, String topic, String msgKey) {
        this.code = code;
        this.name = name;
        this.desc = desc;
        this.topic = topic;
        this.msgKey = msgKey;
    }

    public static String getNameByType(String code) {
        String name = null;
        for (SafetyProblemTypeEnum enumOne : SafetyProblemTypeEnum.values()) {
            if (enumOne.getCode().equals(code)) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }
}
