package com.yeejoin.amos.boot.module.jg.biz.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jg.api.entity.SafetyProblemTracing;
import com.yeejoin.amos.boot.module.jg.api.enums.SafetyProblemStatusEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.SafetyProblemTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.event.SafetyProblemEvent;
import com.yeejoin.amos.boot.module.jg.api.event.handler.SafetyProblemEventHandler;
import com.yeejoin.amos.boot.module.jg.biz.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgOtherInfoServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.SafetyProblemTracingServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.dto.ESEquipmentCategoryDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgOtherInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.Optional;

/**
 * WBCQEventHandler 类实现了 SafetyProblemEventHandler 接口，
 * 用于处理检验报检安全问题事件。
 */
@Component
public class JYBJEventHandler implements SafetyProblemEventHandler {

    SafetyProblemTracingServiceImpl safetyProblemTracingService;

    IdxBizJgOtherInfoServiceImpl idxBizJgOtherInfoService;

    ESEquipmentCategory esEquipmentCategory;

    @Autowired
    public JYBJEventHandler(SafetyProblemTracingServiceImpl safetyProblemTracingService, IdxBizJgOtherInfoServiceImpl idxBizJgOtherInfoService, ESEquipmentCategory esEquipmentCategory) {
        this.safetyProblemTracingService = safetyProblemTracingService;
        this.idxBizJgOtherInfoService = idxBizJgOtherInfoService;
        this.esEquipmentCategory = esEquipmentCategory;
    }


    /**
     * 处理安全问题事件。
     *
     * @param event 安全问题事件对象，包含事件的详细信息。
     *              该参数用于描述发生的安全问题事件。
     */
    @Override
    public void handle(SafetyProblemEvent event) {
        // 此处为处理安全问题事件的逻辑代码
        handleInspectionRecord(JSON.parseObject(event.getMessage().toString()));
    }

    private void handleInspectionRecord(JSONObject jsonObject) {
        String equipRecord = jsonObject.getString("record");
        if (!ValidationUtil.isEmpty(equipRecord)) {
            safetyProblemTracingService.lambdaUpdate()
                    .set(SafetyProblemTracing::getProblemStatusCode, SafetyProblemStatusEnum.HANDLED.getCode())
                    .set(SafetyProblemTracing::getProblemStatus, SafetyProblemStatusEnum.HANDLED.getName())
                    .eq(SafetyProblemTracing::getSourceId, equipRecord)
                    .eq(SafetyProblemTracing::getProblemTypeCode, SafetyProblemTypeEnum.JYCQ.getCode()).update();
            idxBizJgOtherInfoService.lambdaUpdate().set(IdxBizJgOtherInfo::getStatus, SafetyProblemStatusEnum.HANDLED.getCode())
                    .eq(IdxBizJgOtherInfo::getRecord, equipRecord).update();
            Optional<ESEquipmentCategoryDto> equipEsDto = esEquipmentCategory.findById(equipRecord);
            if (equipEsDto.isPresent()) {
                ESEquipmentCategoryDto equipDto = equipEsDto.get();
                equipDto.setProblemStatus(SafetyProblemStatusEnum.HANDLED.getCode());
                esEquipmentCategory.save(equipDto);
            }
        }
    }
}

