package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintenanceContract;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintenanceContractEq;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.CompanyTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.SafetyProblemTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.WorkFlowStatusEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgMaintenanceContractEqMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgMaintenanceContractMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgInstallationNoticeService;
import com.yeejoin.amos.boot.module.jg.api.service.IJgMaintenanceContractService;
import com.yeejoin.amos.boot.module.jg.api.vo.JgMaintenanceContractVo;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.biz.service.ICmWorkflowService;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgMaintenanceRecordInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowBatchDTO;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import io.seata.spring.annotation.GlobalTransactional;
import lombok.SneakyThrows;
import org.elasticsearch.client.RestHighLevelClient;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-12
 */
@Service
public class JgMaintenanceContractServiceImpl extends BaseService<JgMaintenanceContractDto, JgMaintenanceContract, JgMaintenanceContractMapper> implements IJgMaintenanceContractService {

    public static final String SUBMIT_DATA = "0";
    public static final String SUBMIT_TYPE_FLOW = "1";
    public static final String WB_PROCESS_DEFINITION_KEY = "maintenanceFiling";

    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    RestHighLevelClient restHighLevelClient;
    @Autowired
    RedisUtils redisUtils;
    @Autowired
    ICmWorkflowService workflowService;
    @Autowired
    CommonServiceImpl commonService;
    @Autowired
    IJgInstallationNoticeService jrmInstallationNoticeService;
    @Autowired
    EmqKeeper emqKeeper;
    @Autowired
    private JgMaintenanceContractMapper maintenanceContractMapper;
    @Autowired
    private JgMaintenanceContractEqMapper maintenanceContractEqMapper;
    @Autowired
    private JgMaintenanceContractEqServiceImpl jgMaintenanceContractEqService;
    @Autowired
    private IdxBizJgMaintenanceRecordInfoServiceImpl idxBizJgMaintenanceRecordInfoService;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private JgResumeInfoServiceImpl jgResumeInfoService;

    /**
     * 分页查询
     */
    public Page<JgMaintenanceContractVo> queryForPage(Page<JgMaintenanceContract> page, String sort, JgMaintenanceContractDto dto, ReginParams reginParams) {
        if (ObjectUtils.isEmpty(dto)) {
            dto = new JgMaintenanceContractDto();
        }
        Page<JgMaintenanceContractDto> contractList;
        Page<JgMaintenanceContractVo> result = new Page<>();
        CompanyBo company = reginParams.getCompany();
        SortVo sortMap = commonService.sortFieldConversion(sort);
        Map<String, Object> companyTypeMap = jrmInstallationNoticeService.getCompanyType();
        String companyLevel = "";
        String companyType = "";
        if (companyTypeMap.containsKey("companyLevel")) {
            companyLevel = companyTypeMap.get("companyLevel").toString();
        }
        if (companyTypeMap.containsKey("companyType")) {
            companyType = companyTypeMap.get("companyType").toString();
        }
        if ("supervision".equals(companyLevel)) {
            // 监管单位用"接收机构统一使用代码"匹配
            dto.setReceiveOrgCodeFilter(company.getCompanyCode());
        } else if ("company".equals(companyLevel)) {
            if (companyType.contains(CompanyTypeEnum.USE.getCode()) || companyType.contains(CompanyTypeEnum.INDIVIDUAL.getCode())) {
                // 使用单位用"使用单位统一信用代码"匹配数据
                dto.setUseUnitCodeFilter(company.getCompanyCode());
                dto.setRoleIds(null);
            }
            if (companyType.contains(CompanyTypeEnum.CONSTRUCTION.getCode())) {
                // 维保单位用"维保单位统一信用代码"匹配数据
                dto.setMaintenanceUnitCodeFilter(company.getCompanyCode());
            }
        }
        contractList = maintenanceContractMapper.getContractList(page, sortMap, dto, reginParams.getUserModel().getUserId());
        List<JgMaintenanceContractDto> records = contractList.getRecords().stream().peek(x -> x.setUnitType(company.getCompanyType())).collect(Collectors.toList());
        contractList.setRecords(records);
        BeanUtils.copyProperties(contractList, result);
        return result;
    }

    /**
     * 根据sequenceNbr查询数据
     */
    public JgMaintenanceContractVo queryBySequenceNbr(Long sequenceNbr) {
        JgMaintenanceContractDto dto = maintenanceContractMapper.queryBySequenceNbr(sequenceNbr);
        JgMaintenanceContractVo vo = new JgMaintenanceContractVo();
        BeanUtils.copyProperties(dto, vo);
        vo.setMaintenanceContract(ObjectUtils.isEmpty(dto.getMaintenanceContract()) ? null : JSON.parseArray(dto.getMaintenanceContract()));
        vo.setOtherAccessories(ObjectUtils.isEmpty(dto.getOtherAccessories()) ? null : JSON.parseArray(dto.getOtherAccessories()));
        // 非已完成状态数据显示最新的设备信息
        if (!FlowStatusEnum.TO_BE_FINISHED.getName().equals(dto.getStatus())) {
            List<Map<String, Object>> list = maintenanceContractMapper.selectEquipList(sequenceNbr);
            if (!ObjectUtils.isEmpty(list)) {
                vo.setEquipmentLists(list);
            }
        } else {
            // 完成的显示历史表的数据
            JSONArray objects = commonService.queryHistoryDataObj(dto.getSequenceNbr());
            // 兼容老数据
            if (objects.isEmpty()) {
                List<Map<String, Object>> list = maintenanceContractMapper.selectEquipList(sequenceNbr);
                if (!ObjectUtils.isEmpty(list)) {
                    vo.setEquipmentLists(list);
                }
            } else {
                List equList = objects.toJavaList(Map.class);
                vo.setEquipmentLists(equList);
            }
        }
        return vo;
    }

    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public void flowExecute(Long id, String instanceId, String operate, String comment, Boolean update, String nextTaskId) {
        String lockKey = CommonServiceImpl.buildJgExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 流程执行时，状态及权限校验
            commonService.checkForExecuteFlow(nextTaskId, instanceId);

            JgMaintenanceContract contract = this.getBaseMapper().selectById(id);
            String taskId = contract.getNextTaskId();
            // 组装信息
            TaskResultDTO dto = new TaskResultDTO();
            dto.setResultCode("approvalStatus");
            dto.setTaskId(taskId);
            dto.setComment(comment);
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", operate);
            if (WorkFlowStatusEnum.MAIN_SUBMIT.getReject().equals(contract.getStatus()) || WorkFlowStatusEnum.MAIN_SUBMIT.getRollBack().equals(contract.getStatus())) {
                map.put("approvalStatus", "提交");
            }
            dto.setVariable(map);
            // 下一节点执行人单位（下节点接收机构code）
            dto.setNextExecuteUserCompanyCode(getNextUserOrgCode(operate, contract));
            ProcessTaskDTO complete = workflowService.completeOrReject(taskId, dto, operate);
            // 更新下一步执行人、创建待办
            updateExecuteIds(instanceId, id, operate, complete);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    public InstanceRuntimeData buildInstanceRuntimeData(JgMaintenanceContract jgMaintenanceContract) {
        return InstanceRuntimeData.builder()
                .nextExecuteUserIds(jgMaintenanceContract.getNextExecuteUserIds())
                .promoter(jgMaintenanceContract.getPromoter())
                .nextTaskId(jgMaintenanceContract.getNextTaskId())
                .build();
    }

    public String getNextUserOrgCode(String operate, JgMaintenanceContract contract) {
        String code = null;
        if ("0".equals(operate)) {
            // 通过
            if (WorkFlowStatusEnum.MAIN_SUBMIT.getPass().equals(contract.getStatus()) || WorkFlowStatusEnum.MAIN_SUBMIT.getReject().equals(contract.getStatus()) || WorkFlowStatusEnum.MAIN_SUBMIT.getRollBack().equals(contract.getStatus())) {
                code = contract.getMaintenanceUnitCode();
            } else if (WorkFlowStatusEnum.MAIN_RECEIVE.getPass().equals(contract.getStatus()) || WorkFlowStatusEnum.MAIN_RECEIVE.getReject().equals(contract.getStatus()) || WorkFlowStatusEnum.MAIN_RECEIVE.getRollBack().equals(contract.getStatus())) {
                code = contract.getReceiveOrgCode();
            }
        } else {
            // 驳回
            if (WorkFlowStatusEnum.MAIN_PRELIMINARY.getPass().equals(contract.getStatus())) {
                code = contract.getMaintenanceUnitCode();
            }
        }
        return code == null ? contract.getUseUnitCode() : code;
    }

    /**
     * 批量删除
     */
    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public Boolean deleteForBatch(Long[] ids) {
        List<Long> list = Arrays.asList(ids);
        list.forEach(seq -> {
            JgMaintenanceContract jgMaintenanceContract = this.baseMapper.selectById(seq);
            commonService.deleteTaskModel(String.valueOf(jgMaintenanceContract.getSequenceNbr()),jgMaintenanceContract.getInstanceId());
            this.baseMapper.deleteById(seq);
        });
        return true;
    }

    private void executeOneStep(JgMaintenanceContract contract, String taskName, String nextUserIds, String operate) {
        // 先更新之前的待办
        TaskV2Model taskV2Model = updateTaskModel(contract, operate);
        taskV2Model.setTaskDesc("");
        taskV2Model.setTaskContent(this.buildTaskContent(contract));
        taskV2Model.setTaskName(taskName);
        taskV2Model.setTaskCode(contract.getApplyNo());
        taskV2Model.setExecuteUserIds(nextUserIds);
        taskV2Model.setRelationId(contract.getInstanceId());
        FlowStatusEnum flowStatusEnum = this.getTaskStatus(operate);
        taskV2Model.setTaskStatus(flowStatusEnum.getCode());
        taskV2Model.setTaskStatusLabel(flowStatusEnum.getName());
        taskV2Model.setFlowCode(contract.getNextTaskId());
        taskV2Model.setFlowStatus(this.getTaskStatusByName(contract.getStatus()));
        taskV2Model.setFlowStatusLabel(contract.getStatus());
        taskV2Model.setTaskType(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getCode());
        taskV2Model.setStartUser(contract.getCreateUserName());
        taskV2Model.setTaskTypeLabel(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getName());
        taskV2Model.setStartDate(contract.getCreateDate());
        taskV2Model.setStartUserId(contract.getCreateUserId());
        taskV2Model.setStartUserCompanyName(contract.getUseUnitName());
        taskV2Model.setExecuteUserIds(nextUserIds);
        TaskModelDto modelDto = new TaskModelDto();
        BeanUtil.copyProperties(taskV2Model, modelDto);
        modelDto.setNextExecuteUser(contract.getNextExecuteIds());
        TaskMessageDto taskMessageDto = new TaskMessageDto();
        BeanUtil.copyProperties(contract, taskMessageDto);
        modelDto.setModel(taskMessageDto);
        // 再插入新代办、数据待定
        commonService.buildTaskModel(Collections.singletonList(modelDto));
        // 新增人员履历消息表
        LambdaQueryWrapper<JgMaintenanceContractEq> lambda = new QueryWrapper<JgMaintenanceContractEq>().lambda();
        lambda.eq(JgMaintenanceContractEq::getEquipTransferId, contract.getSequenceNbr());
        List<JgMaintenanceContractEq> jgMaintenanceContractEqList = jgMaintenanceContractEqService.getBaseMapper().selectList(lambda);
        jgResumeInfoService.saveBatchResume(
                jgMaintenanceContractEqList.stream()
                        .map(v -> JgResumeInfoDto.builder()
                                .applyNo(contract.getApplyNo())
                                .businessType(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getName())
                                .businessId(String.valueOf(contract.getSequenceNbr()))
                                .equId(String.valueOf(v.getEquId()))
                                .approvalUnit(contract.getReceiveOrgName())
                                .approvalUnitCode(contract.getReceiveOrgCode())
                                .status("正常")
                                .routePath(taskV2Model.getRoutePath())
                                .build())
                        .collect(Collectors.toList())
        );
    }


    /**
     * 维保合同撤回
     */
    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public void revocation(String instanceId, String _nextTaskId) {
        String lockKey = CommonServiceImpl.buildJgExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 流程执行时，状态及权限校验
            commonService.checkForRevocationFlow(_nextTaskId, instanceId);

            LambdaQueryWrapper<JgMaintenanceContract> lambda = new QueryWrapper<JgMaintenanceContract>().lambda();
            lambda.eq(JgMaintenanceContract::getInstanceId, instanceId);
            List<String> roleListNext = new ArrayList<>();
            List<String> roleListAll = new ArrayList<>();
            JgMaintenanceContract contract = this.getOne(lambda);
            ProcessTaskDTO processTaskDTO = workflowService.rollBack(instanceId);
            String nextTaskId = processTaskDTO.getNextTask().get(0).getId();
            this.buildRoleList(Collections.singletonList(processTaskDTO), roleListNext, roleListAll);
            // 待调整
            String taskCode = processTaskDTO.getNextTask().get(0).getKey();
            if (!FlowStatusEnum.TO_BE_FINISHED.getName().equals(taskCode)) {
                contract.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getRollBack());
            }
            contract.setPromoter(RequestContext.getExeUserId());
            contract.setNextExecuteIds(String.join(",", roleListNext));
            contract.setNextTaskId(nextTaskId);
            List<WorkflowResultDto> workflowResultDtos = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));
            // 更新下一步可执行人
            String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
            contract.setNextExecuteUserIds(nextUserIds);
            this.updateById(contract);
            // 删除待办
            JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(contract));
            jsonObject.put("nextTaskId", contract.getNextTaskId());
            jsonObject.put("nextExecuteUser", contract.getNextExecuteIds());
            jsonObject.put("taskType", BusinessTypeEnum.JG_MAINTENANCE_RECORD.getCode());
            jsonObject.put("flowStatus", this.getTaskCodeByName(contract.getStatus()));
            jsonObject.put("flowStatusLabel", contract.getStatus());
            jsonObject.put("maintenanceContract", null);// 不传合同照片附件信息
            commonService.rollbackTask(instanceId, jsonObject);

            // redis流程实时数据更新
            commonService.saveExecuteFlowData2Redis(instanceId, this.buildInstanceRuntimeData(contract));
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    /**
     * 新增维保合同
     */
    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public List<JgMaintenanceContract> saveOrSubmit(String submit, Map<String, Object> map, ReginParams reginParams) {
        JgMaintenanceContractDto contractDto = JSON.parseObject(JSON.toJSONString(map), JgMaintenanceContractDto.class);
        List<Map<String, Object>> equipmentLists = (List<Map<String, Object>>) map.get("equipmentLists");
        if (CollectionUtils.isEmpty(equipmentLists)) {
            throw new BadRequest("请选择设备");
        }
        CompanyBo company = reginParams.getCompany();
        contractDto.setCreateDate(new Date());
        contractDto.setPromoter(reginParams.getUserModel().getUserId());
        // 获取维保备案编号
        ResponseModel<List<String>> listResponseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.WBBA.getCode(), 1);
        if (!ObjectUtils.isEmpty(listResponseModel) && listResponseModel.getStatus() != HttpStatus.OK.value()) {
            log.error("告知单获取失败");
            throw new BadRequest("告知单获取失败");
        }
        String wbApplyNo = listResponseModel.getResult().get(0);
        contractDto.setApplyNo(wbApplyNo);
        contractDto.setUseUnitCode(company.getCompanyCode());
        contractDto.setUseUnitName(company.getCompanyName());
        // 管理员信息
        if (!StringUtils.isEmpty(contractDto.getMaintenanceManagerId())) {
            String[] MaintenanceManager = contractDto.getMaintenanceManagerId().split("_");
            contractDto.setMaintenanceManagerId(MaintenanceManager[0]);
            contractDto.setMaintenanceManagerName(MaintenanceManager[1]);
        }
        // 接收机构信息
        if (!StringUtils.isEmpty(contractDto.getReceiveOrgCode())) {
            String[] splitReceiveOrgCode = contractDto.getReceiveOrgCode().split("_");
            contractDto.setReceiveOrgCode(splitReceiveOrgCode[0]);
            contractDto.setReceiveOrgName(splitReceiveOrgCode[1]);
        }
        // 维保单位信息
        if (!StringUtils.isEmpty(contractDto.getMaintenanceUnitCode())) {
            String[] splitMaintenanceUnitCode = contractDto.getMaintenanceUnitCode().split("_");
            contractDto.setMaintenanceUnitCode(splitMaintenanceUnitCode[0]);
            contractDto.setMaintenanceUnitName(splitMaintenanceUnitCode[1]);
        }
        contractDto.setStatus(FlowStatusEnum.TO_BE_SUBMITTED.getName());
        JgMaintenanceContract contract = new JgMaintenanceContract();
        // 没有id说明是新增
        boolean isNoId = StringUtils.isEmpty(contractDto.getSequenceNbr());
        BeanUtils.copyProperties(contractDto, contract);
        contract.setCreateUserId(reginParams.getUserModel().getUserId());
        contract.setCreateUserName(reginParams.getUserModel().getRealName());
        CompanyBo companyBo = commonService.getOneCompany(contract.getReceiveOrgCode());
        contract.setReceiveCompanyOrgCode(companyBo.getOrgCode());
        if (isNoId) {
            contract.setStatus(SUBMIT_DATA.equals(submit) ? WorkFlowStatusEnum.MAIN_SUBMIT.getPass() : WorkFlowStatusEnum.MAIN_RECEIVE.getPass());
            this.save(contract);
        } else {
            // 删除以前设备关联关系
            this.getBaseMapper().updateById(contract);
            LambdaQueryWrapper<JgMaintenanceContractEq> lambda = new QueryWrapper<JgMaintenanceContractEq>().lambda();
            lambda.eq(JgMaintenanceContractEq::getEquipTransferId, contract.getSequenceNbr());
            jgMaintenanceContractEqService.getBaseMapper().delete(lambda);
        }
        // 更新关联设备信息
        if (!CollectionUtils.isEmpty(equipmentLists)) {
            contract.setEquNum(equipmentLists.size());
            List<JgMaintenanceContractEq> equipList = new ArrayList<>();
            equipmentLists.forEach(x -> {
                JgMaintenanceContractEq equip = new JgMaintenanceContractEq();
                equip.setEquId(String.valueOf(x.get("SEQUENCE_NBR")));
                equip.setEquipTransferId(contract.getSequenceNbr().toString());
                equipList.add(equip);
            });
            // 保存关联设备信息
            jgMaintenanceContractEqService.saveBatch(equipList);
        }

        // 判断当前是否为提交
        if (SUBMIT_TYPE_FLOW.equals(submit)) {
            List<String> roleListNext = new ArrayList<>();
            List<String> roleListAll = new ArrayList<>();
            // 新增提交
            if (StringUtils.isEmpty(contract.getInstanceId())) {
                // 没有InstanceId需要发起流程
                ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
                List<ActWorkflowStartDTO> list = new ArrayList<>();
                ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                dto.setProcessDefinitionKey(WB_PROCESS_DEFINITION_KEY);
                dto.setBusinessKey(contract.getApplyNo());
                dto.setCompleteFirstTask(true);
                // 下一节点执行人单位（下节点接收机构code）
                dto.setNextExecuteUserCompanyCode(contract.getMaintenanceUnitCode());
                list.add(dto);
                actWorkflowBatchDTO.setProcess(list);
                List<ProcessTaskDTO> processTasks = workflowService.startBatch(actWorkflowBatchDTO);
                String instanceId = processTasks.get(0).getProcessInstance().getId();
                String nextTaskId = processTasks.get(0).getNextTask().get(0).getId();
                String taskName = processTasks.get(0).getNextTask().get(0).getName();
                this.buildRoleList(processTasks, roleListNext, roleListAll);
                List<WorkflowResultDto> workflowResultDtos = commonService.buildWorkFlowInfo(processTasks);
                String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
                contract.setInstanceStatus(String.join(",", roleListAll));
                contract.setInstanceId(instanceId);
                contract.setNextExecuteIds(String.join(",", roleListNext));
                contract.setNextTaskId(nextTaskId);
                contract.setStatus(String.valueOf(WorkFlowStatusEnum.MAIN_RECEIVE.getPass()));
                contract.setNextExecuteUserIds(nextUserIds);
                commonService.deleteTasksByRelationId(contract.getSequenceNbr() + "");
                // 创建待办
                JgMaintenanceContract bean = new JgMaintenanceContract();
                BeanUtil.copyProperties(contract, bean);
                createTaskModel(bean, taskName, "1", nextUserIds);
            } else {
                String lockKey = CommonServiceImpl.buildJgExecuteLockKey(contract.getInstanceId());
                RLock lock = redissonClient.getLock(lockKey);
                try {
                    boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
                    // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
                    if (!isLocked) {
                        throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
                    }
                    // 流程执行时，状态及权限校验
                    commonService.checkForExecuteFlow(String.valueOf(map.get("nextTaskId")), contract.getInstanceId());

                    // 有InstanceId，执行一步
                    ProcessTaskDTO processTaskDTO = this.submit("0", contract);
                    String nextTaskId = processTaskDTO.getNextTask().get(0).getId();
                    String taskName = processTaskDTO.getNextTask().get(0).getName();
                    this.buildRoleList(Collections.singletonList(processTaskDTO), roleListNext, roleListAll);
                    List<WorkflowResultDto> workflowResultDtos = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));
                    String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
                    // 查询下节点任务
                    if (!ObjectUtils.isEmpty(contract.getInstanceStatus())) {
                        contract.setInstanceStatus(contract.getInstanceStatus() + "," + String.join("", roleListNext));
                    } else {
                        contract.setInstanceStatus(String.join(",", roleListAll));
                    }
                    contract.setPromoter(RequestContext.getExeUserId());
                    contract.setNextExecuteIds(String.join(",", roleListNext));
                    contract.setStatus(String.valueOf(WorkFlowStatusEnum.MAIN_RECEIVE.getPass()));
                    contract.setNextTaskId(nextTaskId);
                    contract.setNextExecuteUserIds(nextUserIds);
                    commonService.deleteTasksByRelationId(contract.getSequenceNbr() + "");
                    executeOneStep(contract, taskName, nextUserIds, "0");

                    // redis流程实时数据更新
                    commonService.saveExecuteFlowData2Redis(contract.getInstanceId(), this.buildInstanceRuntimeData(contract));
                } catch (InterruptedException e) {
                    e.printStackTrace();
                } finally {
                    if (lock.isHeldByCurrentThread()) {
                        lock.unlock();
                    }
                }
            }
        } else {
            List<TaskModelDto> modelDtos = new ArrayList<>();
            TaskModelDto dto = new TaskModelDto();
            dto.setModel(contract);
            dto.setTaskContent(buildTaskContent(contract));
            dto.setTaskCode(contract.getApplyNo());
            dto.setTaskType(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getCode());
            dto.setRelationId(contract.getSequenceNbr() + "");
            modelDtos.add(dto);
            commonService.buildTaskModel(modelDtos);
        }
        updateById(contract);
        // 设备数据存历史数据，在流程完成时使用
        commonService.saveOrUpdateHistory(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getName(), JSON.parseArray(JSON.toJSONString(equipmentLists)), null, contract.getSequenceNbr().toString());
        return Collections.singletonList(contract);
    }

    public ProcessTaskDTO submit(String op, JgMaintenanceContract contract) {
        // 组装信息
        TaskResultDTO dto = new TaskResultDTO();
        dto.setResultCode("approvalStatus");
        dto.setTaskId(contract.getNextTaskId());
        dto.setComment("提交流程");
        // 下一节点执行人单位（下节点接收机构code）
        dto.setNextExecuteUserCompanyCode(contract.getMaintenanceUnitCode());
        HashMap<String, Object> map = new HashMap<>();
        map.put("approvalStatus", op);
        dto.setVariable(map);
        return workflowService.completeOrReject(contract.getNextTaskId(), dto, op);
    }

    private void buildRoleList(List<ProcessTaskDTO> processTasks, List<String> roleListNext, List<String> roleListAll) {
        processTasks.forEach(p -> {
            p.getNextCandidateGroups().values().forEach(e -> {
                roleListNext.addAll(e);
                roleListAll.addAll(e);
            });
            roleListAll.addAll(p.getCandidateGroups());
        });
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateExecuteIds(String instanceId, Long sequenceNbr, String operate, ProcessTaskDTO processTaskDTO) {
        List<String> roleListNext = new ArrayList<>();
        List<String> roleListAll = new ArrayList<>();
        String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
        String taskName = "";
        String nextTaskId = "";
        JgMaintenanceContract contract = this.getBaseMapper().selectById(sequenceNbr);
        if (processTaskDTO != null && processTaskDTO.getNextTask() != null && processTaskDTO.getNextTask().size() > 0) {
            taskCode = processTaskDTO.getNextTask().get(0).getKey();
            taskName = processTaskDTO.getNextTask().get(0).getName();
            nextTaskId = processTaskDTO.getNextTask().get(0).getId();
        }
        if (!FlowStatusEnum.TO_BE_FINISHED.getName().equals(taskCode)) {
            this.buildRoleList(Collections.singletonList(processTaskDTO), roleListNext, roleListAll);
            List<WorkflowResultDto> workflowResultDtos = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));
            String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
            contract.setNextExecuteIds(String.join(",", roleListNext));
            contract.setPromoter(RequestContext.getExeUserId());
            contract.setInstanceId(instanceId);
            contract.setNextTaskId(nextTaskId);
            // 更新下一步可执行人
            contract.setNextExecuteUserIds(nextUserIds);
            if (!ObjectUtils.isEmpty(contract.getInstanceStatus())) {
                contract.setInstanceStatus(contract.getInstanceStatus() + "," + String.join(",", roleListNext));
            } else {
                contract.setInstanceStatus(String.join(",", roleListNext));
            }
            if ("0".equals(operate)) {
                // 通过操作
                contract.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getPass());
            } else {
                // 驳回操作
                contract.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getReject());
                contract.setPromoter(null);
            }
            executeOneStep(contract, taskName, nextUserIds, operate);
        } else {
            // 完成时 下一步骤可执行人清空
            contract.setNextExecuteUserIds("");
            contract.setApplyDate(new Date());
            contract.setStatus(taskCode);
            contract.setNextTaskId(null);
            updateTaskModel(contract, "0");
            // 添加设备维保信息
            updateEquipMessage(contract.getSequenceNbr());
        }
        this.getBaseMapper().updateById(contract);

        // redis流程实时数据更新
        commonService.saveExecuteFlowData2Redis(instanceId, this.buildInstanceRuntimeData(contract));
    }

    /**
     * 流程结束后添加设备维保信息
     *
     * @param id
     */
    @SneakyThrows
    private void updateEquipMessage(Long id) {
        JgMaintenanceContract jgMaintenanceContract = this.getBaseMapper().selectById(id);
        LambdaQueryWrapper<JgMaintenanceContractEq> lambda = new QueryWrapper<JgMaintenanceContractEq>().lambda();
        lambda.eq(JgMaintenanceContractEq::getEquipTransferId, id);
        List<JgMaintenanceContractEq> list = jgMaintenanceContractEqService.getBaseMapper().selectList(lambda);
        ArrayList<IdxBizJgMaintenanceRecordInfo> data = new ArrayList<>();
        // 循环设备
        list.forEach(item -> {
            IdxBizJgMaintenanceRecordInfo info = idxBizJgMaintenanceRecordInfoService.queryNewestDetailByRecord(item.getEquId());
            if (!ObjectUtils.isEmpty(info)) {
                info.setMeUnitName(ObjectUtils.isEmpty(jgMaintenanceContract.getMaintenanceUnitName()) ? null : jgMaintenanceContract.getMaintenanceUnitName());
                info.setMeUnitCreditCode(ObjectUtils.isEmpty(jgMaintenanceContract.getMaintenanceUnitCode()) ? null : jgMaintenanceContract.getMaintenanceUnitCode());
                info.setMeMaster(ObjectUtils.isEmpty(jgMaintenanceContract.getMaintenanceManagerOneName()) ? null : jgMaintenanceContract.getMaintenanceManagerOneName());
                info.setMeMasterPhone(ObjectUtils.isEmpty(jgMaintenanceContract.getMaintenanceManagerOnePhone()) ? null : jgMaintenanceContract.getMaintenanceManagerOnePhone());
                info.setMeMasterId(ObjectUtils.isEmpty(jgMaintenanceContract.getMaintenanceManagerOneIdNum()) ? null : jgMaintenanceContract.getMaintenanceManagerOneIdNum());
                info.setMeMaster1(ObjectUtils.isEmpty(jgMaintenanceContract.getMaintenanceManagerTwoName()) ? null : jgMaintenanceContract.getMaintenanceManagerTwoName());
                info.setMeMaster1Phone(ObjectUtils.isEmpty(jgMaintenanceContract.getMaintenanceManagerTwoPhone()) ? null : jgMaintenanceContract.getMaintenanceManagerTwoPhone());
                info.setMeMaster1Id(ObjectUtils.isEmpty(jgMaintenanceContract.getMaintenanceManagerTwoIdNum()) ? null : jgMaintenanceContract.getMaintenanceManagerTwoIdNum());
                info.setInformStart(ObjectUtils.isEmpty(jgMaintenanceContract.getInformStart()) ? null : jgMaintenanceContract.getInformStart());
                info.setInformEnd(ObjectUtils.isEmpty(jgMaintenanceContract.getInformEnd()) ? null : jgMaintenanceContract.getInformEnd());
                info.setRepairInform(ObjectUtils.isEmpty(jgMaintenanceContract.getMaintenanceContract()) ? null : jgMaintenanceContract.getMaintenanceContract());
                data.add(info);
            }
        });
        idxBizJgMaintenanceRecordInfoService.updateBatchById(data);
        emqKeeper.getMqttClient().publish(SafetyProblemTypeEnum.WBBA.getTopic(), JSON.toJSONBytes(data), 2, false);
    }


    private TaskV2Model updateTaskModel(JgMaintenanceContract contract, String operate) {
        Map<String, Object> params = new HashMap<>();
        FlowStatusEnum flowStatusEnum = this.getTaskStatus(operate);
        params.put("relationId", contract.getInstanceId());
        params.put("taskStatus", flowStatusEnum.getCode());
        params.put("taskStatusLabel", flowStatusEnum.getName());
        params.put("flowStatus", this.getTaskStatusByName(contract.getStatus()));
        params.put("flowStatusLabel", contract.getStatus());
        params.put("model", contract);
        return commonService.updateTaskModelNew(params);
    }

    private FlowStatusEnum getTaskStatus(String operate) {
        if ("0".equals(operate)) {
            return FlowStatusEnum.TO_BE_FINISHED;
        } else {
            return FlowStatusEnum.REJECTED;
        }
    }

    private Integer getTaskStatusByName(String auditStatus) {
        return commonService.getDictionaryCodeByName(auditStatus);
    }

    private void createTaskModel(JgMaintenanceContract contract, String taskName, String submitType, String nextUserIds) {
        if ("1".equals(submitType)) {
            TaskModelDto taskModelDto = new TaskModelDto();
            taskModelDto.setFlowCreateDate(contract.getApplyDate());
            taskModelDto.setTaskName(taskName);
            taskModelDto.setTaskCode(contract.getApplyNo());
            taskModelDto.setTaskContent(this.buildTaskContent(contract));
            taskModelDto.setTaskDesc("");
            taskModelDto.setTaskType(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getCode());
            taskModelDto.setTaskTypeLabel(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getName());
            taskModelDto.setRelationId(contract.getInstanceId());
            taskModelDto.setExecuteUserIds(nextUserIds);
            FlowStatusEnum flowStatusEnum = this.getTaskStatus(submitType);
            taskModelDto.setTaskStatus(flowStatusEnum.getCode());
            taskModelDto.setTaskStatusLabel(flowStatusEnum.getName());
            taskModelDto.setFlowStatus(this.getTaskStatusByName(contract.getStatus()));
            taskModelDto.setFlowStatusLabel(contract.getStatus());
            taskModelDto.setStartUserId(contract.getCreateUserId());
            taskModelDto.setStartUser(contract.getCreateUserName());
            taskModelDto.setFlowCode(contract.getNextTaskId());
            taskModelDto.setStartUserCompanyName(contract.getUseUnitName());
            taskModelDto.setNextExecuteUser(contract.getNextExecuteIds());
            taskModelDto.setStartDate(contract.getCreateDate());
            TaskMessageDto taskMessageDto = new TaskMessageDto();
            BeanUtil.copyProperties(contract, taskMessageDto);
            taskModelDto.setModel(taskMessageDto);
            commonService.buildTaskModel(Collections.singletonList(taskModelDto));

            // redis流程实时数据更新
            commonService.saveExecuteFlowData2Redis(contract.getInstanceId(), this.buildInstanceRuntimeData(contract));
        }
    }

    private Integer getTaskCodeByName(String auditStatus) {
        return commonService.getDictionaryCodeByName(auditStatus);
    }

    /**
     * 摘要构建
     *
     * @param dto 业务
     * @return 摘要
     */
    private String buildTaskContent(JgMaintenanceContract dto) {
        List<Map<String, Object>> list = maintenanceContractMapper.selectEquipList(dto.getSequenceNbr());
        String supervisoryCode = "";
        String equList = "";
        if (!CollectionUtils.isEmpty(list)) {
            Map<String, Object> map = list.get(0);
            if (map.containsKey("EQU_LIST")) {
                equList = map.get("EQU_LIST").toString();
            }
            if (map.containsKey("SUPERVISORY_CODE")) {
                supervisoryCode = map.get("SUPERVISORY_CODE").toString();
            }
        }
        supervisoryCode = StringUtils.isEmpty(supervisoryCode) ? "无" : supervisoryCode;
        String format = String.format("来自%s【%s】等的业务办理", equList, supervisoryCode);
        return format;
    }
}