package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapBuilder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Sequence;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.api.entity.JgRegistrationHistory;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistration;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistrationEq;
import com.yeejoin.amos.boot.module.jg.api.enums.*;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationEqMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgUseRegistrationService;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jg.biz.config.LocalBadRequest;
import com.yeejoin.amos.boot.module.jg.biz.context.EquipUsedCheckStrategyContext;
import com.yeejoin.amos.boot.module.jg.biz.context.FlowingEquipRedisContext;
import com.yeejoin.amos.boot.module.jg.biz.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.biz.service.ICommonService;
import com.yeejoin.amos.boot.module.jg.biz.utils.CodeUtil;
import com.yeejoin.amos.boot.module.jg.flc.api.fegin.WorkFlowFeignService;
import com.yeejoin.amos.boot.module.ymt.api.common.StringUtil;
import com.yeejoin.amos.boot.module.ymt.api.dto.ESEquipmentCategoryDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.*;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquCodeTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquimentEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowBatchDTO;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import io.seata.spring.annotation.GlobalTransactional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import static java.util.stream.Collectors.toList;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-12
 */
@Service
@Slf4j
public class JgUseRegistrationServiceImpl extends BaseService<JgUseRegistrationDto, JgUseRegistration, JgUseRegistrationMapper> implements IJgUseRegistrationService {

    private static final String DEFINITION_KEY = "useRegistration";
    private final List<String> NOT_FLOWING_STATE = Arrays.asList("使用单位待提交", "一级受理已驳回", "使用单位已撤回", "已作废");
    @Autowired
    WorkFlowFeignService workFlowFeginService;
    @Autowired
    RedisUtils redisUtils;
    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    JgRegistrationHistoryServiceImpl jgRegistrationHistoryService;
    @Autowired
    IdxBizJgRegisterInfoMapper idxBizJgRegisterInfoMapper;
    @Autowired
    TzsUserInfoMapper userInfoMapper;
    @Autowired
    ICommonService commonService;
    @Autowired
    CommonServiceImpl commonServiceImpl;
    @Autowired
    CmWorkflowServiceImpl cmWorkflowService;
    @Autowired
    IdxBizJgSupervisionInfoMapper idxBizJgSupervisionInfoMapper;
    @Autowired
    EquipTechParamPipelineMapper equipTechParamPipelineMapper;
    @Autowired
    DataDictionaryServiceImpl iDataDictionaryService;
    String[] jsonFields = {"productPhoto", "factoryStandard", "productQualityYieldProve", "insUseMaintainExplain",
            "inspectReport", "designStandard", "designDoc", "longitudeLatitude", "otherAccessoriesDes", "otherAccessoriesFact",
            "otherAccessoriesReg", "installProxyStatementAttachment", "installContractAttachment", "insOtherAccessories",
            "maintenanceContract", "maintOtherAccessories", "installProxyStatementAttachment", "installContractAttachment",
            "insOtherAccessories", "maintenanceContract", "factSupervisionInspectionReport", "boilerEnergyEfficiencyCertificate"};
    @Autowired
    CodeUtil codeUtil;
    @Autowired
    private IdxBizJgUseInfoMapper useInfoMapper;
    @Autowired
    private InspectionDetectionInfoMapper inspectionDetectionInfoMapper;
    @Autowired
    private IdxBizJgOtherInfoMapper otherInfoMapper;
    @Autowired
    private JgUseRegistrationEqMapper jgRelationEquipMapper;
    @Autowired
    private ProduceInfoMapper produceInfoMapper;
    @Autowired
    private IdxBizJgRegisterInfoServiceImpl idxBizJgRegisterInfoService;
    @Autowired
    private IdxBizJgUseInfoServiceImpl idxBizJgUseInfoService;
    @Autowired
    private IdxBizJgFactoryInfoServiceImpl idxBizJgFactoryInfoService;
    @Autowired
    private IdxBizJgMaintenanceRecordInfoServiceImpl idxBizJgMaintenanceRecordInfoService;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private Sequence sequence;
    @Autowired
    private JgUseRegistrationEqServiceImpl jgUseRegistrationEqService;
    @Autowired
    private IdxBizJgInspectionDetectionInfoServiceImpl idxBizJgInspectionDetectionInfoService;
    @Autowired
    private JgUseRegistrationMapper jgUseRegistrationMapper;
    @Autowired
    private ConstructionInfoMapper constructionInfoMapper;
    @Autowired
    private ESEquipmentCategory esEquipmentCategory;
    @Autowired
    private JgResumeInfoServiceImpl jgResumeInfoService;

    /**
     * @param auditPassDate   通过时间
     * @param exportParamsMap 参数map
     */
    static void getAuditPassedDate(Date auditPassDate, Map<String, Object> exportParamsMap) {
        LocalDate today;
        if (ValidationUtil.isEmpty(auditPassDate)) {
            // 发证日期为空取当前时间
            today = LocalDate.now();
        } else {
            today = auditPassDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        exportParamsMap.put("giveOutYear", today.getYear());
        exportParamsMap.put("giveOutMonth", today.getMonthValue());
        exportParamsMap.put("giveOutDay", today.getDayOfMonth());
    }

    private static void toZipFile(HttpServletResponse response, List<CompletableFuture<byte[]>> futures, String filePrefix, String customFileName) {
        // 打包zip
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
             ZipOutputStream zip = new ZipOutputStream(outputStream)) {

            for (int i = 0; i < futures.size(); i++) {
                try {
                    zip.putNextEntry(new ZipEntry(filePrefix + "第" + (i + 1) + "页" + ".pdf"));
                    IOUtils.write(futures.get(i).join(), zip);
                    zip.closeEntry(); // 每个条目结束后关闭
                } catch (IOException e) {
                    log.error("打包zip失败：" + e.getMessage());
                    throw new BadRequest("打包zip失败");
                }
            }
            // 所有条目写入完成后关闭 ZipOutputStream
            zip.finish();
            // 设置响应头并将压缩文件写入 HttpServletResponse
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/zip");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(customFileName, "UTF-8"));
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            IOUtils.write(outputStream.toByteArray(), response.getOutputStream());
        } catch (IOException e) {
            throw new RuntimeException("导出异常：", e);
        }
    }


    public Page<Map<String, Object>> getList(JgUseRegistrationDto dto, String sort, Page<Map<String, Object>> page, List<String> roleIds) {
        SortVo sortMap = commonServiceImpl.sortFieldConversion(sort);
        return this.baseMapper.getListPage(page, sortMap, dto, roleIds);
    }

    public Page<Map<String, Object>> getEquipList(Page<Map<String, Object>> page, String factoryNum, String equList, String equCategory) {
        return this.baseMapper.getEquipListPage(page, factoryNum, equList, equCategory);
    }

    public void updateEquipMessage(String currentDocumentId, JgUseRegistration jgUseRegistration, JSONObject map, IdxBizJgRegisterInfo registerInfo, IdxBizJgOtherInfo otherInfo) {
        String useOrgCode = jgUseRegistration.getUseRegistrationCode();
        // 市
        List<LinkedHashMap> city = (List<LinkedHashMap>) redisUtils.get("CITY");
        // 区
        List<LinkedHashMap> region = (List<LinkedHashMap>) redisUtils.get("REGION");
        // 街道
        List<LinkedHashMap> street = (List<LinkedHashMap>) redisUtils.get("STREET");

        map.remove("status");
        map.remove("instanceId");
        // 安全管理员
        if (map.containsKey("safetyManagerName")) {
            map.put("safetyManager", map.get("safetyManagerName"));
            map.put("safetyManagerId", map.get("safetyManagerId"));
        }

        IdxBizJgUseInfo useInfo = new IdxBizJgUseInfo();
        BeanUtil.copyProperties(map, useInfo);
        if (map.containsKey("isXixian")) {
            useInfo.setIsNotXiXian(map.get("isXixian").toString());
        }
        // 城市
        if (!ObjectUtils.isEmpty(map.get("city")) && !ObjectUtils.isEmpty(city)) {
            city.forEach(item -> {
                if (String.valueOf(item.get("regionCode")).equals(String.valueOf(map.get("city")))) {
                    useInfo.setCityName(String.valueOf(item.get("regionName")));
                }
            });
        }
        // 区县
        if (!ObjectUtils.isEmpty(map.get("county")) && !ObjectUtils.isEmpty(city)) {
            region.forEach(item -> {
                if (String.valueOf(item.get("regionCode")).equals(String.valueOf(map.get("county")))) {
                    useInfo.setCountyName(String.valueOf(item.get("regionName")));
                }
            });
        }
        // 街道
        if (!ObjectUtils.isEmpty(map.get("factoryUseSiteStreet")) && !ObjectUtils.isEmpty(city)) {
            street.forEach(item -> {
                if (String.valueOf(item.get("regionCode")).equals(String.valueOf(map.get("factoryUseSiteStreet")))) {
                    useInfo.setStreetName(String.valueOf(item.get("regionName")));
                }
            });
        }
        useInfo.setProvince("610000");
        useInfo.setProvinceName("陕西省");
        LambdaQueryWrapper<IdxBizJgUseInfo> lambda = new QueryWrapper<IdxBizJgUseInfo>().lambda();
        lambda.eq(IdxBizJgUseInfo::getRecord, map.get("equipId"));
        // 产权单位信息
        if (map.containsKey("estateUnitName")) {
            String[] data = String.valueOf(map.getString("estateUnitName")).split("_");
            useInfo.setEstateUnitCreditCode(data[0]);
            useInfo.setEstateUnitName(data[1]);
        }
        // 修改设备使用状态为在用
        useInfo.setEquState(String.valueOf(EquimentEnum.ZAIYONG.getCode()));
        // 更新使用信息
        useInfoMapper.update(useInfo, lambda);
        // 更新检验检测信息
        this.updateOrCreateInspectionDetection(map);
        // 更新注册登记信息表
        LambdaUpdateWrapper<IdxBizJgRegisterInfo> IdxBizJgRegLambda = new UpdateWrapper<IdxBizJgRegisterInfo>().lambda();
        IdxBizJgRegLambda.eq(IdxBizJgRegisterInfo::getRecord, map.get("equipId")).set(IdxBizJgRegisterInfo::getRegisterState, this.getRegCode());
        idxBizJgRegisterInfoService.update(IdxBizJgRegLambda);
        // 更新设备监管部门
        IdxBizJgSupervisionInfo idxBizJgSupervisionInfo = new IdxBizJgSupervisionInfo();
        if (map.containsKey("orgBranchCode") && !ObjectUtils.isEmpty(map.get("orgBranchCode"))) {
            String[] data = String.valueOf(map.getString("orgBranchCode")).split("_");

            HashMap<String, Object> parentMessage = (HashMap<String, Object>) Privilege.companyClient.queryByOrgcode(data[0]).getResult();
            // 目前平台返回key为compnay(存在拼写错误)
            CompanyModel parentModel = JSON.parseObject(JSON.toJSONString(parentMessage.get("compnay")), CompanyModel.class);

            idxBizJgSupervisionInfo.setOrgBranchCode(data[0]);
            idxBizJgSupervisionInfo.setOrgBranchName(data[1]);
            idxBizJgSupervisionInfo.setCompanyOrgBranchCode(parentModel.getCompanyCode());
            LambdaQueryWrapper<IdxBizJgSupervisionInfo> eq = new QueryWrapper<IdxBizJgSupervisionInfo>().lambda().eq(IdxBizJgSupervisionInfo::getRecord, map.get("equipId"));
            idxBizJgSupervisionInfoMapper.update(idxBizJgSupervisionInfo, eq);
        }
        // 更新设备使用登记证
        idxBizJgRegisterInfoMapper.updateUseOrgCodeByEquip(String.valueOf(map.get("equipId")), useOrgCode);
        // 生成监管码、96333码
        createCode(map, jgUseRegistration, registerInfo, useInfo, otherInfo);
    }

    private void updateOrCreateInspectionDetection(JSONObject map) {
        InspectionDetectionInfo inspectionDetectionInfo = new InspectionDetectionInfo();
        BeanUtil.copyProperties(map, inspectionDetectionInfo);

        if (map.get("jySeq") != null) {
            // 更新逻辑
            InspectionDetectionInfo inspectionDetectionInfoDb = inspectionDetectionInfoMapper.selectById(map.get("jySeq").toString());
            Bean.copyExistPropertis(inspectionDetectionInfo, inspectionDetectionInfoDb);
            inspectionDetectionInfoMapper.updateById(inspectionDetectionInfo);
        } else {
            // 插入逻辑
            if (inspectionDetectionInfo.getInspectType() != null && inspectionDetectionInfo.getInspectConclusion() != null) {
                inspectionDetectionInfo.setRecord(map.get("equipId").toString());
                inspectionDetectionInfo.setRecDate(new Date());
                inspectionDetectionInfo.setSequenceNbr(sequence.nextId() + "");
                inspectionDetectionInfoMapper.insert(inspectionDetectionInfo);
            }
        }
    }

    /**
     * 获取类型为ZC的“已注册”的字典值
     *
     * @return code
     */
    private String getRegCode() {
        QueryWrapper<DataDictionary> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("type", "ZC");
        queryWrapper.eq("name", "已注册");
        queryWrapper.eq("is_delete", false);
        List<DataDictionary> list = iDataDictionaryService.list(queryWrapper);
        if (!list.isEmpty() && list.get(0) != null) {
            DataDictionary dictionary = list.get(0);
            return Optional.ofNullable(dictionary).map(DataDictionary::getCode).orElse("");
        }
        return "";
    }

    public void updateHistory(JSONObject map, String equipId, String currentDocumentId, String supervisoryCode) {
        JgRegistrationHistory jgRegistrationHistory = new JgRegistrationHistory();
        LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
        // lambda.eq(JgRegistrationHistory::getEquId, equipId);
        lambda.eq(JgRegistrationHistory::getCurrentDocumentId, currentDocumentId);
        lambda.eq(JgRegistrationHistory::getRegistrationClass, "使用登记");
        Integer integer = jgRegistrationHistoryService.getBaseMapper().selectCount(lambda);
        if (integer > 0) {
            jgRegistrationHistory.setChangeData(JSON.toJSONString(map));
            jgRegistrationHistoryService.update(jgRegistrationHistory, lambda);
        } else {
            jgRegistrationHistory.setChangeData(JSON.toJSONString(map));
            jgRegistrationHistory.setStatus("new");
            jgRegistrationHistory.setRegistrationClass("使用登记");
            jgRegistrationHistory.setSupervisoryCode(supervisoryCode);
            jgRegistrationHistory.setEquId(equipId);
            jgRegistrationHistory.setCurrentDocumentId(currentDocumentId);
            jgRegistrationHistoryService.save(jgRegistrationHistory);
        }

    }

    /**
     * 按单位办理或按台套办理
     *
     * @param map map
     * @return list
     */
    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public List<Map<String, Object>> save(JSONObject map) {
        Map<String, Function<JSONObject, List<Map<String, Object>>>> functionMap = MapBuilder.<String, Function<JSONObject, List<Map<String, Object>>>>create()
                .put("unit", this::handleUnitUseRegistration).build();
        Function<JSONObject, List<Map<String, Object>>> function = functionMap.getOrDefault(map.getString("manageType"), this::handleUseRegistration);
        return function.apply(map);
    }

    /**
     * 按台套办理
     *
     * @param map map
     * @return list
     */
    private List<Map<String, Object>> handleUseRegistration(JSONObject map) {
        try {
            ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
            CompanyBo company = reginParams.getCompany();
            // 提交时进行校验设备是否在流程中使用（并发及同时打开多个相同的页面时才会出现此种情况）
            checkForRepeatUsedEquip(map, company);
            // 使用登记信息
            JgUseRegistration jgUseRegistration = new JgUseRegistration();
            jgUseRegistration.setRegDate(new Date());
            LambdaQueryWrapper<IdxBizJgOtherInfo> otherLambda = new QueryWrapper<IdxBizJgOtherInfo>().lambda();
            otherLambda.eq(IdxBizJgOtherInfo::getRecord, map.get("equipId"));
            IdxBizJgOtherInfo otherInfo = otherInfoMapper.selectOne(otherLambda);
            String supervisoryCode = otherInfo.getSupervisoryCode();
            jgUseRegistration.setSupervisoryCode(supervisoryCode);

            if (!ObjectUtils.isEmpty(map.get("otherAccessories"))) {
                jgUseRegistration.setOtherAccessories(JSONObject.toJSONString(map.get("otherAccessories")));
            }
            String equType = this.baseMapper.getEquType(String.valueOf(map.get("equipId")));
            if (map.containsKey("receiveOrgCode")) {
                // 接收单位信息
                String[] splitMaintenanceUnitCode = String.valueOf(map.getString("receiveOrgCode")).split("_");
                jgUseRegistration.setReceiveCompanyCode(splitMaintenanceUnitCode[0]);
                jgUseRegistration.setReceiveOrgName(splitMaintenanceUnitCode[1]);
                jgUseRegistration.setReceiveCompanyOrgCode(commonService.getOneCompany(jgUseRegistration.getReceiveCompanyCode()).getOrgCode());
            }
            // 安全管理员
            if (map.containsKey("safetyManager")) {
                String[] data = String.valueOf(map.getString("safetyManager")).split("_");
                map.put("safetyManagerId", data[0]);
                map.put("safetyManagerName", data[1]);
            }
            // 使用单位提交
            jgUseRegistration.setUseUnitName(CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ?
                    company.getCompanyName().split("_")[1] : company.getCompanyName());
            jgUseRegistration.setUseUnitCreditCode(CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ?
                    company.getCompanyCode().split("_")[1] : company.getCompanyCode());
            jgUseRegistration.setCreateUserId(reginParams.getUserModel().getUserId());
            if (!ObjectUtils.isEmpty(map.get("inspectUnitCreditCode"))) {
                jgUseRegistration.setInspectUnitCreditCode(map.get("inspectUnitCreditCode").toString());
            }
            if (!ObjectUtils.isEmpty(map.get("inspectOrgName"))) {
                jgUseRegistration.setInspectUnitName(map.get("inspectOrgName").toString());
            }
            // 是否西咸
            if (!ObjectUtils.isEmpty(map.get("isXixian"))) {
                jgUseRegistration.setIsXixian(String.valueOf(map.get("isXixian")));
            }
            // 使用地点
            // 市
            List<LinkedHashMap> city = (List<LinkedHashMap>) redisUtils.get("CITY");
            // 区
            List<LinkedHashMap> region = (List<LinkedHashMap>) redisUtils.get("REGION");
            // 街道
            List<LinkedHashMap> street = (List<LinkedHashMap>) redisUtils.get("STREET");
            jgUseRegistration.setUseAddress("陕西省");
            // 城市
            if (!ObjectUtils.isEmpty(map.get("city")) && !ObjectUtils.isEmpty(city)) {
                city.forEach(item -> {
                    if (String.valueOf(item.get("regionCode")).equals(String.valueOf(map.get("city")))) {
                        jgUseRegistration.setUseAddress(jgUseRegistration.getUseAddress() + item.get("regionName"));
                    }
                });
            }
            // 区县
            if (!ObjectUtils.isEmpty(map.get("county")) && !ObjectUtils.isEmpty(city)) {
                region.forEach(item -> {
                    if (String.valueOf(item.get("regionCode")).equals(String.valueOf(map.get("county")))) {
                        jgUseRegistration.setUseAddress(jgUseRegistration.getUseAddress() + item.get("regionName"));
                    }
                });
            }
            // 街道
            if (!ObjectUtils.isEmpty(map.get("factoryUseSiteStreet")) && !ObjectUtils.isEmpty(city)) {
                street.forEach(item -> {
                    if (String.valueOf(item.get("regionCode")).equals(String.valueOf(map.get("factoryUseSiteStreet")))) {
                        jgUseRegistration.setUseAddress(jgUseRegistration.getUseAddress() + item.get("regionName"));
                    }
                });
            }
            jgUseRegistration.setUseAddress(jgUseRegistration.getUseAddress() + map.get("address"));
            if (map.containsKey("type") && "edit".equals(String.valueOf(map.get("type")))) {
                jgUseRegistration.setUseUnitCreditCode(null);
                jgUseRegistration.setSequenceNbr(Long.valueOf(String.valueOf(map.get("sequenceNbr"))));
                this.getBaseMapper().updateById(jgUseRegistration);
                // 更新设备关联表
                LambdaQueryWrapper<JgUseRegistrationEq> lambda = new QueryWrapper<JgUseRegistrationEq>().lambda();
                lambda.eq(JgUseRegistrationEq::getEquipTransferId, jgUseRegistration.getSequenceNbr());
                JgUseRegistrationEq jgUseRegistrationEq = new JgUseRegistrationEq();
                jgUseRegistrationEq.setEquId(map.get("equipId").toString());
                jgRelationEquipMapper.update(jgUseRegistrationEq, lambda);
            } else {

                // 业务管理设备信息保存
                JgUseRegistrationEq jgRelationEquip = new JgUseRegistrationEq();
                jgRelationEquip.setEquId(map.get("equipId").toString());
                //            List<String> applicationFormCode = iCreateCodeServicevice.createApplicationFormCode(ApplicationFormTypeEnum.SYDJ.getCode(), 1);
                //            jgUseRegistration.setApplyNo(applicationFormCode.get(0));
                //            ResponseModel<List<String>> listResponseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.SYDJ.getCode(), 1);
                ResponseModel<List<String>> listResponseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.getCode.get(String.valueOf(map.get("businessCode"))), 1);
                if (!ObjectUtils.isEmpty(listResponseModel)) {
                    jgUseRegistration.setApplyNo(listResponseModel.getResult().get(0));
                }
                jgUseRegistration.setAuditStatus("待提交");
                jgUseRegistration.setStatus(WorkFlowStatusEnum.USE_SUBMIT.getPass());
                this.save(jgUseRegistration);
                jgRelationEquip.setEquipTransferId(jgUseRegistration.getSequenceNbr().toString());
                jgRelationEquipMapper.insert(jgRelationEquip);
            }
            // 暂存历史表
            updateHistory(map, map.get("equipId").toString(), String.valueOf(jgUseRegistration.getSequenceNbr()), jgUseRegistration.getSupervisoryCode());
            if (!ObjectUtils.isEmpty(map.get("submit"))) {
                // 删除暂存代办
                commonServiceImpl.deleteTasksByRelationId(String.valueOf(jgUseRegistration.getSequenceNbr()));
                String instanceId = "";
                if (!ObjectUtils.isEmpty(map.get("instanceId"))) {
                    instanceId = map.get("instanceId").toString();
                } else {
                    // 启动并执行流程
                    //                instanceId = startByVariable();
                    ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
                    ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                    ArrayList<ActWorkflowStartDTO> list = new ArrayList<>();
                    dto.setProcessDefinitionKey(DEFINITION_KEY);
                    dto.setBusinessKey("1");
                    dto.setCompleteFirstTask(Boolean.TRUE);
                    // 接受机构
                    dto.setNextExecuteUserCompanyCode(jgUseRegistration.getReceiveCompanyCode());
                    list.add(dto);
                    actWorkflowBatchDTO.setProcess(list);
                    List<ProcessTaskDTO> processTaskDTOS = cmWorkflowService.startBatch(actWorkflowBatchDTO);
                    List<WorkflowResultDto> resultDto = commonServiceImpl.buildWorkFlowInfo(processTaskDTOS);
                    if (!ObjectUtils.isEmpty(resultDto) && !ObjectUtils.isEmpty(resultDto.get(0))) {
                        WorkflowResultDto workflowResultDto = resultDto.get(0);
                        updateData(jgUseRegistration.getSequenceNbr(), "0", workflowResultDto, "", Boolean.TRUE);
                    }

                }

                if (!ObjectUtils.isEmpty(instanceId)) {
                    // 执行流程
                    flowExecute(jgUseRegistration.getSequenceNbr(), instanceId, "0", "", "", map.getString("manageType"), String.valueOf(map.get("nextTaskId")));
                }
            } else {
                if (ObjectUtils.isEmpty(map.get("instanceId"))) {
                    ArrayList<TaskModelDto> list = new ArrayList<>();
                    TaskModelDto dto = new TaskModelDto();
                    TaskMessageDto taskMessageDto = new TaskMessageDto();
                    BeanUtil.copyProperties(jgUseRegistration, taskMessageDto);
                    taskMessageDto.setEquipId(String.valueOf(map.get("equipId")));
                    // 数据参数
                    dto.setModel(taskMessageDto);
                    // 摘要
                    dto.setTaskContent("来自" + equType + "【" + (ObjectUtils.isEmpty(jgUseRegistration.getSupervisoryCode()) ? "无" : jgUseRegistration.getSupervisoryCode()) + "】的业务办理");
                    // 申请单号
                    dto.setTaskCode(jgUseRegistration.getApplyNo());
                    // 业务类型
                    dto.setTaskType(String.valueOf(BusinessTypeEnum.JG_USAGE_REGISTRATION.getCode()));
                    // 业务主键
                    dto.setRelationId(String.valueOf(jgUseRegistration.getSequenceNbr()));
                    dto.setNextExecuteUser("");
                    list.add(dto);
                    commonServiceImpl.buildTaskModel(list);
                }
            }
            return this.baseMapper.getDetailById(jgUseRegistration.getSequenceNbr());
        } catch (BadRequest | LocalBadRequest e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw e;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw new BadRequest("使用登记保存失败！");
        } finally {
            FlowingEquipRedisContext.clean();
        }
    }

    private void rollBackForDelRedisData() {
        FlowingEquipRedisContext.getContext().forEach(e -> {
            EquipUsedCheckStrategyContext.getUsedStrategy("useRegister").delDataForCheckWithKey(e.getData(), e.getRedisKey());
        });
    }

    private void checkForRepeatUsedEquip(JSONObject map, CompanyBo company) {
        if (!ObjectUtils.isEmpty(map.get("submit"))) {
            // 流程中或已完成
            EquipUsedCheckStrategyContext.getUsedStrategy("useRegister").equipRepeatUsedCheck(map.get("equipId").toString(), company.getCompanyCode());
        }
    }

    private void checkForRepeatUsedEquip(JSONObject map, List<Map<String, Object>> equList, ReginParams reginParams) {
        if (!ObjectUtils.isEmpty(map.get("submit"))) {
            equList.forEach(equip -> {
                // 流程中或已完成
                EquipUsedCheckStrategyContext.getUsedStrategy("useRegister").equipRepeatUsedCheck(equip.get("record").toString(), reginParams.getCompany().getCompanyCode());
            });
        }
    }

    /**
     * 按单位办理
     *
     * @param map map
     * @return list
     */
    private List<Map<String, Object>> handleUnitUseRegistration(JSONObject map) {
        try {
            ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())) + "", ReginParams.class);
            CompanyBo company = reginParams.getCompany();

            List<Map<String, Object>> equipmentLists = (List<Map<String, Object>>) map.get("equipmentLists");
            if (CollectionUtils.isEmpty(equipmentLists) || equipmentLists.stream()
                    .map(v -> (String) v.get("equDefine"))
                    .distinct()
                    .count() != 1) {
                throw new BadRequest(CollectionUtils.isEmpty(equipmentLists) ? "请选择设备信息!" : "请选择相同设备品种！");
            }
            // 提交时进行校验设备是否在流程中使用（并发及同时打开多个相同的页面时才会出现此种情况）
            checkForRepeatUsedEquip(map, equipmentLists, reginParams);
            List<IdxBizJgInspectionDetectionInfo> inspectionDetectionInfoList = idxBizJgInspectionDetectionInfoService.checkInspectionInfo(
                    equipmentLists.stream()
                            .map(v -> (String) v.get("record"))
                            .collect(Collectors.toList())
            );
            if (!CylinderTypeEnum.CYLINDER.getCode().equals(map.get("EQU_CATEGORY_CODE")) && inspectionDetectionInfoList.stream().anyMatch(info ->
                    ObjectUtils.isEmpty(info) || ObjectUtils.isEmpty(info.getInspectType()) ||
                            ObjectUtils.isEmpty(info.getInspectConclusion()) || ObjectUtils.isEmpty(info.getInspectOrgCode()) ||
                            ObjectUtils.isEmpty(info.getInspectOrgName()))) {
                throw new BadRequest("请补充设备检验检测信息后提交！");
            }

            JgUseRegistration useRegistration = JSON.parseObject(JSON.toJSONString(map), JgUseRegistration.class);
            useRegistration.setRegDate(new Date());
            useRegistration.setManageType(map.getString("manageType"));
            useRegistration.setPromoter(reginParams.getUserModel().getUserId());
            useRegistration.setCreateUserId(reginParams.getUserModel().getUserId());
            // 使用单位信息
            useRegistration.setUseUnitName(CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ?
                    company.getCompanyName().split("_")[1] : company.getCompanyName());
            useRegistration.setUseUnitCreditCode(CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ?
                    company.getCompanyCode().split("_")[1] : company.getCompanyCode());
            // 接收单位信息
            Optional.ofNullable(useRegistration.getReceiveOrgCode())
                    .filter(code -> code.contains("_"))
                    .map(code -> code.split("_"))
                    .ifPresent(splitReceiveOrgCode -> {
                        CompanyModel result = Privilege.companyClient.queryByCompanyCode(splitReceiveOrgCode[0]).getResult();
                        useRegistration.setReceiveOrgCode(splitReceiveOrgCode[0]);
                        useRegistration.setReceiveCompanyOrgCode(splitReceiveOrgCode[0]);
                        useRegistration.setReceiveCompanyCode(result.getCompanyCode());
                        useRegistration.setReceiveOrgName(splitReceiveOrgCode[1]);
                    });

            // 安全管理员
            Optional.ofNullable(map.getString("safetyManager"))
                    .filter(manager -> manager.contains("_"))
                    .map(manager -> manager.split("_"))
                    .ifPresent(data -> {
                        map.put("safetyManagerId", data[0]);
                        map.put("safetyManagerName", data[1]);
                    });

            // 其他附件
            if (!ObjectUtils.isEmpty(map.get("otherAccessories"))) {
                useRegistration.setOtherAccessories(JSONObject.toJSONString(map.get("otherAccessories")));
            }

            // 使用地点
            Map<String, List<LinkedHashMap>> locationMap = MapBuilder.<String, List<LinkedHashMap>>create()
                    .put("city", (List<LinkedHashMap>) redisUtils.get("CITY"))
                    .put("county", (List<LinkedHashMap>) redisUtils.get("REGION"))
                    .put("factoryUseSiteStreet", (List<LinkedHashMap>) redisUtils.get("STREET"))
                    .build();
            String fullAddress = locationMap.entrySet().stream()
                    .map(entry -> {
                        String mapKey = String.valueOf(map.get(entry.getKey()));
                        List<LinkedHashMap> locations = entry.getValue();
                        return (!ObjectUtils.isEmpty(mapKey) && !ObjectUtils.isEmpty(locations)) ?
                                locations.stream()
                                        .filter(item -> mapKey.equals(String.valueOf(item.get("regionCode"))))
                                        .map(item -> String.valueOf(item.get("regionName")))
                                        .findFirst()
                                        .orElse("") :
                                "";
                    })
                    .collect(Collectors.joining());

            // 具体地址
            useRegistration.setUseAddress("陕西省" + fullAddress + map.get("address"));

            // 新增或编辑保存
            if (StringUtils.isEmpty(useRegistration.getSequenceNbr())) {
                ResponseModel<List<String>> listResponseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.getCode.get(String.valueOf(map.get("businessCode"))), 1);
                if (!ObjectUtils.isEmpty(listResponseModel) && listResponseModel.getStatus() != HttpStatus.OK.value()) {
                    log.error("使用登记申请单单号获取失败！");
                    throw new BadRequest("使用登记申请单单号获取失败！");
                }
                useRegistration.setApplyNo(listResponseModel.getResult().get(0));
                useRegistration.setAuditStatus("待提交");
                useRegistration.setStatus(WorkFlowStatusEnum.USE_SUBMIT.getPass());
                this.save(useRegistration);
            } else {
                this.updateById(useRegistration);
                // 删除设备关联表记录
                jgRelationEquipMapper.delete(new QueryWrapper<JgUseRegistrationEq>().lambda().eq(JgUseRegistrationEq::getEquipTransferId, useRegistration.getSequenceNbr()));
            }
            // 更新关联气瓶信息
            List<JgUseRegistrationEq> equipList = equipmentLists.stream()
                    .map(x -> new JgUseRegistrationEq()
                            .setEquId(String.valueOf(x.get("record")))
                            .setEquipTransferId(String.valueOf(useRegistration.getSequenceNbr())))
                    .collect(Collectors.toList());
            // 保存关联设备信息
            jgUseRegistrationEqService.saveBatch(equipList);

            // 启动流程
            if (!ObjectUtils.isEmpty(map.get("submit"))) {
                // 删除暂存代办
                commonServiceImpl.deleteTasksByRelationId(String.valueOf(useRegistration.getSequenceNbr()));
                // 新增提交，没有instanceId需要发起流程
                if (StringUtils.isEmpty(useRegistration.getInstanceId())) {
                    ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                    dto.setProcessDefinitionKey(DEFINITION_KEY);
                    dto.setBusinessKey(useRegistration.getApplyNo());
                    dto.setCompleteFirstTask(true);
                    dto.setNextExecuteUserCompanyCode(useRegistration.getReceiveCompanyCode());
                    ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
                    actWorkflowBatchDTO.setProcess(Collections.singletonList(dto));

                    List<ProcessTaskDTO> processTaskDTOS = cmWorkflowService.startBatch(actWorkflowBatchDTO);
                    List<WorkflowResultDto> resultDto = commonServiceImpl.buildWorkFlowInfo(processTaskDTOS);

                    resultDto.stream()
                            .findFirst()
                            .ifPresent(workflowResultDto ->
                                    this.updateUseRegUnitData(useRegistration.getSequenceNbr(), "0", workflowResultDto, true));
                } else {
                    // 执行流程
                    flowExecute(useRegistration.getSequenceNbr(), useRegistration.getInstanceId(), "0", "", "", map.getString("manageType"), String.valueOf(map.get("nextTaskId")));
                }
            } else {
                String equType = this.baseMapper.getEquType(String.valueOf(map.get("EQU_LIST_CODE")));
                TaskModelDto dto = TaskModelDto.builder()
                        .model(BeanUtil.copyProperties(useRegistration, TaskMessageDto.class))
                        .taskContent("来自" + equType + "【" + (ObjectUtils.isEmpty(useRegistration.getSupervisoryCode()) ? "无" : useRegistration.getSupervisoryCode()) + "】的业务办理")
                        .taskCode(useRegistration.getApplyNo())
                        .taskType(String.valueOf(BusinessTypeEnum.JG_USAGE_REGISTRATION.getCode()))
                        .relationId(String.valueOf(useRegistration.getSequenceNbr()))
                        .nextExecuteUser("")
                        .build();

                commonServiceImpl.buildTaskModel(Collections.singletonList(dto));
            }
            // 设备数据存历史数据，在流程完成时使用
            updateHistory(map, null, String.valueOf(useRegistration.getSequenceNbr()), useRegistration.getSupervisoryCode());
            return this.baseMapper.getDetailById(useRegistration.getSequenceNbr());
        } catch (BadRequest | LocalBadRequest e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw e;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw new BadRequest("使用登记保存失败！");
        } finally {
            FlowingEquipRedisContext.clean();
        }
    }

    /**
     * 单位批量办理数据处理
     *
     * @param sequenceNbr       主键
     * @param operate           操作类型
     * @param workflowResultDto 工作流返回
     * @param isFirst           是否first
     */
    private void updateUseRegUnitData(Long sequenceNbr, String operate, WorkflowResultDto workflowResultDto, Boolean isFirst) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())) + "", ReginParams.class);
        String role = workflowResultDto.getNextExecutorRoleIds();
        String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
        if (!ObjectUtils.isEmpty(workflowResultDto.getNextTaskCode())) {
            taskCode = workflowResultDto.getNextTaskCode();
        }
        JgUseRegistration jgUseRegistration = this.getBaseMapper().selectById(sequenceNbr);
        jgUseRegistration.setNextTaskId(workflowResultDto.getNextTaskId());
        jgUseRegistration.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
        if (isFirst) {
            jgUseRegistration.setInstanceStatus(workflowResultDto.getExecutorRoleIds());
            jgUseRegistration.setInstanceId(workflowResultDto.getInstanceId());
        }

        // 非完成，进行审核
        if (!FlowStatusEnum.TO_BE_FINISHED.getName().equals(taskCode)) {
            jgUseRegistration.setNextExecuteIds(role);
            jgUseRegistration.setInstanceStatus(
                    Optional.ofNullable(jgUseRegistration.getInstanceStatus())
                            .map(status -> String.join(",", status, role))
                            .orElse(role)
            );
            // 通过或者驳回
            jgUseRegistration.setStatus("0".equals(operate) ?
                    Objects.requireNonNull(WorkFlowStatusEnum.getMessage(taskCode)).getPass() :
                    Objects.requireNonNull(WorkFlowStatusEnum.getMessage(taskCode)).getReject());

            jgUseRegistration.setPromoter("0".equals(operate) ? reginParams.getUserModel().getUserId() : "");
            if (isFirst) {
                this.buildTask(jgUseRegistration, workflowResultDto);
            } else {
                // 更新代办状态
                HashMap<String, Object> params = new HashMap<>();
                params.put("relationId", jgUseRegistration.getInstanceId());
                params.put("flowStatus", commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
                params.put("flowStatusLabel", jgUseRegistration.getStatus());
                params.put("taskStatus", commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
                params.put("taskStatusLabel", jgUseRegistration.getStatus());
                TaskV2Model taskV2Model = commonServiceImpl.updateTaskModel(params);
                // 创建新的代办
                if (!ObjectUtils.isEmpty(taskV2Model)) {
                    TaskModelDto taskModelDto = new TaskModelDto();
                    BeanUtils.copyProperties(taskV2Model, taskModelDto);
                    TaskMessageDto taskMessageDto = new TaskMessageDto();
                    BeanUtil.copyProperties(jgUseRegistration, taskMessageDto);
                    // taskMessageDto.setEquipId(jgUseRegistrationEq.getEquId());
                    taskModelDto.setModel(taskMessageDto);
                    taskModelDto.setTaskName(workflowResultDto.getNextTaskName());
                    taskModelDto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                    taskModelDto.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
                    taskModelDto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
                    taskModelDto.setFlowCode(workflowResultDto.getNextTaskId());
                    if (WorkFlowStatusEnum.USE_SUBMIT.getCode().equals(taskCode) && "1".equals(operate)) {
                        taskModelDto.setPageType("edit");
                    }
                    commonServiceImpl.buildTaskModel(Collections.singletonList(taskModelDto));
                } else {
                    workflowResultDto.setInstanceId(jgUseRegistration.getInstanceId());
                    buildTask(jgUseRegistration, workflowResultDto);
                }
            }
        } else {
            // 流程结束
            jgUseRegistration.setStatus(taskCode);
            jgUseRegistration.setNextExecuteUserIds("");

            // 查询历史暂存表
            JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getOne(Wrappers.<JgRegistrationHistory>lambdaQuery()
                    .eq(JgRegistrationHistory::getCurrentDocumentId, String.valueOf(sequenceNbr)));

            JSONObject mapData = JSONObject.parseObject(jgRegistrationHistory.getChangeData());
            List<Map<String, Object>> equipmentLists = (List<Map<String, Object>>) mapData.get("equipmentLists");
            if (!CollectionUtils.isEmpty(equipmentLists)) {
                for (int i = 0; i < equipmentLists.size(); i++) {
                    Map<String, Object> equipment = equipmentLists.get(i);
                    mapData.put("equipId", equipment.get("record"));
                    mapData.put("isFirstEquip", i == 0);
                    processMapData(sequenceNbr, mapData, jgUseRegistration, jgRegistrationHistory);
                }
            }
        }
        this.getBaseMapper().updateById(jgUseRegistration);
        commonServiceImpl.saveExecuteFlowData2Redis(jgUseRegistration.getInstanceId(), this.buildInstanceRuntimeData(jgUseRegistration));
    }

    public JgUseRegistration updateData(Long sequenceNbr, String operate, WorkflowResultDto workflowResultDto, String carNumber, Boolean isFirst) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String role = workflowResultDto.getNextExecutorRoleIds();
        String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
        if (!ObjectUtils.isEmpty(workflowResultDto.getNextTaskCode())) {
            taskCode = workflowResultDto.getNextTaskCode();
        }
        JgUseRegistration jgUseRegistration = this.getBaseMapper().selectById(sequenceNbr);
        LambdaQueryWrapper<JgUseRegistrationEq> eq = new QueryWrapper<JgUseRegistrationEq>().lambda().eq(JgUseRegistrationEq::getEquipTransferId, sequenceNbr);
        JgUseRegistrationEq jgUseRegistrationEq = jgRelationEquipMapper.selectOne(eq);
        jgUseRegistration.setEquipId(jgUseRegistrationEq.getEquId());
        jgUseRegistration.setNextTaskId(workflowResultDto.getNextTaskId());
        jgUseRegistration.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());

        if (isFirst) {
            jgUseRegistration.setInstanceStatus(workflowResultDto.getExecutorRoleIds());
            jgUseRegistration.setInstanceId(workflowResultDto.getInstanceId());
        }
        if (!FlowStatusEnum.TO_BE_FINISHED.getName().equals(taskCode)) {
            jgUseRegistration.setNextExecuteIds(role);
            jgUseRegistration.setPromoter(reginParams.getUserModel().getUserId());
            if (!ObjectUtils.isEmpty(jgUseRegistration.getInstanceStatus())) {
                jgUseRegistration.setInstanceStatus(jgUseRegistration.getInstanceStatus() + "," + role);
            } else {
                jgUseRegistration.setInstanceStatus(role);
            }
            if ("0".equals(operate)) {
                // 通过操作
                jgUseRegistration.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getPass());
            } else {
                // 驳回操作
                jgUseRegistration.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getReject());
                jgUseRegistration.setPromoter("");
                // 如果 驳回到使用单位  厂车设备  有车牌号，清除车牌号
                // 避免出现以下情况：
                // 厂车使用登记 -》 使用单位提交 -》 一级填写了厂车车牌号，例如：场内陕AB1234，通过 -》 到二级或者三级，驳回到使用单位
                // -》 使用单位重新编辑提交，并且换了另一个设备 —-》 一级审批继续使用车牌号：场内陕AB1234，会出现车牌号已存在
                if (WorkFlowStatusEnum.USE_SUBMIT.getCode().equals(taskCode) && !ObjectUtils.isEmpty(carNumber)) {
                    idxBizJgRegisterInfoMapper.update(null, new UpdateWrapper<IdxBizJgRegisterInfo>().lambda()
                            .set(IdxBizJgRegisterInfo::getCarNumber, null)
                            .eq(IdxBizJgRegisterInfo::getRecord, jgUseRegistrationEq.getEquId()));
                }
            }
            if (isFirst) {
                buildTask(jgUseRegistration, workflowResultDto);
            } else {
                // 更新代办状态
                HashMap<String, Object> params = new HashMap<>();
                params.put("relationId", jgUseRegistration.getInstanceId());
                params.put("flowStatus", commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
                params.put("flowStatusLabel", jgUseRegistration.getStatus());
                params.put("taskStatus", commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
                params.put("taskStatusLabel", jgUseRegistration.getStatus());
                TaskV2Model taskV2Model = commonServiceImpl.updateTaskModel(params);
                // 创建新的代办
                if (!ObjectUtils.isEmpty(taskV2Model)) {
                    TaskModelDto taskModelDto = new TaskModelDto();
                    BeanUtils.copyProperties(taskV2Model, taskModelDto);
                    TaskMessageDto taskMessageDto = new TaskMessageDto();
                    BeanUtil.copyProperties(jgUseRegistration, taskMessageDto);
                    taskMessageDto.setEquipId(jgUseRegistrationEq.getEquId());
                    taskModelDto.setModel(taskMessageDto);
                    taskModelDto.setTaskName(workflowResultDto.getNextTaskName());
                    taskModelDto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                    taskModelDto.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
                    taskModelDto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
                    taskModelDto.setFlowCode(workflowResultDto.getNextTaskId());
                    if (WorkFlowStatusEnum.USE_SUBMIT.getCode().equals(taskCode) && "1".equals(operate)) {
                        taskModelDto.setPageType("edit");
                    }
                    commonServiceImpl.buildTaskModel(Collections.singletonList(taskModelDto));
                } else {
                    workflowResultDto.setInstanceId(jgUseRegistration.getInstanceId());
                    buildTask(jgUseRegistration, workflowResultDto);
                }
            }
        } else {
            // 流程结束
            jgUseRegistration.setStatus(taskCode);
            jgUseRegistration.setNextExecuteUserIds("");

            LambdaQueryWrapper<JgRegistrationHistory> lambdaSelect = new QueryWrapper<JgRegistrationHistory>().lambda();
            lambdaSelect.eq(JgRegistrationHistory::getCurrentDocumentId, String.valueOf(sequenceNbr));
            JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper().selectOne(lambdaSelect);
            JSONObject mapData = JSONObject.parseObject(jgRegistrationHistory.getChangeData());
            processMapData(sequenceNbr, mapData, jgUseRegistration, jgRegistrationHistory);
        }
        this.getBaseMapper().updateById(jgUseRegistration);
        commonServiceImpl.saveExecuteFlowData2Redis(jgUseRegistration.getInstanceId(), this.buildInstanceRuntimeData(jgUseRegistration));
        return jgUseRegistration;
    }

    private void processMapData(Long sequenceNbr, JSONObject mapData, JgUseRegistration jgUseRegistration, JgRegistrationHistory jgRegistrationHistory) {
        // 其他信息
        LambdaQueryWrapper<IdxBizJgOtherInfo> lambdaOth = new QueryWrapper<IdxBizJgOtherInfo>().lambda();
        lambdaOth.eq(IdxBizJgOtherInfo::getRecord, String.valueOf(mapData.get("equipId")));
        IdxBizJgOtherInfo otherInfo = otherInfoMapper.selectOne(lambdaOth);
        jgUseRegistration.setSupervisoryCode(otherInfo.getSupervisoryCode());
        // 注册信息
        LambdaQueryWrapper<IdxBizJgRegisterInfo> lambdaReg = new QueryWrapper<IdxBizJgRegisterInfo>().lambda();
        lambdaReg.eq(IdxBizJgRegisterInfo::getRecord, String.valueOf(mapData.get("equipId")));
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoMapper.selectOne(lambdaReg);
        // 更新设备信息
        updateEquipMessage(String.valueOf(sequenceNbr), jgUseRegistration, mapData, registerInfo, otherInfo);
        // 生成使用登记证编号
        if (!ObjectUtils.isEmpty(jgUseRegistration.getSupervisoryCode())) {
            if ("unit".equals(jgUseRegistration.getManageType())) {
                if ((Boolean) mapData.get("isFirstEquip")) {
                    String code = commonServiceImpl.generateRegistrationCode(String.valueOf(mapData.get("equipId")), jgUseRegistration.getSupervisoryCode(), jgUseRegistration.getReceiveCompanyCode());
                    jgUseRegistration.setUseRegistrationCode(code);
                    jgUseRegistration.setAuditPassDate(new Date());
                    registerInfo.setUseOrgCode(code);
                    LambdaUpdateWrapper<IdxBizJgRegisterInfo> lambda = new UpdateWrapper<IdxBizJgRegisterInfo>().lambda();
                    lambda.eq(IdxBizJgRegisterInfo::getRecord, registerInfo.getRecord());
                    lambda.set(true, IdxBizJgRegisterInfo::getUseOrgCode, code);
                    // 新增页面选择无设备代码后，在审批通过后自动生成设备代码
                    this.justGenerateEquCode(lambda, registerInfo, jgUseRegistration.getReceiveCompanyCode(), mapData, jgRegistrationHistory);
                    idxBizJgRegisterInfoService.update(lambda);
                } else {
                    registerInfo.setUseOrgCode(jgUseRegistration.getUseRegistrationCode());
                    LambdaUpdateWrapper<IdxBizJgRegisterInfo> lambda = new UpdateWrapper<IdxBizJgRegisterInfo>().lambda();
                    lambda.eq(IdxBizJgRegisterInfo::getRecord, registerInfo.getRecord());
                    lambda.set(true, IdxBizJgRegisterInfo::getUseOrgCode, jgUseRegistration.getUseRegistrationCode());
                    // 新增页面选择无设备代码后，在审批通过后自动生成设备代码
                    this.justGenerateEquCode(lambda, registerInfo, jgUseRegistration.getReceiveCompanyCode(), mapData, jgRegistrationHistory);
                    idxBizJgRegisterInfoService.update(lambda);
                }
            } else {
                String code = commonServiceImpl.generateRegistrationCode(String.valueOf(mapData.get("equipId")), jgUseRegistration.getSupervisoryCode(), jgUseRegistration.getReceiveCompanyCode());
                jgUseRegistration.setUseRegistrationCode(code);
                jgUseRegistration.setAuditPassDate(new Date());
                registerInfo.setUseOrgCode(code);
                LambdaUpdateWrapper<IdxBizJgRegisterInfo> lambda = new UpdateWrapper<IdxBizJgRegisterInfo>().lambda();
                lambda.eq(IdxBizJgRegisterInfo::getRecord, registerInfo.getRecord());
                lambda.set(true, IdxBizJgRegisterInfo::getUseOrgCode, code);
                // 新增页面选择无设备代码后，在审批通过后自动生成设备代码
                this.justGenerateEquCode(lambda, registerInfo, jgUseRegistration.getReceiveCompanyCode(), mapData, jgRegistrationHistory);
                idxBizJgRegisterInfoService.update(lambda);
            }
        }
        // 使用信息
        LambdaQueryWrapper<IdxBizJgUseInfo> lambda = new QueryWrapper<IdxBizJgUseInfo>().lambda();
        lambda.eq(IdxBizJgUseInfo::getRecord, String.valueOf(mapData.get("equipId")));
        IdxBizJgUseInfo useInfo = useInfoMapper.selectOne(lambda);
        String usePlace = useInfo.getProvinceName() + "/" + useInfo.getCityName() + "/" + useInfo.getCountyName() + useInfo.getStreetName();
        // 更新es
        updateEsData(usePlace, mapData, otherInfo, jgUseRegistration);
        // 更新代办状态
        HashMap<String, Object> params = new HashMap<>();
        params.put("relationId", jgUseRegistration.getInstanceId());
        params.put("flowStatus", commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
        params.put("flowStatusLabel", jgUseRegistration.getStatus());
        params.put("taskStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
        params.put("taskStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
        TaskMessageDto taskMessageDto = new TaskMessageDto();
        BeanUtil.copyProperties(jgUseRegistration, taskMessageDto);
        taskMessageDto.setEquipId(String.valueOf(mapData.get("equipId")));
        params.put("model", taskMessageDto);
        TaskV2Model taskV2Model = commonServiceImpl.updateTaskModel(params);
        jgResumeInfoService.createWithModel(JgResumeInfoDto.builder()
                .applyNo(jgUseRegistration.getApplyNo())
                .businessType(BusinessTypeEnum.JG_USAGE_REGISTRATION.getName())
                .businessId(jgUseRegistration.getSequenceNbr() + "")
                .equId((String) mapData.get("equipId"))
                .approvalUnit(jgUseRegistration.getReceiveOrgName())
                .approvalUnitCode(jgUseRegistration.getReceiveCompanyCode())
                .status("正常")
                .routePath(taskV2Model.getRoutePath())
                .build());
    }

    /**
     * 系统类型的code 自动生成设备代码
     *
     * @param lambda                lambda
     * @param registerInfo          注册信息
     * @param receiveCompanyCode    接收机构行政区划代码
     * @param mapData               历史数据
     * @param jgRegistrationHistory 历史数据行数据
     */
    public void justGenerateEquCode(LambdaUpdateWrapper<IdxBizJgRegisterInfo> lambda, IdxBizJgRegisterInfo registerInfo, String receiveCompanyCode, JSONObject mapData, JgRegistrationHistory jgRegistrationHistory) {
        // 新增设备时选择无设备代码且在设备代码为空【未做安装告知（使用登记、安装告知会生成设备代码）】
        if (EquCodeTypeEnum.SYSTEM_GENERATED.getCode().equals(registerInfo.getEquCodeType()) && StringUtils.isEmpty(registerInfo.getEquCode())) {
            // 更新注册信息表的设备代码字段
            String equCode = this.getEquCode(registerInfo, receiveCompanyCode);
            registerInfo.setEquCode(equCode);
            mapData.put("equCode", equCode);
            lambda.set(true, IdxBizJgRegisterInfo::getEquCode, equCode);
        }
    }

    private String getEquCode(IdxBizJgRegisterInfo registerInfo, String receiveCompanyCode) {
        ProduceInfo produceInfo = produceInfoMapper.selectOne(new LambdaQueryWrapper<ProduceInfo>().eq(AbstractEquipBaseEntity::getRecord, registerInfo.getRecord()));
        CodeGenerateDto codeGenerateDto = new CodeGenerateDto();
        codeGenerateDto.setEquList(registerInfo.getEquList());
        codeGenerateDto.setEquCategory(registerInfo.getEquCategory());
        codeGenerateDto.setEquDefine(registerInfo.getEquDefine());
        codeGenerateDto.setProduceDate(produceInfo.getProduceDate());
        codeGenerateDto.setReceiveCompanyCode(receiveCompanyCode);
        return codeUtil.generateEquipmentCode(codeGenerateDto);
    }

    public void updateEsData(String usePlace, JSONObject dataMap, IdxBizJgOtherInfo otherInfo, JgUseRegistration jgUseRegistration) {
        // 属地监管部门拆分
        String orgBranch = (String) dataMap.getOrDefault("orgBranchCode", "_");
        String[] split = orgBranch.split("_");
        // 更新es
        HashMap<String, Map<String, Object>> objMap = new HashMap<>();
        HashMap<String, Object> param = new HashMap<>();
        param.put("SUPERVISORY_CODE", otherInfo.getSupervisoryCode());
        param.put("CODE96333", otherInfo.getCode96333());
        param.put("USE_UNIT_CREDIT_CODE", dataMap.get("useUnitCreditCode"));
        param.put("USE_UNIT_NAME", dataMap.get("useUnitName"));
        param.put("ADDRESS", dataMap.getOrDefault("address", ""));
        param.put("USE_PLACE", usePlace);
        param.put("STATUS", "已认领");
        param.put("EQU_STATE", 1);
        param.put("ORG_BRANCH_CODE", split[0]);
        param.put("ORG_BRANCH_NAME", split[1]);
        param.put("EQU_CODE", dataMap.get("equCode"));
        param.put("USE_ORG_CODE", jgUseRegistration.getUseRegistrationCode());
        objMap.put((String) dataMap.get("equipId"), param);
        tzsServiceFeignClient.commonUpdateEsDataByIds(objMap);
    }

    public InstanceRuntimeData buildInstanceRuntimeData(JgUseRegistration jgUseRegistration) {
        return InstanceRuntimeData.builder()
                .nextExecuteUserIds(jgUseRegistration.getNextExecuteUserIds())
                .promoter(jgUseRegistration.getPromoter())
                .nextTaskId(jgUseRegistration.getNextTaskId())
                .build();
    }

    public void buildTask(JgUseRegistration jgUseRegistration, WorkflowResultDto workflowResultDto) {
        // 代办消息
        ArrayList<TaskModelDto> list = new ArrayList<>();
        TaskModelDto dto = new TaskModelDto();
        dto.setTaskType(String.valueOf(BusinessTypeEnum.JG_USAGE_REGISTRATION.getCode()));
        dto.setTaskTypeLabel(BusinessTypeEnum.JG_USAGE_REGISTRATION.getName());
        dto.setFlowCreateDate(jgUseRegistration.getCreateDate());
        dto.setTaskName(workflowResultDto.getNextTaskName());
        dto.setTaskCode(workflowResultDto.getNextTaskCode());
        dto.setRelationId(workflowResultDto.getInstanceId());
        dto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
        dto.setTaskStatus(commonServiceImpl.getDictionaryCodeByName(WorkFlowStatusEnum.getMessage(workflowResultDto.getNextTaskCode()).getPass()));
        dto.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
        dto.setFlowStatus(commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
        dto.setFlowStatusLabel(jgUseRegistration.getStatus());
        dto.setStartUserId(jgUseRegistration.getCreateUserId());
        dto.setStartUser(jgUseRegistration.getRecUserName());
        dto.setStartUserCompanyName(jgUseRegistration.getUseUnitName());
        dto.setStartDate(new Date());
        jgUseRegistration.setInstanceId(workflowResultDto.getInstanceId());
        // 设备信息
        jgUseRegistration.setNextExecuteIds(workflowResultDto.getNextExecutorRoleIds());
        TaskMessageDto taskMessageDto = new TaskMessageDto();
        BeanUtil.copyProperties(jgUseRegistration, taskMessageDto);

        LambdaQueryWrapper<JgUseRegistrationEq> jgUseRegEqWrapper = new QueryWrapper<JgUseRegistrationEq>().lambda();
        jgUseRegEqWrapper.eq(JgUseRegistrationEq::getEquipTransferId, String.valueOf(jgUseRegistration.getSequenceNbr()));
        List<JgUseRegistrationEq> jgUseRegistrationEqList = jgRelationEquipMapper.selectList(jgUseRegEqWrapper);

        if (!jgUseRegistrationEqList.isEmpty()) {
            String equId = jgUseRegistrationEqList.get(0).getEquId();
            taskMessageDto.setEquipId(equId);
            dto.setTaskContent("来自" + this.getBaseMapper().getEquType(equId) + "【" + (ObjectUtils.isEmpty(jgUseRegistration.getSupervisoryCode()) ? "无" : jgUseRegistration.getSupervisoryCode()) + "】的业务办理");
        }
        dto.setModel(taskMessageDto);
        dto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
        dto.setFlowCode(jgUseRegistration.getNextTaskId());
        list.add(dto);
        commonServiceImpl.buildTaskModel(list);
    }

    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class, timeoutMills = 600000)
    public void flowExecute(Long id, String instanceId, String operate, String comment, String carNumber, String manageType, String nextTaskId) {
        String lockKey = CommonServiceImpl.buildJgExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 流程执行时，状态及权限校验
            commonService.checkForExecuteFlow(nextTaskId, instanceId);

            JgUseRegistration jgUseRegistration = this.getBaseMapper().selectById(id);

            if (!ObjectUtils.isEmpty(carNumber)) {
                // 更新安全追溯-场内车辆中的“车牌号字段” 保证唯一性
                LambdaQueryWrapper<JgUseRegistrationEq> eq = new QueryWrapper<JgUseRegistrationEq>().lambda()
                        .eq(JgUseRegistrationEq::getEquipTransferId, jgUseRegistration.getSequenceNbr());
                JgUseRegistrationEq jgUseRegistrationEq = jgRelationEquipMapper.selectOne(eq);
                LambdaQueryWrapper<IdxBizJgRegisterInfo> wrapper = new LambdaQueryWrapper<>();
                wrapper.eq(IdxBizJgRegisterInfo::getCarNumber, carNumber);
                wrapper.ne(!ObjectUtils.isEmpty(jgUseRegistrationEq.getEquId()), IdxBizJgRegisterInfo::getRecord, jgUseRegistrationEq.getEquId());
                Integer count = idxBizJgRegisterInfoMapper.selectCount(wrapper);
                if (count > 0) {
                    throw new BadRequest("车牌号已存在，请重新输入！");
                }

                LambdaUpdateWrapper<IdxBizJgRegisterInfo> updateWrapper = new UpdateWrapper<IdxBizJgRegisterInfo>().lambda()
                        .eq(IdxBizJgRegisterInfo::getRecord, jgUseRegistrationEq.getEquId());
                IdxBizJgRegisterInfo idxBizJgRegisterInfo = new IdxBizJgRegisterInfo();
                idxBizJgRegisterInfo.setCarNumber(carNumber);
                idxBizJgRegisterInfoMapper.update(idxBizJgRegisterInfo, updateWrapper);
            }
            // 组装信息
            TaskResultDTO dto = new TaskResultDTO();
            dto.setResultCode("approvalStatus");
            dto.setTaskId(jgUseRegistration.getNextTaskId());
            dto.setComment(comment);
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", operate);
            if (jgUseRegistration.getStatus().equals(WorkFlowStatusEnum.USE_SUBMIT.getReject()) || jgUseRegistration.getStatus().equals(WorkFlowStatusEnum.USE_SUBMIT.getRollBack())) {
                map.put("approvalStatus", "提交");
            }
            dto.setVariable(map);
            // 接受机构
            if ("1".equals(operate) && WorkFlowStatusEnum.USE_RECEIVE.getPass().equals(jgUseRegistration.getStatus())) {
                // 驳回到使用单位
                dto.setNextExecuteUserCompanyCode(jgUseRegistration.getUseUnitCreditCode());
            } else {
                dto.setNextExecuteUserCompanyCode(jgUseRegistration.getReceiveCompanyCode());
            }
            ProcessTaskDTO complete = cmWorkflowService.completeOrReject(jgUseRegistration.getNextTaskId(), dto, operate);
            ArrayList<ProcessTaskDTO> processTaskDTOS = new ArrayList<>();
            processTaskDTOS.add(complete);
            List<WorkflowResultDto> resultDto = commonServiceImpl.buildWorkFlowInfo(processTaskDTOS);
            if (!ObjectUtils.isEmpty(resultDto) && !ObjectUtils.isEmpty(resultDto.get(0))) {
                WorkflowResultDto workflowResultDto = resultDto.get(0);
                // 按单位办理
                if ("unit".equals(manageType)) {
                    this.updateUseRegUnitData(jgUseRegistration.getSequenceNbr(), operate, workflowResultDto, false);
                } else {
                    this.updateData(jgUseRegistration.getSequenceNbr(), operate, workflowResultDto, carNumber, false);
                }
            }
            this.clearDataForCheckEquipRepeatUsed(jgUseRegistration);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public void withdraw(String instanceId, String nextTaskId, String manageType) {
        String lockKey = CommonServiceImpl.buildJgExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 撤回校验
            commonServiceImpl.checkForRevocationFlow(nextTaskId, instanceId);

            JgUseRegistration jgUseRegistration = new JgUseRegistration();
            ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
            ProcessTaskDTO processTaskDTO = cmWorkflowService.rollBack(instanceId);
            ArrayList<ProcessTaskDTO> processTaskDTOS = new ArrayList<>();
            processTaskDTOS.add(processTaskDTO);
            List<WorkflowResultDto> resultDto = commonServiceImpl.buildWorkFlowInfo(processTaskDTOS);
            String taskCode = "";
            String roles = "";
            if (!ObjectUtils.isEmpty(resultDto) && !ObjectUtils.isEmpty(resultDto.get(0))) {
                taskCode = resultDto.get(0).getNextTaskCode();
                roles = resultDto.get(0).getNextExecutorRoleIds();
                jgUseRegistration.setNextTaskId(resultDto.get(0).getNextTaskId());
                jgUseRegistration.setNextExecuteUserIds(resultDto.get(0).getNextExecutorUserIds());
            }
            LambdaQueryWrapper<JgUseRegistration> lambda = new QueryWrapper<JgUseRegistration>().lambda();
            lambda.eq(JgUseRegistration::getInstanceId, instanceId);
            if (!ObjectUtils.isEmpty(taskCode)) {
                jgUseRegistration.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getRollBack());
            }
            jgUseRegistration.setPromoter(reginParams.getUserModel().getUserId());
            jgUseRegistration.setNextExecuteIds(roles);
            this.update(jgUseRegistration, lambda);
            LambdaQueryWrapper<JgUseRegistration> queryWrapper = new QueryWrapper<JgUseRegistration>().lambda();
            queryWrapper.eq(JgUseRegistration::getInstanceId, instanceId);
            JgUseRegistration data = this.baseMapper.selectOne(queryWrapper);
            // 设备信息
            JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(data));
            jsonObject.put("nextTaskId", data.getNextTaskId());
            jsonObject.put("nextExecuteUser", data.getNextExecuteIds());
            jsonObject.put("taskType", BusinessTypeEnum.JG_USAGE_REGISTRATION.getCode());
            jsonObject.put("flowStatus", commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
            jsonObject.put("flowStatusLabel", jgUseRegistration.getStatus());
            // 非单位办理
            if (!"unit".equals(manageType)) {
                LambdaQueryWrapper<JgUseRegistrationEq> lambda1 = new QueryWrapper<JgUseRegistrationEq>().lambda();
                lambda1.eq(JgUseRegistrationEq::getEquipTransferId, String.valueOf(data.getSequenceNbr()));
                JgUseRegistrationEq jgUseRegistrationEq = jgRelationEquipMapper.selectOne(lambda1);
                jsonObject.put("equipId", jgUseRegistrationEq.getEquId());
            }
            if (!WorkFlowStatusEnum.USE_SUBMIT.getCode().equals(taskCode)) {
                jsonObject.put("pageType", "look");
            }
            // 撤回删除代办
            commonServiceImpl.rollbackTask(instanceId, jsonObject);
            // redis流程实时数据更新
            commonServiceImpl.saveExecuteFlowData2Redis(instanceId, this.buildInstanceRuntimeData(data));
            this.clearDataForCheckEquipRepeatUsed(data);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    private void clearDataForCheckEquipRepeatUsed(JgUseRegistration useRegistration) {
        // 新查询原因 useRegistration 数据状态是旧的
        JgUseRegistration useRegistrationDb = this.getById(useRegistration.getSequenceNbr());
        LambdaQueryWrapper<JgUseRegistrationEq> lambda = new QueryWrapper<JgUseRegistrationEq>().lambda();
        lambda.eq(JgUseRegistrationEq::getEquipTransferId, useRegistration.getSequenceNbr());
        lambda.select(JgUseRegistrationEq::getEquId);
        List<JgUseRegistrationEq> eqList = jgRelationEquipMapper.selectList(lambda);
        // 在使用单位待提交、一级受理已驳回、使用单位已撤回后清除关联的设备，保证可以再次新提单子选择相同的设备进行提交及原有单子的提交校验数据准备
        if (NOT_FLOWING_STATE.contains(useRegistrationDb.getStatus())) {
            List<String> records = eqList.stream().map(JgUseRegistrationEq::getEquId).collect(toList());
            EquipUsedCheckStrategyContext.getUsedStrategy("useRegister").delDataForCheckEquipRepeatUsed(records, useRegistration.getUseUnitCreditCode());
        }
    }

    public void deleteBatch(List<Long> ids) {
        JgUseRegistration jgUseRegistration = new JgUseRegistration();
        jgUseRegistration.setIsDelete(true);
        LambdaQueryWrapper<JgUseRegistration> lambda = new QueryWrapper<JgUseRegistration>().lambda();
        lambda.in(JgUseRegistration::getSequenceNbr, ids);
        // 删除暂存的待办
        ids.forEach(id -> {
            JgUseRegistration useRegistration = this.baseMapper.selectById(id);
            commonServiceImpl.deleteTaskModel(String.valueOf(id), useRegistration.getInstanceId());
        });
        this.update(jgUseRegistration, lambda);
    }

    public Map<String, Object> getDetail(String record, Long sequenceNbr) {
        if (!ObjectUtils.isEmpty(sequenceNbr)) {
            JgUseRegistration jgUseRegistration = this.getBaseMapper().selectById(sequenceNbr);
            LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
            lambda.eq(JgRegistrationHistory::getCurrentDocumentId, sequenceNbr);
            JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper().selectOne(lambda);
            JSONObject jsonObject = JSONObject.parseObject(jgRegistrationHistory.getChangeData());
            jsonObject.put("receiveOrgCode", jgUseRegistration.getReceiveCompanyCode() + "_" + jgUseRegistration.getReceiveOrgName());
            jsonObject.put("status", jgUseRegistration.getStatus());
            jsonObject.put("applyNo", jgUseRegistration.getApplyNo());
            jsonObject.remove("submit");
            jsonObject.remove("instanceId");
            if (!"unit".equals(jgUseRegistration.getManageType())) {
                // 作废时（完成时）equipId 为空
                record = setDefaultRecord(jgUseRegistration, record);
                // 需求：当申请信息由于设备信息错误被驳回及撤回时显示的数据还是旧设备数据，导致该申请单无法使用
                // 解决方案：设备基本信息、制造信息、设计信息、安装信息、维保信息，已完成时显示历史数据、非完成时显示最新设备数据
                this.fillHistoryDataWithNewEquip(jsonObject, jgUseRegistration, record);
                // 补充"车牌号"字段
                LambdaQueryWrapper<IdxBizJgRegisterInfo> wrapper = new QueryWrapper<IdxBizJgRegisterInfo>().lambda().eq(IdxBizJgRegisterInfo::getRecord, record);
                IdxBizJgRegisterInfo idxBizJgRegisterInfo = idxBizJgRegisterInfoMapper.selectOne(wrapper);
                jsonObject.put("carNumber", idxBizJgRegisterInfo.getCarNumber());
            } else {
                // 完成、作废时显示历史数据,其他状态显示实时数据
                if (!(jgUseRegistration.getStatus().equals(FlowStatusEnum.TO_BE_FINISHED.getName()) || jgUseRegistration.getStatus().equals(FlowStatusEnum.TO_BE_DISCARD.getName()))) {
                    List<Map<String, Object>> equipmentLists = (List<Map<String, Object>>) jsonObject.get("equipmentLists");
                    List<String> records = equipmentLists.stream().map(v -> (String) v.get("record")).collect(toList());
                    jsonObject.remove("equipmentLists");
                    if (CylinderTypeEnum.CYLINDER.getCode().equals(jsonObject.get("EQU_CATEGORY_CODE"))) {
                        List<DictionarieValueModel> fillingMedium = Systemctl.dictionarieClient.dictValues("FILLING_MEDIUM").getResult();
                        Map<String, Object> fillingMediumMap = fillingMedium.stream().collect(Collectors.toMap(DictionarieValueModel::getDictDataKey, DictionarieValueModel::getDictDataValue));
                        List<Map<String, Object>> result = jgUseRegistrationMapper.queryForUnitVesselEquipment(records);
                        result.forEach(i -> {
                            i.put("chargingMedium", fillingMediumMap.get(i.get("chargingMedium")));
                        });
                        jsonObject.put("equipmentLists", result);
                    } else {
                        jsonObject.put("equipmentLists", jgUseRegistrationMapper.queryForUnitPipelineEquipment(records));
                    }
                }
            }
            // 转化 附件 字段
            commonServiceImpl.convertStringToJsonobject(jsonObject, jsonFields);
            return jsonObject;
        }
        // 基本信息 + 制造信息
        Map<String, Object> detail = this.baseMapper.getDetail(record);
        // 监督管理信息
        Map<String, Object> supervisionInfo = this.baseMapper.getSupervisionInfoDetail(record);
        // 检验信息
        Map<String, Object> inspectDetail = this.getInspectDetail(record);
        // 使用信息
        Map<String, Object> useDetail = this.baseMapper.getUseDetail(record);
        // 设计信息
        Map<String, Object> desDetail = this.baseMapper.getDesDetail(record);
        // 安装信息
        Map<String, Object> installDetail = this.baseMapper.getiInstallDetail(record);
        // 维保信息
        Map<String, Object> maintenanceDetail = this.baseMapper.getMaintenanceDetail(record);
        if (!ObjectUtils.isEmpty(inspectDetail)) {
            detail.putAll(inspectDetail);
        }
        if (!ObjectUtils.isEmpty(useDetail)) {
            detail.putAll(useDetail);
        }
        if (!ObjectUtils.isEmpty(desDetail)) {
            detail.putAll(desDetail);
        }
        if (!ObjectUtils.isEmpty(maintenanceDetail)) {
            detail.putAll(maintenanceDetail);
        }
        if (!ObjectUtils.isEmpty(installDetail)) {
            detail.putAll(installDetail);
        }
        if (!ObjectUtils.isEmpty(supervisionInfo) && !StringUtils.isEmpty(supervisionInfo.get("orgBranchCode"))) {
            String orgBranchCode = (String) supervisionInfo.get("orgBranchCode");
            String orgBranchName = (String) supervisionInfo.get("orgBranchName");
            supervisionInfo.put("orgBranchCode", orgBranchCode + "_" + orgBranchName);
            supervisionInfo.put("hasOrgBranchCode", true);
            detail.putAll(supervisionInfo);
        }
        detail.remove("safetyManager");
        // 附件解析
        commonServiceImpl.convertStringToJsonobject(detail, jsonFields);
        detail.put("province", "610000");
        return detail;
    }

    private String setDefaultRecord(JgUseRegistration jgUseRegistration, String record) {
        if (StringUtils.isEmpty(record)) {
            JgUseRegistrationEq jgUseRegistrationEq = jgUseRegistrationEqService.getOne(new LambdaQueryWrapper<JgUseRegistrationEq>().eq(JgUseRegistrationEq::getEquipTransferId, jgUseRegistration.getSequenceNbr()));
            record = jgUseRegistrationEq.getEquId();
        }
        return record;
    }

    private Map<String, Object> getInspectDetail(String record) {
        LambdaQueryWrapper<IdxBizJgRegisterInfo> wrapper = new QueryWrapper<IdxBizJgRegisterInfo>().lambda().eq(IdxBizJgRegisterInfo::getRecord, record);
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoMapper.selectOne(wrapper);
        List<String> permissionInspectTypes = getInspectInfoByEquDefine(registerInfo.getEquList(), registerInfo.getEquCategory(), registerInfo.getEquDefine());
        if (permissionInspectTypes.size() > 0) {
            return this.baseMapper.getInspectDetail(record, permissionInspectTypes);
        } else {
            return null;
        }
    }

    private List<String> getInspectInfoByEquDefine(String equList, String equCategory, String equDefine) {
        List<String> permissionInspectTypes = new ArrayList<>();
        // 使用登记时：需要《首次检验》类型检验信息的设备种类、设备类别、设备品种
        String[] FIRST_INSPECT_EQULIST = {"5000"};
        String[] FIRST_INSPECT_EQUCATEGORY = {"4400", "4900", "4A00"};
        String[] FIRST_INSPECT_EQUDEFINE = {"4170"};
        // 使用登记时：需要《安装监督验》类型检验信息的设备种类、设备类别、设备品种
        String[] AZJDJY_INSPECT_EQULIST = {"3000", "6000", "9000", "8000", "1000"};
        String[] AZJDJY_INSPECT_EQUCATEGORY = {"4800", "4300", "4700", "4D00", "2400"};
        String[] AZJDJY_INSPECT_EQUDEFINE = {"4110", "4130", "4140", "4150", "4190", "4220", "4210", "4260", "4270", "4290"};
        // 使用登记时：需要《首次检验》或者《安装监督验检验》信息的设备种类、设备类别、设备品种
        String[] SCJY_OR_AZJDJY_EQULIST = {};
        String[] SCJY_OR_AZJDJY_EQUCATEGORY = {};
        String[] SCJY_OR_AZJDJY_INSPECT_EQUDEFINE = {"4230", "4240", "4250", "4280"};
        if (Arrays.asList(FIRST_INSPECT_EQULIST).contains(equList) || Arrays.asList(FIRST_INSPECT_EQUCATEGORY).contains(equCategory) || Arrays.asList(FIRST_INSPECT_EQUDEFINE).contains(equDefine)) {
            permissionInspectTypes.add("SCJY");
            return permissionInspectTypes;
        }
        if (Arrays.asList(AZJDJY_INSPECT_EQULIST).contains(equList) || Arrays.asList(AZJDJY_INSPECT_EQUCATEGORY).contains(equCategory) || Arrays.asList(AZJDJY_INSPECT_EQUDEFINE).contains(equDefine)) {
            permissionInspectTypes.add("AZJDJY");
            return permissionInspectTypes;
        }
        if (Arrays.asList(SCJY_OR_AZJDJY_EQULIST).contains(equList) || Arrays.asList(SCJY_OR_AZJDJY_EQUCATEGORY).contains(equCategory) || Arrays.asList(SCJY_OR_AZJDJY_INSPECT_EQUDEFINE).contains(equDefine)) {
            permissionInspectTypes.add("SCJY");
            permissionInspectTypes.add("AZJDJY");
            return permissionInspectTypes;
        }
        // 为空时不需要检验信息，不返回检验信息
        return permissionInspectTypes;
    }

    /**
     * 参数为监管码
     *
     * @param supervisoryCode
     * @return
     */
    public String getCode(String supervisoryCode) {
        if (!ObjectUtils.isEmpty(supervisoryCode) && supervisoryCode.length() > 5) {
            String name = EquipTypeEnum.getMessage(supervisoryCode.substring(1, 2));
            String type = supervisoryCode.substring(2, 4);
            String city = supervisoryCode.substring(0, 1);
            ResponseModel<String> stringResponseModel = tzsServiceFeignClient.useRegistrationCode(name + type + "陕" + city);
            return stringResponseModel.getResult();
        }
        return null;
    }

    public void exportUseRegistrationCertificate(String sequenceNbr, HttpServletResponse response, String printType) {
        Map<String, Object> exportParamsMap = new HashMap<>();
        // 查询使用登记详情
        JgUseRegistration useRegistration = this.getById(sequenceNbr);
        exportParamsMap.put("manageType", useRegistration.getManageType());
        LambdaQueryWrapper<JgUseRegistrationEq> useEqLambda = new QueryWrapper<JgUseRegistrationEq>().lambda();
        useEqLambda.eq(JgUseRegistrationEq::getEquipTransferId, sequenceNbr);
        List<JgUseRegistrationEq> useRegistrationEqList = jgRelationEquipMapper.selectList(useEqLambda);

        if (ValidationUtil.isEmpty(useRegistration) || ValidationUtil.isEmpty(useRegistrationEqList)) {
            throw new BadRequest("使用登记证导出失败,请稍后重试!");
        }
        // 登记机关
        if (ValidationUtil.isEmpty(useRegistration.getReceiveOrgName())) {
            throw new BadRequest("使用登记证导出失败,登记机关为空!");
        }
        exportParamsMap.put("receiveOrgName", useRegistration.getReceiveOrgName());
        // 使用登记证编号
        if (ValidationUtil.isEmpty(useRegistration.getUseRegistrationCode())) {
            throw new BadRequest("使用登记证导出失败,使用登记证编号为空!");
        }
        exportParamsMap.put("useRegistrationCode", useRegistration.getUseRegistrationCode());
        // 使用单位名称
        if (ValidationUtil.isEmpty(useRegistration.getUseUnitName())) {
            throw new BadRequest("使用登记证导出失败,使用单位名称为空!");
        }
        exportParamsMap.put("useUnitName", useRegistration.getUseUnitName());

        // 监管码
        if (ValidationUtil.isEmpty(useRegistration.getSupervisoryCode())) {
            throw new BadRequest("使用登记证导出失败,监管码为空!");
        }
        exportParamsMap.put("supervisoryCode", useRegistration.getSupervisoryCode());
        getAuditPassedDate(useRegistration.getAuditPassDate(), exportParamsMap);

        // 查询设备注册信息
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoService.getOne(new QueryWrapper<IdxBizJgRegisterInfo>().eq("RECORD", useRegistrationEqList.get(0).getEquId()));
        if (!ValidationUtil.isEmpty(registerInfo)) {
            // 设备种类、类别、品种
            String equList = registerInfo.getEquList();// 设备种类
            String equCategory = registerInfo.getEquCategory();// 设备类别
            String equDefine = registerInfo.getEquDefine();// 设备品种
            List<EquipmentCategory> categoryList0 = commonService.getEquipmentCategoryList(equList, null);
            List<EquipmentCategory> categoryList1 = commonService.getEquipmentCategoryList(equCategory, null);
            List<EquipmentCategory> categoryList2 = commonService.getEquipmentCategoryList(equDefine, null);
            if (CollectionUtils.isNotEmpty(categoryList0)) {
                if (ValidationUtil.isEmpty(categoryList0.get(0).getName())) {
                    throw new BadRequest("使用登记证导出失败,设备种类为空!");
                }
                exportParamsMap.put("equList", categoryList0.get(0).getName());
            }
            if (CollectionUtils.isNotEmpty(categoryList1)) {
                if (ValidationUtil.isEmpty(categoryList1.get(0).getName())) {
                    throw new BadRequest("使用登记证导出失败,设备类别为空!");
                }
                exportParamsMap.put("equCategory", categoryList1.get(0).getName());
            }
            if (CollectionUtils.isNotEmpty(categoryList2)) {
                if (ValidationUtil.isEmpty(categoryList2.get(0).getName())) {
                    throw new BadRequest("使用登记证导出失败,设备品种为空!");
                }
                exportParamsMap.put("equDefine", categoryList2.get(0).getName());
            }
            // 设备代码
            if (ValidationUtil.isEmpty(registerInfo.getEquCode())) {
                throw new BadRequest("使用登记证导出失败,设备代码为空!");
            }
            exportParamsMap.put("equCode", registerInfo.getEquCode());
        }

        IdxBizJgUseInfo useInfo = idxBizJgUseInfoService.getOneData(useRegistrationEqList.get(0).getEquId());
        if (!ValidationUtil.isEmpty(useInfo)) {
            if (ValidationUtil.isEmpty(useInfo.getUseInnerCode())) {
                throw new BadRequest("使用登记证导出失败,设备单位内部编码为空!");
            }
            // 单位内部编码
            exportParamsMap.put("useInnerCode", useInfo.getUseInnerCode());
            // 设备使用地址
            String fullAddress = "";
            if (!ObjectUtils.isEmpty(useInfo.getProvinceName())) {
                fullAddress += useInfo.getProvinceName();
            }
            if (!ObjectUtils.isEmpty(useInfo.getCityName())) {
                fullAddress += useInfo.getCityName();
            }
            if (!ObjectUtils.isEmpty(useInfo.getCountyName())) {
                fullAddress += useInfo.getCountyName();
            }
            if (!ObjectUtils.isEmpty(useInfo.getStreetName())) {
                fullAddress += useInfo.getStreetName();
            }
            if (!ObjectUtils.isEmpty(useInfo.getAddress())) {
                fullAddress += useInfo.getAddress();
            }
            if (ValidationUtil.isEmpty(fullAddress)) {
                throw new BadRequest("使用登记证导出失败,设备使用地址为空!");
            }
            exportParamsMap.put("fullAddress", fullAddress);
        }
        IdxBizJgFactoryInfo factoryInfo = idxBizJgFactoryInfoService.getOneData(useRegistrationEqList.get(0).getEquId());
        // 产品编号(出厂编号)
        if (!ValidationUtil.isEmpty(factoryInfo)) {
            if (ValidationUtil.isEmpty(factoryInfo.getFactoryNum())) {
                throw new BadRequest("使用登记证导出失败,产品编号为空!");
            }
            exportParamsMap.put("factoryNum", factoryInfo.getFactoryNum());
        }
        exportParamsMap.put("applyNo", useRegistration.getApplyNo());
        if ("0".equals(printType)) {
            // 调用生成使用登记证
            commonService.generateCertificateReport(exportParamsMap, response);
        } else if ("1".equals(printType)) {
            // 套打
            // commonService.generatePdfPrint(exportParamsMap, response);
            commonService.generateCertificateReportDoc(exportParamsMap, response);
        } else if ("2".equals(printType)) {
            // 使用标志普通打印
            commonService.useFlagGenerate(this.buildUseFlagParamDto(useRegistration, registerInfo, factoryInfo, exportParamsMap), response);
        } else if ("3".equals(printType)) {
            // 使用标志套打
            commonService.fightUseFlagGenerate(this.buildUseFlagParamDto(useRegistration, registerInfo, factoryInfo, exportParamsMap), response);
        }
    }

    /**
     * 导出基本信息汇总表(工业管道/气瓶)
     *
     * @param sequenceNbr
     * @param response
     */
    public void exportSummaryBasicInfo(String sequenceNbr, HttpServletResponse response, String category) {
        // 总数
        double total;
        // 每页显示条数，默认 10
        int size = 10;
        LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
        lambda.eq(JgRegistrationHistory::getCurrentDocumentId, sequenceNbr);
        JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper().selectOne(lambda);
        JSONObject jsonObject = JSONObject.parseObject(jgRegistrationHistory.getChangeData());
        JSONArray equipmentLists = (JSONArray) jsonObject.get("equipmentLists");
        // 填充投用年月
        String useDateValue = (String) jsonObject.get("useDate");
        for (int i = 0; i < equipmentLists.size(); i++) {
            JSONObject equipmentItem = equipmentLists.getJSONObject(i);
            equipmentItem.put("useDate", timeToMonths(useDateValue));
        }
        total = equipmentLists.size();
        AgencyUserModel result = new AgencyUserModel();
        JgUseRegistration jgUseRegistration = jgUseRegistrationMapper.selectOne(new QueryWrapper<JgUseRegistration>().lambda()
                .eq(JgUseRegistration::getSequenceNbr, sequenceNbr));
        jsonObject.put("fullAddress", jgUseRegistration.getUseAddress());
        if (!ValidationUtil.isEmpty(jgUseRegistration.getCreateUserId())) {
            result = Privilege.agencyUserClient.queryByUserId(jgUseRegistration.getCreateUserId()).getResult();
        }
        if ("8300".equals(category)) {// 压力管道基本信息汇总表
            // 模板
            String wordPath = "PressurePipeBasicInformationSummary.ftl";
            // 文件名前缀
            String filePrefix = "压力管道基本信息汇总表_";
            // 压力包名称
            String customFileName = filePrefix + jgUseRegistration.getApplyNo() + ".zip";
            // 总页数
            int page = (int) Math.ceil(total / size);
            // 异步获取数据
            List<CompletableFuture<byte[]>> futures = pressurePipeDataPreparation(page, jsonObject, size, total, equipmentLists, wordPath, filePrefix, result);
            // byte[]压缩zip
            toZipFile(response, futures, filePrefix, customFileName);
        } else if ("2300".equals(category)) {// 气瓶基本信息汇总表
            // 模板
            String wordPath = "CylinderBasicInformationSummary.ftl";
            // 文件名前缀
            String filePrefix = "气瓶基本信息汇总表_";
            // 压力包名称
            String customFileName = filePrefix + jgUseRegistration.getApplyNo() + ".zip";
            // 总页数
            int page = (int) Math.ceil(total / size);
            // 异步获取数据
            List<CompletableFuture<byte[]>> futures = cylinderDataPreparation(page, jsonObject, size, total, equipmentLists, wordPath, filePrefix, result);
            // byte[]压缩zip
            toZipFile(response, futures, filePrefix, customFileName);
        }
    }

    /**
     * 将 年月日 日期转为 年月 格式返回
     *
     * @param originalDateStr
     * @return
     */
    private static String timeToMonths(String originalDateStr) {
        // 定义输入的日期格式
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        // 将字符串解析为LocalDate对象
        LocalDate date = LocalDate.parse(originalDateStr, inputFormatter);
        // 定义输出的日期格式
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM", Locale.CHINA);
        // 将LocalDate对象格式化为所需的字符串
        return date.format(outputFormatter);
    }

    /**
     * 气瓶数据
     *
     * @return
     */
    private List<CompletableFuture<byte[]>> cylinderDataPreparation(int page, JSONObject jsonObject, int size, double total, JSONArray equipmentLists, String wordPath, String filePrefix, AgencyUserModel result) {
        List<CompletableFuture<byte[]>> futures = IntStream.rangeClosed(1, page)
                .mapToObj(current -> CompletableFuture.supplyAsync(() -> {
                    Map<String, Object> exportParamsMap = new HashMap<>();
                    exportParamsMap.put("current", current);
                    exportParamsMap.put("page", page);
                    LocalDate currentDate = LocalDate.now();
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                    String formattedDate = currentDate.format(formatter);
                    exportParamsMap.put("printDate", formattedDate);
                    // 使用单位
                    exportParamsMap.put("useUnitName", jsonObject.get("useUnitName"));
                    // 联系电话
                    exportParamsMap.put("phone", ValidationUtil.isEmpty(result.getMobile()) ? "" : result.getMobile());
                    // 经办人
                    exportParamsMap.put("agent", ValidationUtil.isEmpty(result.getRealName()) ? "" : result.getRealName());
                    // 电子邮箱
                    exportParamsMap.put("email", ValidationUtil.isEmpty(result.getEmail()) ? "" : result.getEmail());
                    // 数据分页
                    int start = (current - 1) * size;
                    int end = ((current - 1) * size + size) < total ? (current - 1) * size + size : (int) total;
                    // 数据截取
                    List<Object> equData = equipmentLists.subList(start, end);
                    // 设备数据填充
                    this.fillInCylinderEquData(exportParamsMap, equData, size);
                    return commonService.generateSummaryOfCylinderInfo(exportParamsMap, wordPath, filePrefix);
                })).collect(Collectors.toList());
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[page])).join();
        return futures;
    }

    /**
     * 压力管道数据
     *
     * @return
     */
    private List<CompletableFuture<byte[]>> pressurePipeDataPreparation(int page, JSONObject jsonObject, int size, double total, JSONArray equipmentLists, String wordPath, String filePrefix, AgencyUserModel result) {
        List<CompletableFuture<byte[]>> futures = IntStream.rangeClosed(1, page)
                .mapToObj(current -> CompletableFuture.supplyAsync(() -> {
                    Map<String, Object> exportParamsMap = new HashMap<>();
                    exportParamsMap.put("current", current);
                    exportParamsMap.put("page", page);
                    LocalDate currentDate = LocalDate.now();
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                    String formattedDate = currentDate.format(formatter);
                    exportParamsMap.put("printDate", formattedDate);
                    // 使用单位
                    exportParamsMap.put("useUnitName", jsonObject.get("useUnitName"));
                    // 使用单位地址
                    exportParamsMap.put("fullAddress", jsonObject.get("fullAddress"));
                    // 工程（装置）名称 取第一个设备的技术参数”工程装置名称“
                    JSONObject eqJSON = (JSONObject) equipmentLists.get(0);
                    String eqId = !ValidationUtil.isEmpty(eqJSON) ? String.valueOf(eqJSON.get("record")) : "";
                    EquipTechParamPipeline equipTechParamPipeline = equipTechParamPipelineMapper.queryTechParamInUse(eqId);
                    String deviceName = Optional.ofNullable(equipTechParamPipeline)
                            .map(EquipTechParamPipeline::getDeviceName)
                            .filter(name -> !ValidationUtil.isEmpty(name))
                            .orElse("");
                    exportParamsMap.put("nameOfProjectDevice", deviceName);
                    // 安全管理部门
                    exportParamsMap.put("orgBranchName", String.valueOf(jsonObject.get("orgBranchCode")).split("_")[1]);
                    // 安全管理员
                    exportParamsMap.put("safetyManager", String.valueOf(jsonObject.get("safetyManager")).split("_")[1]);
                    // 联系电话
                    exportParamsMap.put("phone", ValidationUtil.isEmpty(result.getMobile()) ? "" : result.getMobile());
                    // 经办人
                    exportParamsMap.put("agent", ValidationUtil.isEmpty(result.getRealName()) ? "" : result.getRealName());
                    // 电子邮箱
                    exportParamsMap.put("email", ValidationUtil.isEmpty(result.getEmail()) ? "" : result.getEmail());
                    // 数据分页
                    int start = (current - 1) * size;
                    int end = ((current - 1) * size + size) < total ? (current - 1) * size + size : (int) total;
                    // 数据截取
                    List<Object> equData = equipmentLists.subList(start, end);
                    // 设备数据填充
                    this.pressurePipeEquData(exportParamsMap, equData, current, size);
                    return commonService.generateSummaryOfCylinderInfo(exportParamsMap, wordPath, filePrefix);
                })).collect(Collectors.toList());
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[page])).join();
        return futures;
    }

    /**
     * 气瓶设备数据填充
     */
    public void fillInCylinderEquData(Map<String, Object> exportParamsMap, List<Object> equData, int size) {

        String[] fieldNames = {"equDefineName", "factoryNum", "chargingMedium",
                "produceUnitName", "produceDate", "nominalWorkingPressure",
                "singleBottleVolume", "inspectDate", "nextInspectDate", "useInnerCode"};
        // 填充有效数据
        for (int curr = 0; curr < equData.size(); curr++) {
            JSONObject obj = (JSONObject) equData.get(curr);
            int serialNum = curr + 1;
            for (String fieldName : fieldNames) {
                exportParamsMap.put(fieldName + serialNum, ValidationUtil.isEmpty(obj.get(fieldName)) ? "" : obj.get(fieldName));
            }
        }

        // 填充剩余空白项至指定总页数
        for (int curr = equData.size(); curr < size; curr++) {
            int serialNum = curr + 1;
            for (String fieldName : fieldNames) {
                exportParamsMap.put(fieldName + serialNum, ""); // 使用空字符串填充空白项
            }
        }
    }

    /**
     * 压力管道设备数据填充
     */
    public void pressurePipeEquData(Map<String, Object> exportParamsMap, List<Object> equData, int current, int size) {

        String[] fieldNames = {"productName", "pipelineNumber", "deviceLevel", "designUnitName", "uscUnitName",
                "uscDate", "useDate", "nominalDiameter", "wallThickness", "pipeLength", "pressure", "temperature",
                "medium", "inspectConclusion", "inspectOrgName", "nextInspectDate", "inspectConclusion", "remarks"};
        // 填充有效数据
        for (int curr = 0; curr < equData.size(); curr++) {
            JSONObject obj = (JSONObject) equData.get(curr);
            int serialNum = curr + 1;
            for (String fieldName : fieldNames) {
                exportParamsMap.put("num" + serialNum, (current - 1) * size + (curr + 1));
                exportParamsMap.put(fieldName + serialNum, ValidationUtil.isEmpty(obj.get(fieldName)) ? "" : obj.get(fieldName));
            }
        }

        // 填充剩余空白项至指定总页数
        for (int curr = equData.size(); curr < size; curr++) {
            int serialNum = curr + 1;
            for (String fieldName : fieldNames) {
                exportParamsMap.put("num" + serialNum, "");
                exportParamsMap.put(fieldName + serialNum, ""); // 使用空字符串填充空白项
            }
        }
    }


    /**
     * 填充设备最新的数据至历史json
     *
     * @param jsonObject        历史json
     * @param jgUseRegistration 使用信息
     * @param record            设备唯一标识
     */
    private void fillHistoryDataWithNewEquip(JSONObject jsonObject, JgUseRegistration jgUseRegistration, String record) {
        // 非已完成、非作废时显示设备最新信息。前置需求：一个设备只能同时发起一个流程
        if (!(jgUseRegistration.getStatus().equals(FlowStatusEnum.TO_BE_FINISHED.getName()) || jgUseRegistration.getStatus().equals(FlowStatusEnum.TO_BE_DISCARD.getName()))) {
            // 基本信息 + 制造信息
            Map<String, Object> detail = this.baseMapper.getDetail(record);
            // 设计信息
            Map<String, Object> desDetail = this.baseMapper.getDesDetail(record);
            if (!ObjectUtils.isEmpty(desDetail)) {
                detail.putAll(desDetail);
            }
            // 安装信息
            Map<String, Object> installDetail = this.baseMapper.getiInstallDetail(record);
            // 维保信息
            Map<String, Object> maintenanceDetail = this.baseMapper.getMaintenanceDetail(record);
            if (!ObjectUtils.isEmpty(maintenanceDetail)) {
                detail.putAll(maintenanceDetail);
            }
            if (!ObjectUtils.isEmpty(installDetail)) {
                detail.putAll(installDetail);
            }
            jsonObject.putAll(detail);
        }
    }

    private UseFlagParamDto buildUseFlagParamDto(JgUseRegistration useRegistration, IdxBizJgRegisterInfo registerInfo, IdxBizJgFactoryInfo factoryInfo, Map<String, Object> exportParamsMap) {
        UseFlagParamDto useFlagParamDto = new UseFlagParamDto();
        useFlagParamDto.setReceiveCompanyCode(useRegistration.getReceiveCompanyCode());
        useFlagParamDto.setEquList(exportParamsMap.get("equList").toString());
        useFlagParamDto.setEquListCode(registerInfo.getEquList());
        useFlagParamDto.setEquipCode(registerInfo.getEquCode());
        useFlagParamDto.setEquipCategory(exportParamsMap.get("equCategory").toString());
        useFlagParamDto.setEquipDefine(Optional.ofNullable(exportParamsMap.get("equDefine"))
                .orElse(exportParamsMap.get("equCategory").toString())
                .toString());
        useFlagParamDto.setUseUnitName(exportParamsMap.get("useUnitName").toString());
        useFlagParamDto.setUseInnerCode(exportParamsMap.get("useInnerCode").toString());
        useFlagParamDto.setReceiveOrgName(useRegistration.getReceiveOrgName());
        useFlagParamDto.setUseRegistrationCode(exportParamsMap.get("useRegistrationCode").toString());
        useFlagParamDto.setFactoryNumber(factoryInfo.getFactoryNum());
        useFlagParamDto.setCarNumber(registerInfo.getCarNumber());
        useFlagParamDto.setApplyNo(useRegistration.getApplyNo());
        // 检验信息字段设置
        setInspectField(registerInfo, useFlagParamDto);
        // 电梯维保信息字段设置
        setMainInfoField(registerInfo, useFlagParamDto);
        // 车用气瓶专用字段 暂无数据源 需车用气瓶功能开发完成后进行
        useFlagParamDto.setCylinderNumOrVolume("");
        useFlagParamDto.setFillingMedium("");
        return useFlagParamDto;
    }

    private void setInspectField(IdxBizJgRegisterInfo registerInfo, UseFlagParamDto useFlagParamDto) {
        Map<String, Object> inspectDetail = this.baseMapper.getInspectDetail(registerInfo.getRecord(), null);
        useFlagParamDto.setInspectionUnitName(inspectDetail.get("inspectOrgName") == null ? "" : inspectDetail.get("inspectOrgName").toString());
        useFlagParamDto.setNextInspectionDate(inspectDetail.get("nextInspectDate") == null ? null : (Date) inspectDetail.get("nextInspectDate"));
    }

    private void setMainInfoField(IdxBizJgRegisterInfo registerInfo, UseFlagParamDto useFlagParamDto) {
        IdxBizJgMaintenanceRecordInfo idxBizJgMaintenanceRecordInfo = idxBizJgMaintenanceRecordInfoService.queryNewestDetailByRecord(registerInfo.getRecord());

        useFlagParamDto.setEmergencyTel(this.buildEmergencyTel(idxBizJgMaintenanceRecordInfo));
        useFlagParamDto.setMaintenanceUnitName(idxBizJgMaintenanceRecordInfo.getMeUnitName() == null ? "" : idxBizJgMaintenanceRecordInfo.getMeUnitName());
    }

    private String buildEmergencyTel(IdxBizJgMaintenanceRecordInfo idxBizJgMaintenanceRecordInfo) {
        if (StringUtil.isNotEmpty(idxBizJgMaintenanceRecordInfo.getMeMasterPhone()) && StringUtil.isNotEmpty(idxBizJgMaintenanceRecordInfo.getMeMaster1Phone())) {
            return idxBizJgMaintenanceRecordInfo.getMeMasterPhone() + "/" + idxBizJgMaintenanceRecordInfo.getMeMaster1Phone();
        }
        return StringUtil.isNotEmpty(idxBizJgMaintenanceRecordInfo.getMeMasterPhone()) ? idxBizJgMaintenanceRecordInfo.getMeMasterPhone() : StringUtil.isNotEmpty(idxBizJgMaintenanceRecordInfo.getMeMaster1Phone()) ? idxBizJgMaintenanceRecordInfo.getMeMaster1Phone() : "";
    }

    /**
     * 生成监管码、96333码
     */
    public void createCode(JSONObject dataMap, JgUseRegistration jgUseRegistration, IdxBizJgRegisterInfo
            registerInfo, IdxBizJgUseInfo useInfo, IdxBizJgOtherInfo otherInfo) {
        if (ObjectUtils.isEmpty(otherInfo.getSupervisoryCode())) {
            // 生成监管码、96333码
            Map<String, Object> map = new HashMap<>();
            map.put("cityCode", useInfo.getCity());
            map.put("countyCode", useInfo.getCounty());
            map.put("equCategory", registerInfo.getEquCategory());
            map.put("isXiXian", dataMap.get("isXixian"));
            ResponseModel<Map<String, Object>> code = tzsServiceFeignClient.createCode(map);
            Map<String, Object> result = code.getResult();
            if (!ObjectUtils.isEmpty(result)) {
                otherInfo.setSupervisoryCode(String.valueOf(result.get("superviseCode")));
                otherInfo.setCode96333(ObjectUtils.isEmpty(result.get("code96333")) ? null : String.valueOf(result.get("code96333")));
                // 更新使用登记业务表
                jgUseRegistration.setSupervisoryCode(String.valueOf(result.get("superviseCode")));
            }
        }
        otherInfo.setClaimStatus("已认领");
        otherInfoMapper.updateById(otherInfo);
    }

    /**
     * 使用登记单条作废
     *
     * @param sequenceNbr  唯一标识
     * @param cancelReason 作废原因
     * @return JgUseRegistration
     */
    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public JgUseRegistration cancelApplication(Long sequenceNbr, String cancelReason) {
        // 1.更新为已作废
        JgUseRegistration jgUseRegistration = this.getById(sequenceNbr);
        String oldStatus = jgUseRegistration.getStatus();
        jgUseRegistration.setStatus(FlowStatusEnum.TO_BE_DISCARD.getName());
        jgUseRegistration.setCancelReason(cancelReason);
        jgUseRegistration.setCancelDate(new Date());
        jgUseRegistration.setCancelUserId(RequestContext.getExeUserId());
        jgUseRegistration.setNextExecuteUserIds("");
        jgUseRegistration.setPromoter("");
        this.updateById(jgUseRegistration);
        // 2.更新关联的业务
        processElseDataByStatus(oldStatus, jgUseRegistration);
        return jgUseRegistration;
    }

    private void processElseDataByStatus(String flowStatus, JgUseRegistration jgUseRegistration) {
        switch (flowStatus) {
            case "使用单位待提交":
                // 1.删除暂存时生成的待办
                commonServiceImpl.deleteTasksByRelationId(jgUseRegistration.getSequenceNbr() + "");
                break;
            case "已完成":
                // 1.删除与设备的关系，设备可再次发起使用登记
                this.clearUseInfoOfEquip(jgUseRegistration);
                // 2.清空redis（缓存的流程中及已完成使用登记的设备）
                this.clearDataForCheckEquipRepeatUsed(jgUseRegistration);
                break;
            default:
                // 流程中
                // 1.待办任务更新为已完成
                this.finishedTask(jgUseRegistration);
                // 2.终止流程-工作流报错暂时注释掉
                cmWorkflowService.stopProcess(jgUseRegistration.getInstanceId(), jgUseRegistration.getCancelReason());
                // 3.清空redis（缓存的流程中及已完成使用登记的设备）
                this.clearDataForCheckEquipRepeatUsed(jgUseRegistration);

        }
    }

    private void clearUseInfoOfEquip(JgUseRegistration jgUseRegistration) {
        LambdaQueryWrapper<JgUseRegistrationEq> eqLambdaQueryWrapper = new LambdaQueryWrapper<JgUseRegistrationEq>().eq(JgUseRegistrationEq::getEquipTransferId, jgUseRegistration.getSequenceNbr());
        List<JgUseRegistrationEq> eqList = jgRelationEquipMapper.selectList(eqLambdaQueryWrapper);
        eqList.forEach(e -> {
            String record = e.getEquId();
            // 1.使用信息表部分字段赋空
            this.rollBackUseInfo(record);
            // 2.回滚更新idx_biz_jg_register_info表
            this.rollBackRegisterInfo(record);
            // 3.回滚更新idx_biz_jg_supervision_info表
            this.rollBackSupervisionInfo(record);
            // 4.es的EQU_STATE,  USE_ORG_CODE、ORG_BRANCH_CODE、ORG_BRANCH_NAME、STATUS
            this.rollBackForEquipEsInfo(record);
            // 5.检验检测流水表-找不到关系暂不更新（删除）
            // 6.idx_biz_jg_other_info表监管码、96333、claimStatus，监管码、96333、claimStatus
        });
    }

    private void rollBackForEquipEsInfo(String record) {
        Optional<ESEquipmentCategoryDto> optional = esEquipmentCategory.findById(record);
        if (optional.isPresent()) {
            ESEquipmentCategoryDto esEquipmentCategoryDto = optional.get();
            esEquipmentCategoryDto.setUSE_ORG_CODE(null);
            esEquipmentCategoryDto.setSTATUS(null);
            esEquipmentCategoryDto.setEQU_STATE(null);
            esEquipmentCategoryDto.setORG_BRANCH_CODE(null);
            esEquipmentCategoryDto.setORG_BRANCH_NAME(null);
            esEquipmentCategory.save(esEquipmentCategoryDto);
        }
    }

    private void rollBackSupervisionInfo(String record) {
        LambdaUpdateWrapper<IdxBizJgSupervisionInfo> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(IdxBizJgSupervisionInfo::getRecord, record);
        updateWrapper.set(IdxBizJgSupervisionInfo::getOrgBranchName, null);
        updateWrapper.set(IdxBizJgSupervisionInfo::getOrgBranchCode, null);
        updateWrapper.set(IdxBizJgSupervisionInfo::getCompanyOrgBranchCode, null);
        idxBizJgSupervisionInfoMapper.update(null, updateWrapper);
    }

    private void rollBackRegisterInfo(String record) {
        LambdaUpdateWrapper<IdxBizJgRegisterInfo> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(IdxBizJgRegisterInfo::getRecord, record);
        // 未注册，来源cb_data_dictionary type =  'ZC'
        updateWrapper.set(IdxBizJgRegisterInfo::getRegisterState, "6046");
        updateWrapper.set(IdxBizJgRegisterInfo::getUseOrgCode, null);
        updateWrapper.set(IdxBizJgRegisterInfo::getCarNumber, null);
        idxBizJgRegisterInfoService.update(updateWrapper);
    }

    private void rollBackUseInfo(String record) {
        LambdaUpdateWrapper<IdxBizJgUseInfo> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(IdxBizJgUseInfo::getRecord, record);
        updateWrapper.set(IdxBizJgUseInfo::getCity, null);
        updateWrapper.set(IdxBizJgUseInfo::getCityName, null);
        updateWrapper.set(IdxBizJgUseInfo::getCounty, null);
        updateWrapper.set(IdxBizJgUseInfo::getCountyName, null);
        updateWrapper.set(IdxBizJgUseInfo::getStreetName, null);
        updateWrapper.set(IdxBizJgUseInfo::getProvince, null);
        updateWrapper.set(IdxBizJgUseInfo::getProvinceName, null);
        updateWrapper.set(IdxBizJgUseInfo::getEquState, null);
        updateWrapper.set(IdxBizJgUseInfo::getEstateUnitCreditCode, null);
        updateWrapper.set(IdxBizJgUseInfo::getEstateUnitName, null);
        updateWrapper.set(IdxBizJgUseInfo::getUsePlace, null);
        updateWrapper.set(IdxBizJgUseInfo::getLongitudeLatitude, null);
        updateWrapper.set(IdxBizJgUseInfo::getAddress, null);
        updateWrapper.set(IdxBizJgUseInfo::getSafetyManageDt, null);
        updateWrapper.set(IdxBizJgUseInfo::getSafetyManagerId, null);
        updateWrapper.set(IdxBizJgUseInfo::getSafetyManager, null);
        updateWrapper.set(IdxBizJgUseInfo::getFactoryUseSiteStreet, null);
        useInfoMapper.update(null, updateWrapper);
    }


    private void finishedTask(JgUseRegistration jgUseRegistration) {
        HashMap<String, Object> taskMap = new HashMap<>();
        taskMap.put("taskStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
        taskMap.put("taskStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
        taskMap.put("flowStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
        taskMap.put("flowStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
        taskMap.put("relationId", jgUseRegistration.getInstanceId());
        TaskMessageDto taskMessageDto = new TaskMessageDto();
        jgUseRegistration.setOtherAccessories(null);
        BeanUtils.copyProperties(jgUseRegistration, taskMessageDto);
        taskMap.put("model", taskMessageDto);
        commonServiceImpl.updateTaskModel(taskMap);
    }

    public void correctWrongData(List<String> applayNoList) {
        List<JgUseRegistration> jgUseRegistrationList = jgUseRegistrationMapper.selectList(new LambdaQueryWrapper<JgUseRegistration>().in(JgUseRegistration::getApplyNo, applayNoList));
        jgUseRegistrationList.forEach(jgUseRegistration -> {
            WorkflowResultDto workflowResultDto = new WorkflowResultDto();
            workflowResultDto.setNextExecutorRoleIds(jgUseRegistration.getNextExecuteIds());
            workflowResultDto.setNextTaskCode("已完成");
            workflowResultDto.setNextTaskId(jgUseRegistration.getNextTaskId());
            workflowResultDto.setNextExecutorUserIds(jgUseRegistration.getNextExecuteUserIds());
            if (jgUseRegistration.getManageType().equals("unit")) {
                this.updateUseRegUnitData(jgUseRegistration.getSequenceNbr(), "0", workflowResultDto, false);
            } else {
                this.updateData(jgUseRegistration.getSequenceNbr(), "0", workflowResultDto, null, false);
            }
        });
    }

}