package com.yeejoin.amos.boot.module.jyjc.biz.listener;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Sequence;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplicationNoAcceptLog;
import com.yeejoin.amos.boot.module.jyjc.api.enums.JYJCTypeEnum;
import com.yeejoin.amos.boot.module.jyjc.api.enums.RequestTypeEnum;
import com.yeejoin.amos.boot.module.jyjc.api.enums.TopicEnum;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionApplicationNoAcceptLogMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.InspectionEquipInfoModel;
import com.yeejoin.amos.boot.module.jyjc.biz.event.listener.InspectionApplicationPushEventListener;
import com.yeejoin.amos.boot.module.jyjc.biz.listener.message.BizMessage;
import com.yeejoin.amos.boot.module.jyjc.biz.rule.InspectionEquipInfo;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.RuleCommonServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.RegistrationInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.UseInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.RegistrationInfoMapper;
import com.yeejoin.amos.component.robot.AmosRequestContext;
import com.yeejoin.amos.feign.rule.Rule;
import com.yeejoin.amos.feign.rule.model.FactBaseModel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.component.emq.EmqxListener;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import javax.annotation.PostConstruct;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;

import static com.alibaba.fastjson.JSON.parseObject;
import static com.alibaba.fastjson.JSON.toJSONString;
import static com.yeejoin.amos.boot.module.jyjc.api.enums.CategoryEnum.getCategoryByType;

/**
 * @author Administrator
 */
@Component
@Slf4j
public class InspectionOrgRefreshListener extends EmqxListener {
    private static final BlockingQueue<BizMessage> BLOCKING_QUEUE = new LinkedBlockingQueue<>();

    @Value("${inspection.rule.project-name:报检规则}")
    private String ruleName;

    @Autowired
    private EmqKeeper emqKeeper;

    @Autowired
    private AmosRequestContext amosRequestContext;

    @Autowired
    private RegistrationInfoMapper registrationInfoMapper;

    @Autowired
    private JyjcInspectionApplicationNoAcceptLogMapper inspectionApplicationNoAcceptLogMapper;

    @Autowired
    InspectionApplicationPushEventListener applicationPushEventListener;

    @Value("${spring.application.name}")
    private String applicationName;

    @Autowired
    Sequence sequence;

    private static final int REPEAT_TIME = 2;

    @Autowired
    RedisUtils redisUtils;

    @Autowired
    RuleCommonServiceImpl ruleCommonService;

    @Override
    public void processMessage(String topic, MqttMessage message) {
        if (log.isInfoEnabled()) {
            log.info("收到消息主题：{},消息内容：{}", topic, message.toString());
        }
        BLOCKING_QUEUE.add(new BizMessage(topic, message));
    }

    @PostConstruct
    public void init() throws Exception {
        emqKeeper.subscript(this.buildShareTopic(TopicEnum.INSPECTION_LIST_REFRESH.getTopic()), 2, this);
        Executors.newSingleThreadExecutor().submit(this::takeMsg);
    }

    private String buildShareTopic(String topic) {
        return "$share/" + applicationName + "/" + topic;
    }

    private void takeMsg() {
        while (true) {
            try {
                BizMessage bizMessage = BLOCKING_QUEUE.take();
                // 解决前端组件在属性变化时重复发送两次问题
                if (!redisUtils.hasKey(bizMessage.getTopic())) {
                    redisUtils.set(bizMessage.getTopic(), true, REPEAT_TIME);
                    processBizMessage(bizMessage);
                } else {
                    log.warn("消息在{}秒内重复，", REPEAT_TIME);
                }
            } catch (Exception e) {
                log.error("数据处理失败", e);
            }
        }
    }

    private void processBizMessage(BizMessage bizMessage) {
        byte[] payload = bizMessage.getMessage().getPayload();
        InspectionEquipInfoModel equipInfoModel = parseObject(new String(payload, StandardCharsets.UTF_8), InspectionEquipInfoModel.class);
        RegistrationInfo registrationInfo = fetchRegistrationInfo(equipInfoModel.getRecord());
        InspectionEquipInfo inspectionEquipInfo = new InspectionEquipInfo();
        if (registrationInfo == null) {
            log.warn("未找到设备，报检规则匹配流程结束！");
            return;
        }
        inspectionEquipInfo.setEquCategory(registrationInfo.getEquCategory());
        inspectionEquipInfo.setEquList(registrationInfo.getEquList());
        inspectionEquipInfo.setEquDefine(registrationInfo.getEquDefine());
        inspectionEquipInfo.setComponentKey(bizMessage.getTopic().split("/")[0]);
        inspectionEquipInfo.setInspectionType(equipInfoModel.getInspectionType());
        inspectionEquipInfo.setRecord(equipInfoModel.getRecord());
        inspectionEquipInfo.setBizType(getCategoryByType(JYJCTypeEnum.of(inspectionEquipInfo.getInspectionType())));
        inspectionEquipInfo.setUuid(sequence.nextId() + "");
        inspectionEquipInfo.setTechParams(this.getTechParams(registrationInfo));
        this.setReginInfo(inspectionEquipInfo, equipInfoModel.getRecord());
        JyjcInspectionApplicationNoAcceptLog jyjcInspectionApplicationNoAcceptLog = getLastNoAcceptLog(equipInfoModel);
        inspectionEquipInfo.setRequestType(this.buildRequestType(equipInfoModel, jyjcInspectionApplicationNoAcceptLog));
        inspectionEquipInfo.setLastNoAcceptInspectionCode(this.buildLastNoAcceptInspectionCode(jyjcInspectionApplicationNoAcceptLog));
        // 是否球罐 0 1 转 boolean
        inspectionEquipInfo.setIsBallValve(!"0".equals(registrationInfo.getWhetherSphericalTank()));
        touchRuleWithApi(inspectionEquipInfo);
    }

    private void setReginInfo(InspectionEquipInfo inspectionEquipInfo, String record) {
        UseInfo useInfo = ruleCommonService.getUseInfo(record);
        // 地市
        inspectionEquipInfo.setAreaCode(ruleCommonService.getArea(useInfo));
        // 区县
        inspectionEquipInfo.setDistrictOrCountyCode(ruleCommonService.getCounty(useInfo));
    }

    private String buildLastNoAcceptInspectionCode(JyjcInspectionApplicationNoAcceptLog jyjcInspectionApplicationNoAcceptLog) {
        if (jyjcInspectionApplicationNoAcceptLog != null) {
            return jyjcInspectionApplicationNoAcceptLog.getInspectionUnitCode();
        }
        return "";
    }


    private Map<String, Object> getTechParams(RegistrationInfo registrationInfo) {
        return applicationPushEventListener.populateEquipInfoWithTechParams(registrationInfo.getEquList(), registrationInfo.getRecord());
    }

    private String buildRequestType(InspectionEquipInfoModel equipInfoModel, JyjcInspectionApplicationNoAcceptLog jyjcInspectionApplicationNoAcceptLog) {
        // 工作台发起申请
        if (StringUtils.isEmpty(equipInfoModel.getAppSeq())) {
            return RequestTypeEnum.FIRST_REQUEST.getCode();
        }
        // 没有不予受理请求记录
        if (jyjcInspectionApplicationNoAcceptLog == null) {
            return RequestTypeEnum.FIRST_REQUEST.getCode();
        }
        // 有记录
        return RequestTypeEnum.NO_ACCEPT_REQUEST.getCode();
    }

    private JyjcInspectionApplicationNoAcceptLog getLastNoAcceptLog(InspectionEquipInfoModel equipInfoModel) {
        LambdaQueryWrapper<JyjcInspectionApplicationNoAcceptLog> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(JyjcInspectionApplicationNoAcceptLog::getApplicationSeq, equipInfoModel.getAppSeq());
        wrapper.orderByDesc(JyjcInspectionApplicationNoAcceptLog::getRecDate);
        wrapper.last("limit 1");
        wrapper.select(JyjcInspectionApplicationNoAcceptLog::getApplicationSeq, JyjcInspectionApplicationNoAcceptLog::getInspectionUnitCode);
        return inspectionApplicationNoAcceptLogMapper.selectOne(wrapper);
    }

    private RegistrationInfo fetchRegistrationInfo(String record) {
        return registrationInfoMapper.selectOne(
                Wrappers.<RegistrationInfo>lambdaQuery().select(RegistrationInfo::getRecord, RegistrationInfo::getEquCategory,
                        RegistrationInfo::getEquDefine, RegistrationInfo::getEquList, RegistrationInfo::getWhetherSphericalTank)
                        .eq(RegistrationInfo::getRecord, record));
    }

    private void touchRuleWithApi(InspectionEquipInfo inspectionEquipInfo) {
        if (log.isInfoEnabled()) {
            log.info("发送规则的消息对象:{}", toJSONString(inspectionEquipInfo));
        }
        try {
            RequestContext.setToken(amosRequestContext.getToken());
            RequestContext.setAppKey(amosRequestContext.getAppKey());
            RequestContext.setProduct(amosRequestContext.getProduct());
            HashMap<String, byte[]> factMap = new HashMap<>();
            List<Object> factList = new ArrayList<>();
            factList.add(inspectionEquipInfo);
            for (Object fact : factList) {
                factMap.put(fact.getClass().getName(), toJSONString(fact).getBytes());
            }
            FactBaseModel factBaseModel = new FactBaseModel();
            factBaseModel.setFactMap(factMap);
            factBaseModel.setPackageId(ruleName + "/" + inspectionEquipInfo.getBizType());
            factBaseModel.setProcessIds(null);
            if (log.isInfoEnabled()) {
                log.info("发送规则的消息对象:{},\n变量对象：{}", toJSONString(factBaseModel), toJSONString(factBaseModel));
            }
            Rule.ruleClient.fireRule(factBaseModel);
        } catch (Exception e) {
            log.error("调用规则触发获取报检规则失败", e);
        }
    }
}
