package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.sun.org.apache.regexp.internal.RE;
import com.yeejoin.amos.boot.module.ymt.api.entity.UseInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.UseInfoMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Arrays;

/**
 * @author Administrator
 */
@Component
public class RuleCommonServiceImpl {

    private UseInfoMapper useInfoMapper;

    /**
     * 特殊独立的区县
     */
    private static final String[] EXCLUSION_CITY_REGIONS = {"610403", "610581"};

    public RuleCommonServiceImpl(UseInfoMapper useInfoMapper) {
        this.useInfoMapper = useInfoMapper;
    }


    public String getArea(String record) {
        UseInfo equipUseInfo = useInfoMapper.selectOne(Wrappers.<UseInfo>lambdaQuery().select(UseInfo::getCity, UseInfo::getCounty).eq(UseInfo::getRecord, record));
        if (equipUseInfo == null) {
            return "";
        }
        // 特殊地区特殊处理，目前有韩城、杨凌,原因行政区划上是有层级的，但是业务办理时，他们与所在地市是同级别的
        if (StringUtils.isEmpty(equipUseInfo.getCity()) || StringUtils.isEmpty(equipUseInfo.getCounty())) {
            return "";
        }
        if (Arrays.asList(EXCLUSION_CITY_REGIONS).contains(equipUseInfo.getCounty())) {
            return equipUseInfo.getCounty();
        }
        return equipUseInfo.getCity();
    }


    public UseInfo getUseInfo(String record) {
        return useInfoMapper.selectOne(Wrappers.<UseInfo>lambdaQuery().select(UseInfo::getCity, UseInfo::getCounty).eq(UseInfo::getRecord, record));
    }

    public String getArea(UseInfo equipUseInfo) {
        if (equipUseInfo == null) {
            return "";
        }
        // 特殊地区特殊处理，目前有韩城、杨凌,原因行政区划上是有层级的，但是业务办理时，他们与所在地市是同级别的
        if (StringUtils.isEmpty(equipUseInfo.getCity()) || StringUtils.isEmpty(equipUseInfo.getCounty())) {
            return "";
        }
        if (Arrays.asList(EXCLUSION_CITY_REGIONS).contains(equipUseInfo.getCounty())) {
            return equipUseInfo.getCounty();
        }
        return equipUseInfo.getCity();
    }

    public String getCounty(UseInfo equipUseInfo) {
        if (equipUseInfo == null) {
            return "";
        }
        return equipUseInfo.getCounty();
    }

}
